/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.mail;

import com.blazebit.mail.MailResource;
import com.blazebit.mail.Recipient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.util.ByteArrayDataSource;

public class Mail {
    private Recipient from;
    private Recipient replyTo;
    private List<Recipient> recipients = new ArrayList<Recipient>();
    private String subject;
    private String text;
    private String html;
    private final List<MailResource> embeddedImages = new ArrayList<MailResource>();
    private final List<MailResource> attachments = new ArrayList<MailResource>();
    private final Map<String, String> headers = new HashMap<String, String>();

    public List<Recipient> getBcc() {
        return this.getRecipients(Message.RecipientType.BCC);
    }

    public void addBcc(String address) {
        this.addBcc(address, null);
    }

    public void addBcc(String[] addresses) {
        for (String address : addresses) {
            this.addBcc(address, null);
        }
    }

    public void addBcc(String address, String name) {
        this.addRecipient(address, name, Message.RecipientType.BCC);
    }

    public List<Recipient> getCc() {
        return this.getRecipients(Message.RecipientType.CC);
    }

    public void addCc(String address) {
        this.addCc(address, null);
    }

    public void addCc(String[] addresses) {
        for (String address : addresses) {
            this.addCc(address, null);
        }
    }

    public void addCc(String address, String name) {
        this.addRecipient(address, name, Message.RecipientType.CC);
    }

    public List<Recipient> getTo() {
        return this.getRecipients(Message.RecipientType.TO);
    }

    public void addTo(String address) {
        this.addCc(address, null);
    }

    public void addTo(String[] addresses) {
        for (String address : addresses) {
            this.addCc(address, null);
        }
    }

    public void addTo(String address, String name) {
        this.addRecipient(address, name, Message.RecipientType.TO);
    }

    private void addRecipient(String address, String name, Message.RecipientType type) {
        this.recipients.add(new Recipient(name, address, type));
    }

    private List<Recipient> getRecipients(Message.RecipientType type) {
        ArrayList<Recipient> ret = new ArrayList<Recipient>();
        for (Recipient r : this.recipients) {
            if (!r.getType().equals(type)) continue;
            ret.add(r);
        }
        return Collections.unmodifiableList(ret);
    }

    public List<Recipient> getRecipients() {
        return Collections.unmodifiableList(this.recipients);
    }

    public Recipient getFrom() {
        return this.from;
    }

    public void setFrom(String address) {
        this.setFrom(address, null);
    }

    public void setFrom(String address, String name) {
        this.from = new Recipient(name, address, null);
    }

    public Recipient getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String address) {
        this.setReplyTo(address, null);
    }

    public void setReplyTo(String address, String name) {
        this.replyTo = new Recipient(name, address, null);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public void addHeader(String name, Object value) {
        this.headers.put(name, String.valueOf(value));
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public List<MailResource> getEmbeddedImages() {
        return Collections.unmodifiableList(this.embeddedImages);
    }

    public void addEmbeddedImage(File f) throws FileNotFoundException, IOException {
        this.addEmbeddedImage(f.getName(), new FileInputStream(f));
    }

    public void addEmbeddedImages(File[] files) throws FileNotFoundException, IOException {
        for (File f : files) {
            this.addEmbeddedImage(f.getName(), new FileInputStream(f));
        }
    }

    public void addEmbeddedImage(String fileName, File f) throws FileNotFoundException, IOException {
        this.addEmbeddedImage(fileName, new FileInputStream(f));
    }

    public void addEmbeddedImage(File f, String mimeType) throws FileNotFoundException, IOException {
        this.addEmbeddedImage(f.getName(), new FileInputStream(f), mimeType);
    }

    public void addEmbeddedImage(String fileName, File f, String mimeType) throws FileNotFoundException, IOException {
        this.addEmbeddedImage(fileName, new FileInputStream(f), mimeType);
    }

    public void addEmbeddedImage(String fileName, InputStream f) throws IOException {
        this.addEmbeddedImage(fileName, Mail.toByteArray(f));
    }

    public void addEmbeddedImage(String fileName, InputStream f, String mimeType) throws IOException {
        this.addEmbeddedImage(fileName, Mail.toByteArray(f), mimeType);
    }

    public void addEmbeddedImage(String fileName, byte[] f) {
        this.addEmbeddedImage(fileName, f, "application/octet-stream");
    }

    public void addEmbeddedImage(String fileName, byte[] f, String mimeType) {
        ByteArrayDataSource ds = new ByteArrayDataSource(f, mimeType);
        ds.setName(fileName);
        this.embeddedImages.add(new MailResource(fileName, (DataSource)ds));
    }

    public List<MailResource> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    public void addAttachment(File f) throws FileNotFoundException, IOException {
        this.addAttachment(f.getName(), new FileInputStream(f));
    }

    public void addAttachment(File[] files) throws FileNotFoundException, IOException {
        for (File f : files) {
            this.addAttachment(f.getName(), new FileInputStream(f));
        }
    }

    public void addAttachment(String fileName, File f) throws FileNotFoundException, IOException {
        this.addAttachment(fileName, new FileInputStream(f));
    }

    public void addAttachment(File f, String mimeType) throws FileNotFoundException, IOException {
        this.addAttachment(f.getName(), new FileInputStream(f), mimeType);
    }

    public void addAttachment(String fileName, File f, String mimeType) throws FileNotFoundException, IOException {
        this.addAttachment(fileName, new FileInputStream(f), mimeType);
    }

    public void addAttachment(String fileName, InputStream f) throws IOException {
        this.addAttachment(fileName, Mail.toByteArray(f));
    }

    public void addAttachment(String fileName, InputStream f, String mimeType) throws IOException {
        this.addAttachment(fileName, Mail.toByteArray(f), mimeType);
    }

    public void addAttachment(String fileName, byte[] f) {
        this.addAttachment(fileName, f, "application/octet-stream");
    }

    public void addAttachment(String fileName, byte[] f, String mimeType) {
        ByteArrayDataSource ds = new ByteArrayDataSource(f, mimeType);
        ds.setName(fileName);
        this.attachments.add(new MailResource(fileName, (DataSource)ds));
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Mail.copy(input, output);
        return output.toByteArray();
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        long count = Mail.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

