/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.quartz;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

public class TriggerUtil {
    public static Trigger simple(String triggerName, String triggerGroup, JobDetail job, Map<String, ? extends Object> dataMap, Date start, Date end) {
        return TriggerUtil.simple(triggerName, triggerGroup, job.getKey().getName(), job.getKey().getGroup(), dataMap, start, end);
    }

    public static Trigger simple(String triggerName, String triggerGroup, String jobName, String jobGroup, Map<String, ? extends Object> dataMap, Date start, Date end) {
        return TriggerUtil.simple(triggerName, triggerGroup, jobName, jobGroup, dataMap, start, end, 0);
    }

    public static Trigger simple(String triggerName, String triggerGroup, String jobName, String jobGroup, Map<String, ? extends Object> dataMap, Date start, Date end, int repeat) {
        TriggerBuilder tb = TriggerBuilder.newTrigger().forJob(jobName, jobGroup);
        if (triggerName != null && !triggerName.isEmpty()) {
            if (triggerGroup != null && !triggerGroup.isEmpty()) {
                tb.withIdentity(triggerName, triggerGroup);
            } else {
                tb.withIdentity(triggerName);
            }
        } else if (triggerGroup != null && !triggerGroup.isEmpty()) {
            tb.withIdentity(UUID.randomUUID().toString(), triggerGroup);
        }
        if (start == null || start.before(new Date())) {
            tb.startNow();
        } else {
            tb.startAt(start);
        }
        if (end != null && end.after(new Date())) {
            tb.endAt(end);
        }
        if (dataMap != null && !dataMap.isEmpty()) {
            tb.usingJobData(new JobDataMap(dataMap));
        }
        if (repeat > 0) {
            tb.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(repeat));
        }
        return tb.build();
    }

    public static Trigger second(String triggerName, String triggerGroup, String jobName, String jobGroup, Map<String, ? extends Object> dataMap, int interval, Date start, Date end) {
        return TriggerUtil.interval(triggerName, triggerGroup, jobName, jobGroup, dataMap, interval, DateBuilder.IntervalUnit.SECOND, start, end);
    }

    public static Trigger minute(String triggerName, String triggerGroup, String jobName, String jobGroup, Map<String, ? extends Object> dataMap, int interval, Date start, Date end) {
        return TriggerUtil.interval(triggerName, triggerGroup, jobName, jobGroup, dataMap, interval, DateBuilder.IntervalUnit.MINUTE, start, end);
    }

    public static Trigger hour(String triggerName, String triggerGroup, String jobName, String jobGroup, Map<String, ? extends Object> dataMap, int interval, Date start, Date end) {
        return TriggerUtil.interval(triggerName, triggerGroup, jobName, jobGroup, dataMap, interval, DateBuilder.IntervalUnit.HOUR, start, end);
    }

    public static Trigger day(String triggerName, String triggerGroup, String jobName, String jobGroup, Map<String, ? extends Object> dataMap, int interval, Date start, Date end) {
        return TriggerUtil.interval(triggerName, triggerGroup, jobName, jobGroup, dataMap, interval, DateBuilder.IntervalUnit.DAY, start, end);
    }

    public static Trigger week(String triggerName, String triggerGroup, String jobName, String jobGroup, Map<String, ? extends Object> dataMap, int interval, Date start, Date end) {
        return TriggerUtil.interval(triggerName, triggerGroup, jobName, jobGroup, dataMap, interval, DateBuilder.IntervalUnit.WEEK, start, end);
    }

    public static Trigger month(String triggerName, String triggerGroup, String jobName, String jobGroup, Map<String, ? extends Object> dataMap, int interval, Date start, Date end) {
        return TriggerUtil.interval(triggerName, triggerGroup, jobName, jobGroup, dataMap, interval, DateBuilder.IntervalUnit.MONTH, start, end);
    }

    public static Trigger year(String triggerName, String triggerGroup, String jobName, String jobGroup, Map<String, ? extends Object> dataMap, int interval, Date start, Date end) {
        return TriggerUtil.interval(triggerName, triggerGroup, jobName, jobGroup, dataMap, interval, DateBuilder.IntervalUnit.YEAR, start, end);
    }

    public static Trigger cron(String triggerName, String triggerGroup, String jobName, String jobGroup, Map<String, ? extends Object> dataMap, String cronExpression) throws ParseException {
        TriggerBuilder tb = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).forJob(jobName, jobGroup);
        if (triggerName != null && !triggerName.isEmpty()) {
            if (triggerGroup != null && !triggerGroup.isEmpty()) {
                tb.withIdentity(triggerName, triggerGroup);
            } else {
                tb.withIdentity(triggerName);
            }
        }
        if (dataMap != null && !dataMap.isEmpty()) {
            tb.usingJobData(new JobDataMap(dataMap));
        }
        return tb.build();
    }

    private static Trigger interval(String triggerName, String triggerGroup, String jobName, String jobGroup, Map<String, ? extends Object> dataMap, int interval, DateBuilder.IntervalUnit unit, Date start, Date end) {
        TriggerBuilder tb = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withInterval(interval, unit)).forJob(jobName, jobGroup);
        if (triggerName != null && !triggerName.isEmpty()) {
            if (triggerGroup != null && !triggerGroup.isEmpty()) {
                tb.withIdentity(triggerName, triggerGroup);
            } else {
                tb.withIdentity(triggerName);
            }
        }
        if (start != null && start.after(new Date())) {
            tb.startAt(start);
        }
        if (end != null && end.after(new Date())) {
            tb.endAt(end);
        }
        if (dataMap != null && !dataMap.isEmpty()) {
            tb.usingJobData(new JobDataMap(dataMap));
        }
        return tb.build();
    }

    public static void schedule(Trigger trigger) throws SchedulerException {
        Scheduler sched = StdSchedulerFactory.getDefaultScheduler();
        sched.scheduleJob(trigger);
    }

    public static void pause(Trigger trigger) throws SchedulerException {
        TriggerUtil.pause(trigger.getKey());
    }

    public static void pause(TriggerKey key) throws SchedulerException {
        Scheduler sched = StdSchedulerFactory.getDefaultScheduler();
        sched.pauseTrigger(key);
    }

    public static void delete(Trigger trigger) throws SchedulerException {
        TriggerUtil.delete(trigger.getKey());
    }

    public static void delete(TriggerKey key) throws SchedulerException {
        Scheduler sched = StdSchedulerFactory.getDefaultScheduler();
        sched.unscheduleJob(key);
    }

    public static void resume(Trigger trigger) throws SchedulerException {
        TriggerUtil.resume(trigger.getKey());
    }

    public static void resume(TriggerKey key) throws SchedulerException {
        Scheduler sched = StdSchedulerFactory.getDefaultScheduler();
        sched.resumeTrigger(key);
    }

    public static Trigger.TriggerState getState(Trigger trigger) throws SchedulerException {
        return TriggerUtil.getState(trigger.getKey());
    }

    public static Trigger.TriggerState getState(TriggerKey key) throws SchedulerException {
        Scheduler sched = StdSchedulerFactory.getDefaultScheduler();
        return sched.getTriggerState(key);
    }

    public static List<Trigger> getTriggers() throws SchedulerException {
        Scheduler sched = StdSchedulerFactory.getDefaultScheduler();
        List triggerGroups = sched.getTriggerGroupNames();
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (int i = 0; i < triggerGroups.size(); ++i) {
            String name = (String)triggerGroups.get(i);
            Set keys = sched.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)name));
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                triggers.add(sched.getTrigger((TriggerKey)iter.next()));
            }
        }
        return triggers;
    }
}

