/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.quartz.job;

import com.blazebit.quartz.job.GenericJob;
import com.blazebit.quartz.job.JobParameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;

public abstract class AbstractJob
implements GenericJob {
    private static final long serialVersionUID = 1L;

    protected String getRequiredParam(JobDataMap data, String property) {
        String value = this.getOptionalParam(data, property);
        if (value == null) {
            throw new IllegalArgumentException(property + " not specified.");
        }
        return value;
    }

    protected String getOptionalParam(JobDataMap data, String property) {
        String value = data.getString(property);
        if (value != null && value.trim().length() == 0) {
            return null;
        }
        return value;
    }

    @Override
    public List<JobParameter> getParameters() {
        return Collections.emptyList();
    }

    protected Map<String, Object> getUndefinedParameters(JobDataMap data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<JobParameter> params = this.getParameters();
        boolean found = false;
        for (Map.Entry entry : data.getWrappedMap().entrySet()) {
            for (JobParameter param : params) {
                if (!param.getName().equals(entry.getKey())) continue;
                found = true;
                break;
            }
            if (found) {
                found = false;
                continue;
            }
            map.put((String)entry.getKey(), entry.getValue());
        }
        return map;
    }
}

