/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.quartz.job.mail;

import com.blazebit.mail.Mail;
import com.blazebit.mail.MailUtil;
import com.blazebit.quartz.job.AbstractJob;
import com.blazebit.quartz.job.JobParameter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSendMailJob
extends AbstractJob {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AbstractSendMailJob.class);

    protected Mail createMail(JobDataMap dataMap, String[] to, String subject, String text, String html) {
        return MailUtil.createMessage((String)this.getRequiredParam(dataMap, "from"), (String[])to, (String)subject, (String)text, (String)html);
    }

    protected Mail createMail(JobDataMap dataMap, String[] to, String subject, String text, String html, File[] files) throws IOException {
        return MailUtil.createMessage((String)this.getRequiredParam(dataMap, "from"), (String[])to, (String)subject, (String)text, (String)html, (File[])files);
    }

    protected void sendMail(JobDataMap dataMap, Mail m) throws JobExecutionException {
        try {
            MailUtil.sendMessage((String)this.getRequiredParam(dataMap, "host"), (Integer)Integer.valueOf(this.getRequiredParam(dataMap, "port")), (String)this.getRequiredParam(dataMap, "user"), (String)this.getRequiredParam(dataMap, "password"), (boolean)dataMap.getBoolean("trustAllCertificates"), (boolean)dataMap.getBoolean("secure"), (Mail)m);
        }
        catch (MessagingException ex) {
            log.error(null, (Throwable)ex);
            throw new JobExecutionException((Throwable)ex, false);
        }
    }

    @Override
    public List<JobParameter> getParameters() {
        ArrayList<JobParameter> l = new ArrayList<JobParameter>(super.getParameters());
        l.add(new JobParameter("host", true, String.class));
        l.add(new JobParameter("port", true, Integer.class));
        l.add(new JobParameter("user", true, String.class));
        l.add(new JobParameter("password", true, String.class));
        l.add(new JobParameter("from", true, String.class));
        l.add(new JobParameter("trustAllCertificates", false, Boolean.class));
        l.add(new JobParameter("secure", false, Boolean.class));
        return l;
    }
}

