/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.quartz.plugin;

import com.blazebit.quartz.PropertiesUtil;
import com.blazebit.quartz.plugin.FireHistoryEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.NameMatcher;
import org.quartz.impl.matchers.OrMatcher;
import org.quartz.listeners.TriggerListenerSupport;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.utils.DBConnectionManager;
import org.quartz.utils.Key;
import org.quartz.utils.PropertiesParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FireHistoryPlugin
extends TriggerListenerSupport
implements SchedulerPlugin {
    private static final Logger log = LoggerFactory.getLogger(FireHistoryPlugin.class);
    public static final String PLUGIN_PREFIX = "org.quartz.plugin.";
    public static final String HISTORY_TABLE_NAME = "FIRE_HISTORY";
    public static final String HISTORY_INSERT = "INSERT INTO {0}{1}(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, FIRED_TIME, SCHEDULED_TIME, STATE, JOB_RUN_TIME, JOB_DATA) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String HISTORY_SELECT = "SELECT SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, FIRED_TIME, SCHEDULED_TIME, STATE, JOB_RUN_TIME, JOB_DATA FROM {0}{1}";
    private String triggerGroupStartsWith;
    private String triggerGroupEndsWith;
    private String triggerGroupContains;
    private String triggerGroupEquals;
    private String triggerNameStartsWith;
    private String triggerNameEndsWith;
    private String triggerNameContains;
    private String triggerNameEquals;
    private String dataSourceName;
    private Connection connection;
    private String tablePrefix;

    public void initialize(String name, Scheduler schdlr) throws SchedulerException {
        Properties props = PropertiesUtil.getProperties();
        PropertiesParser cfg = new PropertiesParser(props);
        if (schdlr.getMetaData().isJobStoreSupportsPersistence()) {
            this.dataSourceName = cfg.getStringProperty("org.quartz.jobStore.dataSource");
            this.tablePrefix = cfg.getStringProperty("org.quartz.jobStore.tablePrefix");
            try {
                this.connection = DBConnectionManager.getInstance().getConnection(this.dataSourceName);
                Matcher<TriggerKey> matcher = null;
                if (cfg.getBooleanProperty(PLUGIN_PREFIX + name + ".matchAny")) {
                    matcher = EverythingMatcher.allTriggers();
                } else {
                    matcher = this.addConstraint(matcher, this.triggerGroupStartsWith, "GroupStartsWith");
                    matcher = this.addConstraint(matcher, this.triggerGroupEndsWith, "GroupEndsWith");
                    matcher = this.addConstraint(matcher, this.triggerGroupContains, "GroupContains");
                    matcher = this.addConstraint(matcher, this.triggerGroupEquals, "GroupEquals");
                    matcher = this.addConstraint(matcher, this.triggerNameStartsWith, "NameStartsWith");
                    matcher = this.addConstraint(matcher, this.triggerNameEndsWith, "NameEndsWith");
                    matcher = this.addConstraint(matcher, this.triggerNameContains, "NameContains");
                    matcher = this.addConstraint(matcher, this.triggerNameEquals, "NameEquals");
                }
                schdlr.getListenerManager().addTriggerListener((TriggerListener)this, matcher);
            }
            catch (SQLException ex) {
                throw new SchedulerException("Error when trying to get a database connection.", (Throwable)ex);
            }
        } else {
            log.warn("The fire history can only work with job stores that support persistence!");
        }
    }

    public void start() {
    }

    public void shutdown() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void triggerComplete(Trigger trgr, JobExecutionContext jec, Trigger.CompletedExecutionInstruction cei) {
        try {
            this.addEntry(new FireHistoryEntry(jec.getScheduler().getSchedulerName(), jec.getTrigger().getKey(), jec.getJobDetail().getKey(), jec.getScheduledFireTime(), jec.getFireTime(), jec.getScheduler().getTriggerState(jec.getTrigger().getKey()), jec.getJobRunTime(), jec.getTrigger().getJobDataMap()));
        }
        catch (SchedulerException ex) {
            ex.printStackTrace();
        }
    }

    public String getName() {
        return FireHistoryPlugin.class.getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<FireHistoryEntry> getEntries() {
        if (this.connection == null) {
            return Collections.emptyList();
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.createSelectStatement();
            rs = ps.executeQuery();
            ArrayList<FireHistoryEntry> entries = new ArrayList<FireHistoryEntry>();
            while (rs.next()) {
                entries.add(new FireHistoryEntry(rs.getString(1), new TriggerKey(rs.getString(2), rs.getString(3)), new JobKey(rs.getString(4), rs.getString(5)), new Date(rs.getLong(6)), new Date(rs.getLong(7)), Trigger.TriggerState.valueOf((String)rs.getString(8)), rs.getLong(9), this.getJobDataMap(rs.getBytes(10))));
            }
            ArrayList<FireHistoryEntry> arrayList = entries;
            return arrayList;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEntry(FireHistoryEntry entry) {
        if (this.connection == null) {
            return;
        }
        PreparedStatement ps = null;
        try {
            ps = this.createInsertStatement();
            ps.setString(1, entry.getSchedulerName());
            ps.setString(2, entry.getTriggerKey().getName());
            ps.setString(3, entry.getTriggerKey().getGroup());
            ps.setString(4, entry.getJobKey().getName());
            ps.setString(5, entry.getJobKey().getGroup());
            ps.setLong(6, entry.getFiredTime().getTime());
            ps.setLong(7, entry.getScheduledTime().getTime());
            ps.setString(8, entry.getState().toString());
            ps.setLong(9, entry.getRunTime());
            ps.setBytes(10, this.getByteArray(entry.getDataMap()));
            ps.executeUpdate();
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                if (this.connection != null && !this.connection.getAutoCommit()) {
                    this.connection.rollback();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected PreparedStatement createInsertStatement() throws SQLException {
        return this.connection.prepareStatement(MessageFormat.format(HISTORY_INSERT, this.tablePrefix, HISTORY_TABLE_NAME));
    }

    protected PreparedStatement createSelectStatement() throws SQLException {
        return this.connection.prepareStatement(MessageFormat.format(HISTORY_SELECT, this.tablePrefix, HISTORY_TABLE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArray(JobDataMap map) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(map);
            oos.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ex) {}
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JobDataMap getJobDataMap(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        JobDataMap map = null;
        try {
            ois = new ObjectInputStream(bais);
            map = (JobDataMap)ois.readObject();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ex) {}
            }
        }
        return map;
    }

    private <T extends Key<T>> Matcher<T> createMatcher(String matcherName, String propertyValue) {
        if ("GroupStartsWith".equals(matcherName)) {
            return GroupMatcher.groupStartsWith((String)propertyValue);
        }
        if ("GroupEndsWith".equals(matcherName)) {
            return GroupMatcher.groupEndsWith((String)propertyValue);
        }
        if ("GroupContains".equals(matcherName)) {
            return GroupMatcher.groupContains((String)propertyValue);
        }
        if ("GroupEquals".equals(matcherName)) {
            return GroupMatcher.groupEquals((String)propertyValue);
        }
        if ("NameStartsWith".equals(matcherName)) {
            return NameMatcher.nameStartsWith((String)propertyValue);
        }
        if ("NameEndsWith".equals(matcherName)) {
            return NameMatcher.nameEndsWith((String)propertyValue);
        }
        if ("NameContains".equals(matcherName)) {
            return NameMatcher.nameContains((String)propertyValue);
        }
        if ("NameEquals".equals(matcherName)) {
            return NameMatcher.nameEquals((String)propertyValue);
        }
        return null;
    }

    private Matcher<TriggerKey> addConstraint(Matcher<TriggerKey> matcher, String matchValue, String matcherName) {
        Object newMatcher = null;
        if (matchValue != null) {
            newMatcher = this.createMatcher(matcherName, matchValue);
        }
        if (matcher != null) {
            newMatcher = newMatcher != null ? OrMatcher.or(matcher, newMatcher) : matcher;
        }
        return newMatcher;
    }

    public String getTriggerGroupContains() {
        return this.triggerGroupContains;
    }

    public void setTriggerGroupContains(String triggerGroupContains) {
        this.triggerGroupContains = triggerGroupContains;
    }

    public String getTriggerGroupEndsWith() {
        return this.triggerGroupEndsWith;
    }

    public void setTriggerGroupEndsWith(String triggerGroupEndsWith) {
        this.triggerGroupEndsWith = triggerGroupEndsWith;
    }

    public String getTriggerGroupEquals() {
        return this.triggerGroupEquals;
    }

    public void setTriggerGroupEquals(String triggerGroupEquals) {
        this.triggerGroupEquals = triggerGroupEquals;
    }

    public String getTriggerGroupStartsWith() {
        return this.triggerGroupStartsWith;
    }

    public void setTriggerGroupStartsWith(String triggerGroupStartsWith) {
        this.triggerGroupStartsWith = triggerGroupStartsWith;
    }

    public String getTriggerNameContains() {
        return this.triggerNameContains;
    }

    public void setTriggerNameContains(String triggerNameContains) {
        this.triggerNameContains = triggerNameContains;
    }

    public String getTriggerNameEndsWith() {
        return this.triggerNameEndsWith;
    }

    public void setTriggerNameEndsWith(String triggerNameEndsWith) {
        this.triggerNameEndsWith = triggerNameEndsWith;
    }

    public String getTriggerNameEquals() {
        return this.triggerNameEquals;
    }

    public void setTriggerNameEquals(String triggerNameEquals) {
        this.triggerNameEquals = triggerNameEquals;
    }

    public String getTriggerNameStartsWith() {
        return this.triggerNameStartsWith;
    }

    public void setTriggerNameStartsWith(String triggerNameStartsWith) {
        this.triggerNameStartsWith = triggerNameStartsWith;
    }
}

