/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.designer;

import com.bstek.ureport.Utils;
import com.bstek.ureport.console.RenderPageServletAction;
import com.bstek.ureport.console.designer.DataResult;
import com.bstek.ureport.console.exception.ReportDesignException;
import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.definition.datasource.BuildinDatasource;
import com.bstek.ureport.definition.datasource.DataType;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.support.JdbcUtils;

public class DatasourceServletAction
extends RenderPageServletAction {
    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        }
    }

    public void loadBuildinDatasources(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArrayList<String> datasources = new ArrayList<String>();
        for (BuildinDatasource datasource : Utils.getBuildinDatasources()) {
            datasources.add(datasource.name());
        }
        this.writeObjectToJson(resp, datasources);
    }

    public void loadMethods(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String beanId = req.getParameter("beanId");
        Object obj = this.applicationContext.getBean(beanId);
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        ArrayList<String> result = new ArrayList<String>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Parameter[] parameters = method.getParameters();
            if (parameters.length == 3) {
                Parameter p1 = parameters[0];
                Parameter p2 = parameters[1];
                Parameter p3 = parameters[2];
                Class<?> typeClass1 = p1.getType();
                Class<?> typeClass2 = p2.getType();
                Class<?> typeClass3 = p3.getType();
                if (String.class.isAssignableFrom(typeClass1) && String.class.isAssignableFrom(typeClass2) && Map.class.isAssignableFrom(typeClass3)) {
                    result.add(method.getName());
                }
            }
            ++n2;
        }
        this.writeObjectToJson(resp, result);
    }

    public void buildClass(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String clazz = req.getParameter("clazz");
        ArrayList<Field> result = new ArrayList<Field>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            Class<?> targetClass = Class.forName(clazz);
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = PropertyUtils.getPropertyDescriptors(targetClass);
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                String name = pd.getName();
                if (!"class".equals(name)) {
                    result.add(new Field(name));
                }
                ++n2;
            }
            this.writeObjectToJson(resp, result);
        }
        catch (Exception ex) {
            throw new ReportDesignException(ex);
        }
    }

    public void buildFields(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sql = req.getParameter("sql");
        String parameters = req.getParameter("parameters");
        Map<String, Object> map = this.buildParameters(parameters);
        MapSqlParameterSource mapParamSource = new MapSqlParameterSource(map);
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement((String)sql);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters((ParsedSql)parsedSql, (SqlParameterSource)mapParamSource);
        Object[] params = NamedParameterUtils.buildValueArray((ParsedSql)parsedSql, (SqlParameterSource)mapParamSource, null);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Field> fields = new ArrayList<Field>();
        try {
            try {
                conn = this.buildConnection(req);
                stmt = conn.prepareStatement(sqlToUse);
                int i = 0;
                while (i < params.length) {
                    Object obj = params[i];
                    stmt.setObject(i + 1, obj);
                    ++i;
                }
                rs = stmt.executeQuery();
                ResultSetMetaData metadata = rs.getMetaData();
                int columnCount = metadata.getColumnCount();
                int i2 = 0;
                while (i2 < columnCount) {
                    String columnName = metadata.getColumnName(i2 + 1);
                    fields.add(new Field(columnName));
                    ++i2;
                }
                this.writeObjectToJson(resp, fields);
            }
            catch (Exception ex) {
                throw new ReportDesignException(ex);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(stmt);
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeConnection((Connection)conn);
            throw throwable;
        }
        JdbcUtils.closeStatement((Statement)stmt);
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeConnection((Connection)conn);
    }

    public void previewData(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sql = req.getParameter("sql");
        String parameters = req.getParameter("parameters");
        Map<String, Object> map = this.buildParameters(parameters);
        Connection conn = null;
        try {
            try {
                int size;
                conn = this.buildConnection(req);
                SingleConnectionDataSource dataSource = new SingleConnectionDataSource(conn, false);
                NamedParameterJdbcTemplate jdbc = new NamedParameterJdbcTemplate((DataSource)dataSource);
                List list = jdbc.queryForList(sql, map);
                int currentTotal = size = list.size();
                if (currentTotal > 500) {
                    currentTotal = 500;
                }
                ArrayList<Map<String, Object>> ls = new ArrayList<Map<String, Object>>();
                int i = 0;
                while (i < currentTotal) {
                    ls.add((Map)list.get(i));
                    ++i;
                }
                DataResult result = new DataResult();
                ArrayList<String> fields = new ArrayList<String>();
                if (size > 0) {
                    Map item = (Map)list.get(0);
                    for (String name : item.keySet()) {
                        fields.add(name);
                    }
                }
                result.setFields(fields);
                result.setCurrentTotal(currentTotal);
                result.setData(ls);
                result.setTotal(size);
                this.writeObjectToJson(resp, result);
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void testConnection(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> map;
        block14: {
            String username = req.getParameter("username");
            String password = req.getParameter("password");
            String driver = req.getParameter("driver");
            String url = req.getParameter("url");
            Connection conn = null;
            map = new HashMap<String, Object>();
            try {
                try {
                    Class.forName(driver);
                    conn = DriverManager.getConnection(url, username, password);
                    map.put("result", true);
                }
                catch (Exception ex) {
                    map.put("error", ex.toString());
                    map.put("result", false);
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        this.writeObjectToJson(resp, map);
    }

    private Map<String, Object> buildParameters(String parameters) throws IOException, JsonParseException, JsonMappingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)parameters)) {
            return map;
        }
        ObjectMapper mapper = new ObjectMapper();
        List list = (List)mapper.readValue(parameters, ArrayList.class);
        for (Map param : list) {
            String name = param.get("name").toString();
            DataType type = DataType.valueOf((String)param.get("type").toString());
            String defaultValue = (String)param.get("defaultValue");
            if (defaultValue == null || defaultValue.equals("")) {
                switch (type) {
                    case Boolean: {
                        map.put(name, false);
                    }
                    case Date: {
                        map.put(name, new Date());
                    }
                    case Float: {
                        map.put(name, new Float(0.0f));
                    }
                    case Integer: {
                        map.put(name, 0);
                    }
                    case String: {
                        if (defaultValue != null && defaultValue.equals("")) {
                            map.put(name, "");
                        } else {
                            map.put(name, "null");
                        }
                    }
                    case List: {
                        map.put(name, new ArrayList());
                    }
                }
                continue;
            }
            map.put(name, type.parse((Object)defaultValue));
        }
        return map;
    }

    private Connection buildConnection(HttpServletRequest req) throws Exception {
        String type = req.getParameter("type");
        if (type.equals("jdbc")) {
            String username = req.getParameter("username");
            String password = req.getParameter("password");
            String driver = req.getParameter("driver");
            String url = req.getParameter("url");
            Class.forName(driver);
            Connection conn = DriverManager.getConnection(url, username, password);
            return conn;
        }
        String name = req.getParameter("name");
        Connection conn = Utils.getBuildinConnection((String)name);
        if (conn == null) {
            throw new ReportDesignException("Buildin datasource [" + name + "] not exist.");
        }
        return conn;
    }

    @Override
    public String url() {
        return "/datasource";
    }
}

