/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.app.listener;

import com.centit.cmip.app.loader.global.ApplicationContextLoader;
import com.centit.cmip.app.loader.parse.LoaderException;
import com.centit.cmip.app.loader.parse.ThirdPartyXMLReader;
import com.centit.cmip.sdk.common.utils.LogUtil;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class InitContextListener
implements ServletContextListener {
    private static final String THIRDPARTY_CONFIGFILEPATH = "config.xml";
    private static LogUtil logger = LogUtil.getLogger(InitContextListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        ThirdPartyXMLReader reader = null;
        try {
            reader = ThirdPartyXMLReader.getInstance();
            reader.loadConfig(THIRDPARTY_CONFIGFILEPATH);
        }
        catch (LoaderException e) {
            logger.error(e.getMessage());
        }
        ServletContext context = sce.getServletContext();
        String realPath = context.getRealPath("/").replaceAll("\\\\", "/");
        String contextPath = context.getContextPath();
        String deployPath = realPath.substring(0, realPath.lastIndexOf(contextPath));
        ApplicationContextLoader.setDeployPath(deployPath);
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }
}

