/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.common.utils;

import com.centit.cmip.sdk.common.utils.LogUtil;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    private static LogUtil logger = LogUtil.getLogger(DateUtil.class);
    public static String DATE_FORMAT = "yyyy-MM-dd";
    public static String DATE_FORMAT1 = "dd/MM/yyyy";
    public static String DATE_FORMAT2 = "yyyy/MM/dd";
    public static String DATE_FORMAT3 = "yyyy\u5e74MM\u6708dd\u65e5";
    public static String DATE_FORMAT4 = "MM\u6708dd\u65e5";
    public static String TIME_FORMAT = "HH:mm:ss";
    public static String TIMESTAMP_FORMAT_SS = "yyyy-MM-dd HH:mm:ss";
    public static String TIMESTAMP_FORMAT_SSS = "yyyy-MM-dd HH:mm:ss:mss";
    public static String TIMESTAMP_FORMAT2 = "yyyy/MM/dd HH:mm:ss";
    public static String TIMESTAMP_FORMAT3 = "yyyy-MM-dd HH:mm";

    public static Date getDateFromString(String para) {
        Date res = null;
        try {
            res = DateUtil.getFmt().parse(para);
        }
        catch (Exception e) {
            res = new Date();
            logger.error("\u5c06\u5b57\u7b26\u4e32\u89e3\u6790\u6210\u65e5\u671f\u683c\u5f0f\u6709\u8bef", e);
        }
        return res;
    }

    public static Date getDateFromString(String para, String format) {
        Date res = null;
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(format);
            res = fmt.parse(para);
        }
        catch (ParseException e) {
            res = new Date();
            logger.error("\u5c06\u5b57\u7b26\u4e32\u89e3\u6790\u6210\u65e5\u671f\u683c\u5f0f\u6709\u8bef", e);
        }
        return res;
    }

    public static String formatDate(Date para) {
        return DateUtil.getFmt().format(para);
    }

    public static String formatDate(Date para, String format) {
        return new SimpleDateFormat(format).format(para);
    }

    public static String current(String format) {
        SimpleDateFormat sdf = null;
        sdf = format != null && format.length() > 0 ? new SimpleDateFormat(format) : DateUtil.getFmt();
        return sdf.format(new Date());
    }

    public static String current() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        return sdf.format(new Date());
    }

    public static String getDateBetween(Date startDate, Date endDate) {
        long timeBetween = (startDate.getTime() - endDate.getTime()) / 86400000L;
        long day = timeBetween / 86400000L;
        long hour = timeBetween / 3600000L - day * 24L;
        long min = timeBetween / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeBetween / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        return " " + day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206" + s + "\u79d2";
    }

    public static long getGMTTime(String strDate) {
        SimpleDateFormat format1 = new SimpleDateFormat(TIMESTAMP_FORMAT_SS);
        Date date = null;
        try {
            date = format1.parse(strDate);
            return date.getTime();
        }
        catch (ParseException e) {
            logger.error("\u83b7\u53d6gmt\u65f6\u95f4\u6709\u8bef", e);
            return -1L;
        }
    }

    public static Date strToDateLong(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat(TIMESTAMP_FORMAT_SS);
        ParsePosition pos = new ParsePosition(0);
        return formatter.parse(strDate, pos);
    }

    public static String dateToStr(Date dateDate) {
        SimpleDateFormat formatter = new SimpleDateFormat(TIMESTAMP_FORMAT_SS);
        return formatter.format(dateDate);
    }

    public static String dateToStr(Date dateDate, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(dateDate);
    }

    public static String dateToStringToStr(String dateDate, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        Date dateString = null;
        try {
            dateString = sdf.parse(dateDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (dateString != null) {
            if (format != null && format.length() > 0) {
                return DateUtil.dateToStr(dateString, format);
            }
            return DateUtil.dateToStr(dateString, TIMESTAMP_FORMAT3);
        }
        return null;
    }

    public static int getDaysDiff(Date date1, Date date2) {
        int result = 0;
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(date1);
        calendar2.setTime(date2);
        int flag = calendar1.compareTo(calendar2);
        if (flag < 0) {
            calendar1.setTime(date2);
            calendar2.setTime(date1);
        }
        result = calendar1.get(6) - calendar2.get(6);
        while (calendar1.get(1) > calendar2.get(1)) {
            result += calendar2.getActualMaximum(6);
            calendar2.add(1, 1);
        }
        result = flag < 0 ? -result : result;
        return result;
    }

    public static int getDaysDiff(Calendar calendar, Date date) {
        return DateUtil.getDaysDiff(calendar.getTime(), date);
    }

    public static int getDaysDiff(Date date, Calendar calendar) {
        return DateUtil.getDaysDiff(date, calendar.getTime());
    }

    public static int getDaysDiff(Calendar calendar1, Calendar calendar2) {
        return DateUtil.getDaysDiff(calendar1.getTime(), calendar2.getTime());
    }

    public static int getDaysDiffAbs(Date date1, Date date2) {
        return Math.abs(DateUtil.getDaysDiff(date1, date2));
    }

    public static int getDaysDiffAbs(Calendar calendar, Date date) {
        return DateUtil.getDaysDiffAbs(calendar.getTime(), date);
    }

    public static int getDaysDiffAbs(Date date, Calendar calendar) {
        return DateUtil.getDaysDiffAbs(date, calendar.getTime());
    }

    public static int getDaysDiffAbs(Calendar calendar1, Calendar calendar2) {
        return DateUtil.getDaysDiffAbs(calendar1.getTime(), calendar2.getTime());
    }

    public static Date getDaysAfter(Date date, int num) {
        Date newdate = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, num);
        newdate = calendar.getTime();
        return newdate;
    }

    public static Date getDaysBefore(Date date, int num) {
        return DateUtil.getDaysAfter(date, -num);
    }

    public static String getStringDate(Date date) {
        String dateString = "";
        if (date != null) {
            dateString = new SimpleDateFormat(DATE_FORMAT).format(date);
        }
        return dateString;
    }

    public static String getStringDate(Date date, String format) {
        String dateString = "";
        if (date != null) {
            dateString = new SimpleDateFormat(format).format(date);
        }
        return dateString;
    }

    public static Date getDate(String date) {
        try {
            return new SimpleDateFormat(DATE_FORMAT).parse(date);
        }
        catch (ParseException e) {
            logger.error(DateUtil.class.getName(), "getDate", null, "\u65e5\u671f\u8f6c\u6362\u51fa\u9519", null, e, date);
            return null;
        }
    }

    public static Date dateFormatter(String dateString) {
        Date date;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(TIMESTAMP_FORMAT_SS);
            date = sdf.parse(dateString);
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(TIMESTAMP_FORMAT2);
                date = sdf.parse(dateString);
            }
            catch (ParseException e1) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
                    date = sdf.parse(dateString);
                }
                catch (ParseException e2) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT2);
                        date = sdf.parse(dateString);
                    }
                    catch (ParseException e3) {
                        date = null;
                    }
                }
            }
        }
        return date;
    }

    private static SimpleDateFormat getFmt() {
        return new SimpleDateFormat(TIMESTAMP_FORMAT_SS);
    }
}

