/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.protocol.filter;

import com.centit.cmip.sdk.common.exception.BizException;
import com.centit.cmip.sdk.common.exception.OtherException;
import com.centit.cmip.sdk.common.utils.LogUtil;
import com.centit.cmip.sdk.common.utils.StringUtil;
import com.centit.cmip.sdk.common.utils.file.FileUtil;
import com.centit.cmip.sdk.common.utils.file.ResourcePath;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;

public class RequestParser {
    private static LogUtil logger = LogUtil.getLogger(RequestParser.class);
    private static String uploadPath;
    private static String attachname;
    private static String attachurl;

    static {
        try {
            uploadPath = ResourcePath.getInstance().get("uploadPath");
        }
        catch (OtherException e) {
            e.printStackTrace();
        }
    }

    public static JSONObject getJsonFromRequest(ServletRequest request) throws BizException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String contextPath = httpRequest.getSession().getServletContext().getRealPath("/").replaceAll("\\\\", "/");
        String saveDirPrefix = contextPath.substring(0, contextPath.lastIndexOf(httpRequest.getContextPath()));
        String saveDirSuffix = String.valueOf(uploadPath) + UUID.randomUUID();
        String tempDir = String.valueOf(saveDirPrefix) + saveDirSuffix;
        BufferedReader bufReader = null;
        String buStr = "";
        JSONObject buJson = null;
        ServletInputStream reqInput = null;
        BufferedInputStream bis = null;
        try {
            reqInput = request.getInputStream();
            bis = new BufferedInputStream((InputStream)reqInput);
            bis.mark(5);
            byte[] b = new byte[5];
            bis.read(b);
            bis.reset();
            if (!new String(b).startsWith("PK")) {
                bufReader = new BufferedReader(new InputStreamReader((InputStream)bis, "utf-8"));
                StringBuffer strBuffer = new StringBuffer();
                String str = "";
                while ((str = bufReader.readLine()) != null) {
                    strBuffer.append(str);
                }
                buStr = strBuffer.toString();
                if ("".equals(buStr.trim())) {
                    buStr = "{}";
                }
                buJson = JSONObject.fromObject((Object)buStr);
            } else {
                buStr = RequestParser.saveZip(bis, httpRequest, saveDirPrefix, saveDirSuffix, tempDir);
                buJson = JSONObject.fromObject((Object)buStr);
                buJson.getJSONObject("header").element("param1", (Object)attachname);
                buJson.getJSONObject("header").element("param2", (Object)attachurl);
                buJson.getJSONObject("header").element("param3", (Object)tempDir);
            }
            JSONObject jSONObject = buJson;
            return jSONObject;
        }
        catch (Exception e) {
            logger.error("\u4ecerequest\u4e2d\u83b7\u53d6\u8bf7\u6c42\u7684\u5b57\u7b26\u4e32\u51fa\u9519", e);
            throw new BizException("BIZ_003", buStr, e);
        }
        finally {
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (reqInput != null) {
                    reqInput.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String saveZip(InputStream reqis, HttpServletRequest request, String saveDirPrefix, String saveDirSuffix, String tmpDir) {
        String fileNameLong = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + UUID.randomUUID().toString() + ".zip";
        File savefile = null;
        FileInputStream fis = null;
        ZipInputStream zis = null;
        ZipFile zipFile = null;
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        String content = "";
        try {
            try {
                savefile = FileUtil.Io2File(fileNameLong, reqis);
                reqis.close();
                fis = new FileInputStream(savefile);
                zis = new ZipInputStream(fis);
                ZipEntry entry = null;
                zipFile = new ZipFile(savefile);
                while ((entry = zis.getNextEntry()) != null) {
                    String fileName = "";
                    fileName = entry.getName();
                    fileName = StringUtil.stringFilter(fileName);
                    is = zipFile.getInputStream(entry);
                    if ("data.json".equals(fileName)) {
                        int i = -1;
                        bos = new ByteArrayOutputStream();
                        while ((i = is.read()) != -1) {
                            bos.write(i);
                            bos.flush();
                        }
                        content = bos.toString("UTF-8");
                        bos.close();
                        is.close();
                        continue;
                    }
                    String tempPath = String.valueOf(saveDirPrefix) + saveDirSuffix + File.separator + fileName;
                    String convertFile = FileUtil.Io2File(tempPath, zipFile.getInputStream(entry)).getAbsolutePath();
                    try {
                        if (convertFile.endsWith("mp3") || convertFile.endsWith("mp4")) {
                            fileName = convertFile.substring(convertFile.lastIndexOf("\\") + 1);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    attachname = fileName;
                    attachurl = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + saveDirSuffix + "/" + fileName;
                }
            }
            catch (Exception e) {
                logger.error("\u4e0a\u4f20\u8bf7\u6c42\u83b7\u53d6\u538b\u7f29\u6d41\u5f02\u5e38", e);
                try {
                    if (zis != null) {
                        zis.close();
                        zis = null;
                    }
                    if (reqis != null) {
                        reqis.close();
                        reqis = null;
                    }
                    if (bos != null) {
                        bos.close();
                        bos = null;
                    }
                    if (is != null) {
                        is.close();
                        is = null;
                    }
                    if (fis != null) {
                        fis.close();
                        fis = null;
                    }
                    if (zipFile != null) {
                        zipFile.close();
                        zipFile = null;
                    }
                }
                catch (IOException e2) {
                    logger.error("\u4e0a\u4f20\u8bf7\u6c42\u83b7\u53d6\u538b\u7f29\u6d41,\u5173\u95ed\u6d41\u5f02\u5e38", e2);
                }
                savefile = null;
                new File(fileNameLong).delete();
                logger.info("\u4e0a\u4f20\u5904\u7406\u7ed3\u675f");
            }
        }
        finally {
            try {
                if (zis != null) {
                    zis.close();
                    zis = null;
                }
                if (reqis != null) {
                    reqis.close();
                    reqis = null;
                }
                if (bos != null) {
                    bos.close();
                    bos = null;
                }
                if (is != null) {
                    is.close();
                    is = null;
                }
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
                if (zipFile != null) {
                    zipFile.close();
                    zipFile = null;
                }
            }
            catch (IOException e) {
                logger.error("\u4e0a\u4f20\u8bf7\u6c42\u83b7\u53d6\u538b\u7f29\u6d41,\u5173\u95ed\u6d41\u5f02\u5e38", e);
            }
            savefile = null;
            new File(fileNameLong).delete();
            logger.info("\u4e0a\u4f20\u5904\u7406\u7ed3\u675f");
        }
        return content;
    }
}

