/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.protocol.filter;

import com.centit.cmip.sdk.common.define.Macro;
import com.centit.cmip.sdk.common.entity.Body;
import com.centit.cmip.sdk.common.entity.ReqHeader;
import com.centit.cmip.sdk.common.entity.ReqTransEntity;
import com.centit.cmip.sdk.common.exception.BizException;
import com.centit.cmip.sdk.common.utils.LogUtil;
import com.centit.cmip.sdk.common.utils.MessageUtil;
import com.centit.cmip.sdk.common.utils.StringUtil;
import com.centit.cmip.sdk.common.utils.verify.RandomType;
import com.centit.cmip.sdk.common.utils.verify.VerifyCodeEntity;
import com.centit.cmip.sdk.common.utils.verify.VerifyRandomCode;
import com.centit.cmip.sdk.protocol.filter.RequestParser;
import java.io.IOException;
import java.util.Calendar;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class ServerRequestFilter
implements Filter {
    private static LogUtil logger = LogUtil.getLogger(ServerRequestFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.info("\u8bf7\u6c42\u62e6\u622a\u5668\u62e6\u622a\u5230\u4e00\u4e2a\u6765\u81ea\u4e8e" + request.getRemoteAddr() + "\u7684\u8bf7\u6c42");
        response.setCharacterEncoding(Macro.RESPONSE_CHARSET_ENCODING);
        JSONObject buJson = null;
        HttpServletRequest re = (HttpServletRequest)request;
        if ((String.valueOf(re.getContextPath()) + "/server").replaceAll("/", "").toLowerCase().equals(re.getRequestURI().replaceAll("/", "").toLowerCase())) {
            String sessionId = "";
            try {
                buJson = RequestParser.getJsonFromRequest(request);
                String chkResult = MessageUtil.checkMessage(buJson);
                if (!StringUtils.isEmpty((String)chkResult)) {
                    logger.info(chkResult);
                    buJson.getJSONObject("header").put((Object)"retCode", (Object)"1");
                    buJson.getJSONObject("header").put((Object)"retMsg", (Object)chkResult);
                } else {
                    chkResult = this.checkSession(buJson);
                    if (!StringUtils.isEmpty((String)chkResult)) {
                        logger.info(chkResult);
                        buJson.getJSONObject("header").put((Object)"retCode", (Object)"2");
                        buJson.getJSONObject("header").put((Object)"retMsg", (Object)chkResult);
                    }
                }
            }
            catch (BizException e) {
                logger.error(e.getMessage(), e);
                buJson = new JSONObject();
                buJson.put((Object)"header", (Object)new JSONObject());
                buJson.getJSONObject("header").put((Object)"retCode", (Object)"1");
                buJson.getJSONObject("header").put((Object)"retMsg", (Object)e.getErrorCode());
                buJson.getJSONObject("header").put((Object)"sessionId", (Object)sessionId);
            }
            ReqTransEntity requestEntity = new ReqTransEntity();
            ReqHeader header = (ReqHeader)JSONObject.toBean((JSONObject)buJson.getJSONObject("header"), ReqHeader.class);
            header.setIp(String.valueOf(request.getRemoteAddr()) + ":" + request.getRemotePort());
            String bodyStr = MessageUtil.decodeMessage(buJson.getString("body")).toString();
            logger.info("\u8bf7\u6c42\u62a5\u6587:" + bodyStr);
            JSONObject jsonObj = JSONObject.fromObject((Object)bodyStr);
            Body body = (Body)JSONObject.toBean((JSONObject)jsonObj, Body.class);
            requestEntity.setHeader(header);
            requestEntity.setBody(body);
            request.setAttribute("param", (Object)requestEntity);
            request.setAttribute("body", (Object)jsonObj);
            logger.info("\u62e6\u622a\u5668\u5904\u7406\u5b8c\u6bd5\uff0c\u8f6c\u5165\u4e1a\u52a1\u5c42\u5904\u7406\u3002");
            chain.doFilter(request, response);
        }
    }

    private String checkSession(JSONObject jsonObj) {
        String result = "";
        JSONObject headerObj = jsonObj.getJSONObject("header");
        String sessionId = headerObj.getString("sessionId");
        String keyNumber = String.valueOf(headerObj.getString("deviceType")) + headerObj.getString("userId") + headerObj.getString("deviceId");
        if (!StringUtil.isEmpty(sessionId) && VerifyRandomCode.getRandoms().containsKey(keyNumber)) {
            if (VerifyRandomCode.verifyRandom(keyNumber, sessionId, 7200)) {
                VerifyCodeEntity codeEntity = (VerifyCodeEntity)VerifyRandomCode.getRandoms().get(keyNumber);
                codeEntity.setCreateTime(Calendar.getInstance().getTime());
            } else {
                result = "\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01";
            }
        } else {
            sessionId = VerifyRandomCode.genRandomCode(keyNumber, RandomType.CHARATER, 20);
            headerObj.put((Object)"sessionId", (Object)sessionId);
        }
        return result;
    }

    public void init(FilterConfig fConfig) throws ServletException {
        Macro.REQUEST_CHARSET_ENCODING = fConfig.getInitParameter("requestCharset");
        Macro.RESPONSE_CHARSET_ENCODING = fConfig.getInitParameter("responseCharset");
        logger.info("\u914d\u7f6e\u4ea4\u4e92\u5b57\u7b26\u96c6\u4e3a\uff0crequest\uff1a" + Macro.REQUEST_CHARSET_ENCODING + "\t|\t response:" + Macro.RESPONSE_CHARSET_ENCODING);
    }

    public void destroy() {
    }
}

