/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.app.logger.service.impl;

import com.centit.cmip.app.common.dao.DefaultDao;
import com.centit.cmip.app.common.util.ServiceDaoUtils;
import com.centit.cmip.app.logger.entity.LmOperlogEntity;
import com.centit.cmip.app.logger.service.ILoggerService;
import com.centit.cmip.sdk.common.entity.ReqHeader;
import com.centit.cmip.sdk.common.entity.ReqTransEntity;
import com.centit.cmip.sdk.common.entity.RespTransEntity;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class LoggerServiceImpl
implements ILoggerService {
    private DefaultDao loggerDao = ServiceDaoUtils.getDefaultDao();

    public void opLog(LmOperlogEntity entity) {
        if ("0".equals(entity.getOpType())) {
            this.loggerDao.insert("log_insertExLog", entity);
        } else if ("1".equals(entity.getOpType())) {
            this.loggerDao.insert("log_insertOpLog", entity);
        }
    }

    public LmOperlogEntity initLog(ReqTransEntity reqEntity, RespTransEntity respEntity, String opType, String logType, String logInfo, boolean retflag) {
        ReqHeader header = reqEntity.getHeader();
        String bizType = "";
        String methodName = "";
        String reqInfo = "";
        String retInfo = "";
        if (null != reqEntity.getBody()) {
            bizType = reqEntity.getBody().getBizCode() + "/" + reqEntity.getBody().getBizType();
            methodName = reqEntity.getBody().getMethodName();
            reqInfo = JSONObject.fromObject((Object)reqEntity).toString();
        }
        if (null != respEntity && null != respEntity.getBody()) {
            retInfo = JSONObject.fromObject((Object)respEntity).toString();
        }
        return this.initLog(header, logType, logInfo, opType, bizType, methodName, reqInfo, retInfo, "", "", retflag);
    }

    public LmOperlogEntity initLog(ReqHeader header, String logType, String logInfo, String opType, String bizType, String methodName, String reqInfo, String retInfo, String serverMethod, String servicePath, boolean retflag) {
        LmOperlogEntity logEntity = new LmOperlogEntity();
        logEntity.setUsercode(header.getUserId());
        logEntity.setDeptcode(header.getUserDept());
        logEntity.setIdentnumber(header.getDeviceId());
        logEntity.setOsVersion(header.getOsVersion());
        logEntity.setAppId(header.getAppCode());
        logEntity.setVersionId(header.getAppVersion());
        logEntity.setDeviceType(header.getDeviceType());
        logEntity.setLogIp(header.getIp());
        logEntity.setLogType(logType);
        logEntity.setLogInfo(logInfo);
        logEntity.setOpType(opType);
        logEntity.setBizname(bizType);
        logEntity.setOperfun(methodName);
        logEntity.setReqInfo(reqInfo.getBytes());
        logEntity.setRetInfo(retInfo.getBytes());
        logEntity.setServerMethod(serverMethod);
        logEntity.setServerPath(servicePath);
        if (retflag) {
            this.opLog(logEntity);
        }
        return logEntity;
    }
}

