/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.common.utils.file;

import com.centit.cmip.sdk.common.exception.OtherException;
import com.centit.cmip.sdk.common.utils.LogUtil;
import com.centit.cmip.sdk.common.utils.file.ResourcePath;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfEncryptor;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.codec.TiffImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FileUtil {
    public static final int LENGTH = 8192;
    private static LogUtil logger = LogUtil.getLogger(FileUtil.class);

    public static File Path2File(String tempPath) throws OtherException {
        File file = new File(tempPath);
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                logger.error("\u6839\u636e\u8def\u5f84\u521b\u5efa\u6587\u4ef6\u5939\u6709\u8bef", e);
                throw new OtherException("OHTER_IO_001", null, e);
            }
        }
        return file;
    }

    /*
     * Loose catch block
     */
    public static void fileCopy(File f1, File f2) throws OtherException {
        block16: {
            FileInputStream in = null;
            FileOutputStream out = null;
            in = new FileInputStream(f1);
            byte[] buffer = new byte[8192];
            int num = 0;
            out = new FileOutputStream(f2);
            while ((num = in.read(buffer)) != -1) {
                out.write(buffer, 0, num);
                out.flush();
            }
            Object var7_7 = null;
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (IOException ex) {
                logger.error("fileCopy \u5173\u95ed\u6d41 error", ex);
            }
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
                break block16;
            }
            catch (IOException ex) {
                logger.error("fileCopy \u5173\u95ed\u6d41 error", ex);
            }
            break block16;
            {
                catch (IOException e) {
                    logger.error("fileCopy error", e);
                    throw new OtherException("OHTER_IO_001", null, e);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (out != null) {
                        out.close();
                        out = null;
                    }
                }
                catch (IOException ex) {
                    logger.error("fileCopy \u5173\u95ed\u6d41 error", ex);
                }
                try {
                    if (in != null) {
                        in.close();
                        in = null;
                    }
                }
                catch (IOException ex) {
                    logger.error("fileCopy \u5173\u95ed\u6d41 error", ex);
                }
                throw throwable;
            }
        }
    }

    public static boolean mkDir(String dirName) {
        File d = new File(dirName);
        if (d.exists()) {
            return d.isDirectory();
        }
        return d.mkdirs();
    }

    public static String getNameFromPath(String path) {
        String name = "";
        int start = path.indexOf(47);
        if (start > -1) {
            name = path.substring(start + 1);
        }
        return name;
    }

    /*
     * Loose catch block
     */
    public static File Io2File(String tempPath, InputStream fis) throws OtherException {
        block25: {
            FileOutputStream fileos;
            block21: {
                fileos = null;
                if (fis == null) break block21;
                File tempFile = new File(tempPath);
                if (tempFile.getParentFile() != null) {
                    tempFile.getParentFile().mkdirs();
                }
                if (!tempFile.exists()) {
                    tempFile.createNewFile();
                }
                byte[] buf = new byte[8192];
                int len = 0;
                fileos = new FileOutputStream(tempFile);
                while ((len = fis.read(buf)) != -1) {
                    fileos.write(buf, 0, len);
                    fileos.flush();
                }
                File file = tempFile;
                Object var8_8 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    logger.error("\u6839\u636e\u6587\u4ef6\u8def\u5f84\u4e0e\u6d41\u751f\u521b\u5efa\u6587\u4ef6 \u5173\u95ed\u6570\u636e\u6d41 \u6709\u8bef", ex);
                }
                try {
                    if (fileos != null) {
                        fileos.close();
                    }
                }
                catch (IOException ex) {
                    logger.error("\u6839\u636e\u6587\u4ef6\u8def\u5f84\u4e0e\u6d41\u751f\u521b\u5efa\u6587\u4ef6 \u5173\u95ed\u6570\u636e\u6d41 \u6709\u8bef", ex);
                }
                return file;
            }
            try {
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    logger.error("\u6839\u636e\u6587\u4ef6\u8def\u5f84\u4e0e\u6d41\u751f\u521b\u5efa\u6587\u4ef6 \u5173\u95ed\u6570\u636e\u6d41 \u6709\u8bef", ex);
                }
                try {
                    if (fileos != null) {
                        fileos.close();
                    }
                }
                catch (IOException ex) {
                    logger.error("\u6839\u636e\u6587\u4ef6\u8def\u5f84\u4e0e\u6d41\u751f\u521b\u5efa\u6587\u4ef6 \u5173\u95ed\u6570\u636e\u6d41 \u6709\u8bef", ex);
                }
                throw throwable;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                logger.error("\u6839\u636e\u6587\u4ef6\u8def\u5f84\u4e0e\u6d41\u751f\u521b\u5efa\u6587\u4ef6 \u5173\u95ed\u6570\u636e\u6d41 \u6709\u8bef", ex);
            }
            try {
                if (fileos != null) {
                    fileos.close();
                }
                break block25;
            }
            catch (IOException ex) {
                logger.error("\u6839\u636e\u6587\u4ef6\u8def\u5f84\u4e0e\u6d41\u751f\u521b\u5efa\u6587\u4ef6 \u5173\u95ed\u6570\u636e\u6d41 \u6709\u8bef", ex);
            }
            break block25;
            {
                catch (IOException e) {
                    logger.error("\u6839\u636e\u6587\u4ef6\u8def\u5f84\u4e0e\u6d41\u751f\u521b\u5efa\u6587\u4ef6\u6709\u8bef", e);
                    throw new OtherException("OHTER_IO_004", e);
                }
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static byte[] File2Byte(File file) throws OtherException {
        byte[] ret;
        block16: {
            ret = null;
            FileInputStream in = null;
            ByteArrayOutputStream out = null;
            in = new FileInputStream(file);
            long length = file.length();
            length = length > Integer.MAX_VALUE ? Integer.MAX_VALUE : length;
            out = new ByteArrayOutputStream((int)length);
            byte[] temp = new byte[8192];
            int size = 0;
            while ((size = in.read(temp)) != -1) {
                out.write(temp, 0, size);
            }
            in.close();
            ret = out.toByteArray();
            out.close();
            Object var9_8 = null;
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (IOException ex) {
                logger.error("\u628a\u6587\u4ef6\u8f6c\u6362\u4e3a\u4e8c\u8fdb\u5236\u6570\u7ec4,\u5173\u95ed\u6570\u636e\u6d41\u6709\u8bef", ex);
            }
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
                break block16;
            }
            catch (IOException ex) {
                logger.error("\u628a\u6587\u4ef6\u8f6c\u6362\u4e3a\u4e8c\u8fdb\u5236\u6570\u7ec4,\u5173\u95ed\u6570\u636e\u6d41\u6709\u8bef", ex);
            }
            break block16;
            {
                catch (Exception e) {
                    logger.error("\u628a\u6587\u4ef6\u8f6c\u6362\u4e3a\u4e8c\u8fdb\u5236\u6570\u7ec4\u6709\u8bef", e);
                    throw new OtherException(e);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (in != null) {
                        in.close();
                        in = null;
                    }
                }
                catch (IOException ex) {
                    logger.error("\u628a\u6587\u4ef6\u8f6c\u6362\u4e3a\u4e8c\u8fdb\u5236\u6570\u7ec4,\u5173\u95ed\u6570\u636e\u6d41\u6709\u8bef", ex);
                }
                try {
                    if (out != null) {
                        out.close();
                        out = null;
                    }
                }
                catch (IOException ex) {
                    logger.error("\u628a\u6587\u4ef6\u8f6c\u6362\u4e3a\u4e8c\u8fdb\u5236\u6570\u7ec4,\u5173\u95ed\u6570\u636e\u6d41\u6709\u8bef", ex);
                }
                throw throwable;
            }
        }
        return ret;
    }

    public static void Files2Zip(File dirFile, ZipOutputStream zos) throws OtherException {
        try {
            if (dirFile.exists()) {
                if (dirFile.isDirectory()) {
                    File[] files;
                    for (File file : files = dirFile.listFiles()) {
                        FileUtil.Files2Zip(file, zos);
                    }
                    dirFile.delete();
                } else {
                    FileUtil.File2Zip(dirFile, zos);
                }
            }
        }
        catch (OtherException e) {
            logger.error("\u628a\u6587\u4ef6\u5939\u538b\u7f29\u6210\u538b\u7f29\u5305\uff0c\u5e76\u5220\u9664\u539f\u4e34\u65f6\u6587\u4ef6 \u6709\u8bef ", e);
            throw new OtherException("\u538b\u7f29\u6587\u4ef6\u51fa\u9519", e);
        }
    }

    /*
     * Loose catch block
     */
    public static void File2Zip(File tempFile, ZipOutputStream zos) throws OtherException {
        block8: {
            int nNumber;
            FileInputStream in = null;
            zos.putNextEntry(new ZipEntry(tempFile.getName()));
            in = new FileInputStream(tempFile);
            byte[] buffer = new byte[8192];
            while ((nNumber = in.read(buffer)) != -1) {
                zos.write(buffer, 0, nNumber);
                zos.flush();
            }
            tempFile.delete();
            Object var6_6 = null;
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error("\u628a\u6587\u4ef6\u5939\u538b\u7f29\u6210\u538b\u7f29\u5305\uff0c\u5e76\u5220\u9664\u539f\u4e34\u65f6\u6587\u4ef6 \u6709\u8bef ", e);
            }
            break block8;
            {
                catch (Exception e) {
                    logger.error("\u538b\u7f29\u6587\u4ef6\u6709\u8bef", e);
                    throw new OtherException("\u538b\u7f29\u6587\u4ef6\u51fa\u9519", e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("\u628a\u6587\u4ef6\u5939\u538b\u7f29\u6210\u538b\u7f29\u5305\uff0c\u5e76\u5220\u9664\u539f\u4e34\u65f6\u6587\u4ef6 \u6709\u8bef ", e);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String Base64EncodingFile(String filePath) {
        FileInputStream fis;
        block14: {
            fis = null;
            String res = "";
            byte[] buff = null;
            File file = new File(filePath);
            if (!file.exists()) break block14;
            buff = new byte[(int)file.length()];
            fis = new FileInputStream(file);
            fis.read(buff);
            BASE64Encoder encoder = new BASE64Encoder();
            String string = res = encoder.encodeBuffer(buff);
            Object var8_10 = null;
            try {
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
            }
            catch (IOException ex2) {
                logger.error("\u8f6c\u7801\u6587\u4ef6\uff0c\u5173\u95ed\u6570\u636e\u6d41\u5f02\u5e38", ex2);
                ex2.printStackTrace();
            }
            return string;
        }
        String string = null;
        Object var8_11 = null;
        try {
            if (fis != null) {
                fis.close();
                fis = null;
            }
        }
        catch (IOException ex2) {
            logger.error("\u8f6c\u7801\u6587\u4ef6\uff0c\u5173\u95ed\u6570\u636e\u6d41\u5f02\u5e38", ex2);
            ex2.printStackTrace();
        }
        return string;
        catch (IOException ex) {
            String string2;
            try {
                logger.error("\u8f6c\u7801\u6587\u4ef6\u6709\u8bef", ex);
                string2 = null;
                Object var8_12 = null;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                try {
                    if (fis != null) {
                        fis.close();
                        fis = null;
                    }
                }
                catch (IOException ex2) {
                    logger.error("\u8f6c\u7801\u6587\u4ef6\uff0c\u5173\u95ed\u6570\u636e\u6d41\u5f02\u5e38", ex2);
                    ex2.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
            }
            catch (IOException ex2) {
                logger.error("\u8f6c\u7801\u6587\u4ef6\uff0c\u5173\u95ed\u6570\u636e\u6d41\u5f02\u5e38", ex2);
                ex2.printStackTrace();
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean Base64DecodingFile(String code, String filePath) {
        boolean bl;
        FileOutputStream fos = null;
        if (code == null) {
            return false;
        }
        try {
            try {
                byte[] buff = null;
                BASE64Decoder decoder = new BASE64Decoder();
                buff = decoder.decodeBuffer(code);
                fos = new FileOutputStream(filePath);
                fos.write(buff);
                bl = true;
                Object var7_8 = null;
            }
            catch (IOException ex) {
                logger.error("\u8f6c\u7801base64\u5f02\u5e38", ex);
                boolean bl2 = false;
                Object var7_9 = null;
                try {
                    if (fos == null) return bl2;
                    fos.close();
                    return bl2;
                }
                catch (IOException ex2) {
                    logger.error("\u8f6c\u7801base64,\u5173\u95ed\u6570\u636e\u6d41\u5f02\u5e38", ex2);
                    ex2.printStackTrace();
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {}
            catch (IOException ex2) {
                logger.error("\u8f6c\u7801base64,\u5173\u95ed\u6570\u636e\u6d41\u5f02\u5e38", ex2);
                ex2.printStackTrace();
                throw throwable;
            }
            if (fos == null) throw throwable;
            fos.close();
            throw throwable;
        }
        try {}
        catch (IOException ex2) {
            logger.error("\u8f6c\u7801base64,\u5173\u95ed\u6570\u636e\u6d41\u5f02\u5e38", ex2);
            ex2.printStackTrace();
            return bl;
        }
        if (fos == null) return bl;
        fos.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean byteCopyFile(InputStream is, String filePath) {
        boolean bl;
        FileOutputStream fos = null;
        if (is == null) {
            return false;
        }
        try {
            try {
                int nNumber;
                fos = new FileOutputStream(filePath);
                byte[] buff = new byte[8192];
                while ((nNumber = is.read(buff)) > 0) {
                    fos.write(buff, 0, nNumber);
                }
                bl = true;
                Object var7_8 = null;
            }
            catch (IOException ex) {
                logger.error("\u5199\u6587\u4ef6\u51fa\u9519", ex);
                boolean bl2 = false;
                Object var7_9 = null;
                try {
                    if (fos == null) return bl2;
                    fos.close();
                    return bl2;
                }
                catch (IOException ex2) {
                    logger.error("\u5173\u95ed\u6d41\u51fa\u9519", ex2);
                    ex2.printStackTrace();
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {}
            catch (IOException ex2) {
                logger.error("\u5173\u95ed\u6d41\u51fa\u9519", ex2);
                ex2.printStackTrace();
                throw throwable;
            }
            if (fos == null) throw throwable;
            fos.close();
            throw throwable;
        }
        try {}
        catch (IOException ex2) {
            logger.error("\u5173\u95ed\u6d41\u51fa\u9519", ex2);
            ex2.printStackTrace();
            return bl;
        }
        if (fos == null) return bl;
        fos.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean WriteFile(byte[] code, String filePath) {
        boolean bl;
        FileOutputStream fos = null;
        if (code == null) {
            return false;
        }
        try {
            try {
                fos = new FileOutputStream(filePath);
                fos.write(code);
                bl = true;
                Object var6_5 = null;
            }
            catch (IOException ex) {
                logger.error("\u5c06\u4e8c\u8fdb\u5236\u5199\u5165pdf\u6587\u4ef6\u5f02\u5e38", ex);
                boolean bl2 = false;
                Object var6_6 = null;
                try {
                    if (fos == null) return bl2;
                    fos.close();
                    return bl2;
                }
                catch (IOException ex2) {
                    logger.error("\u5c06\u4e8c\u8fdb\u5236\u5199\u5165pdf\u6587\u4ef6\u5f02\u5e38,\u5173\u95ed\u6570\u636e\u6d41\u5f02\u5e38", ex2);
                    ex2.printStackTrace();
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {}
            catch (IOException ex2) {
                logger.error("\u5c06\u4e8c\u8fdb\u5236\u5199\u5165pdf\u6587\u4ef6\u5f02\u5e38,\u5173\u95ed\u6570\u636e\u6d41\u5f02\u5e38", ex2);
                ex2.printStackTrace();
                throw throwable;
            }
            if (fos == null) throw throwable;
            fos.close();
            throw throwable;
        }
        try {}
        catch (IOException ex2) {
            logger.error("\u5c06\u4e8c\u8fdb\u5236\u5199\u5165pdf\u6587\u4ef6\u5f02\u5e38,\u5173\u95ed\u6570\u636e\u6d41\u5f02\u5e38", ex2);
            ex2.printStackTrace();
            return bl;
        }
        if (fos == null) return bl;
        fos.close();
        return bl;
    }

    public static String getExtension(File file) {
        String ext = "";
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0 && i < name.length() - 1) {
            ext = name.substring(i + 1).toLowerCase();
        }
        return ext.toLowerCase();
    }

    public static String getFileName(File file) {
        String fileName = null;
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0 && i < name.length() - 1) {
            fileName = name.substring(0, i);
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean encryptPDF(String filePath, String password, String encryptFilePath) throws OtherException {
        Boolean result;
        block10: {
            block9: {
                result = false;
                if (null == password) break block9;
                PdfEncryptor.encrypt((PdfReader)new PdfReader(filePath), (OutputStream)new FileOutputStream(encryptFilePath), (byte[])password.getBytes(), (byte[])password.getBytes(), (int)2068, (boolean)true);
                result = true;
            }
            Object var6_4 = null;
            File tempfile = null;
            try {
                tempfile = new File(filePath);
                Object var9_8 = null;
                if (null == tempfile) break block10;
                tempfile.delete();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (null != tempfile) {
                    tempfile.delete();
                }
                throw throwable;
            }
            {
                break block10;
            }
            {
                catch (Exception e) {
                    logger.error("\u52a0\u5bc6pdf\u6587\u4ef6\u5f02\u5e38", e);
                    throw new OtherException("BIZ_012", null, e);
                }
            }
            catch (Throwable throwable) {
                block11: {
                    Object var6_5 = null;
                    tempfile = null;
                    try {
                        tempfile = new File(filePath);
                        Object var9_10 = null;
                        if (null == tempfile) break block11;
                        tempfile.delete();
                    }
                    catch (Throwable throwable2) {
                        Object var9_11 = null;
                        if (null != tempfile) {
                            tempfile.delete();
                        }
                        throw throwable2;
                    }
                    {
                    }
                }
                throw throwable;
            }
        }
        return result;
    }

    public static boolean decryptPDF(String filePath, String password, String decryptFilePath) {
        Boolean result = false;
        try {
            if (null != password) {
                PdfReader reader = new PdfReader(filePath, password.getBytes());
                PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(decryptFilePath));
                stamper.close();
                result = true;
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u5bc6pdf\u5f02\u5e38", e);
            e.printStackTrace();
        }
        return result;
    }

    public static boolean Tiff2Pdf(String tiffFile, String pdfFile) {
        Document document = new Document(PageSize.LETTER, 0.0f, 0.0f, 0.0f, 0.0f);
        int comps = 0;
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(pdfFile));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            RandomAccessFileOrArray ra = null;
            try {
                ra = new RandomAccessFileOrArray(tiffFile);
                comps = TiffImage.getNumberOfPages((RandomAccessFileOrArray)ra);
            }
            catch (IOException e) {
                logger.error("Tiff\u8f6c\u4e3aPdf,\u83b7\u53d6\u9875\u7801\u91cf\u5f02\u5e38", e);
                return false;
            }
            for (int c = 0; c < comps; ++c) {
                try {
                    Image img = TiffImage.getTiffImage((RandomAccessFileOrArray)ra, (int)(c + 1));
                    if (img == null) continue;
                    img.scalePercent(7200.0f / (float)img.getDpiX(), 6500.0f / (float)img.getDpiY());
                    document.setPageSize(new Rectangle(img.getScaledWidth(), img.getScaledHeight()));
                    img.setAbsolutePosition(0.0f, 0.0f);
                    cb.addImage(img);
                    document.newPage();
                    continue;
                }
                catch (DocumentException e) {
                    logger.error("Tiff\u8f6c\u4e3aPdf\u5f02\u5e38", e);
                }
            }
            ra.close();
            document.close();
        }
        catch (DocumentException e) {
            logger.error("Tiff\u8f6c\u4e3aPdf\u5f02\u5e38", e);
            return false;
        }
        catch (IOException e) {
            logger.error("Tiff\u8f6c\u4e3aPdf\u5f02\u5e38", e);
            return false;
        }
        return true;
    }

    public static boolean Tiff2PdfByExe(String tiffFile, String pdfFile) {
        boolean ret = false;
        if (!new File(tiffFile).exists()) {
            return false;
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            StringBuffer command = new StringBuffer();
            command.append("cmd /c ");
            command.append(ResourcePath.getInstance().get("pdfExePath") + " ");
            command.append(" ");
            command.append(tiffFile);
            command.append(" ");
            command.append(pdfFile);
            String targetFile = tiffFile.substring(0, tiffFile.lastIndexOf(46)) + ".pdf";
            runtime.exec(command.toString());
            for (int index = 5; index >= 1; --index) {
                runtime.exec(command.toString());
                Thread.sleep(10000L);
                if (!new File(targetFile).exists()) continue;
                ret = true;
                break;
            }
        }
        catch (IOException e) {
            logger.error("Tiff2PdfByExe error", e);
        }
        catch (Exception e) {
            logger.error("Tiff2PdfByExe error", e);
        }
        return ret;
    }

    public static boolean Imgs2Pdf(String[] imgFiles, String pdfFile) {
        Document document = new Document(PageSize.LETTER, 0.0f, 0.0f, 0.0f, 0.0f);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(pdfFile));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            for (int c = 0; c < imgFiles.length; ++c) {
                try {
                    Image img = Image.getInstance((String)imgFiles[c]);
                    if (img == null) continue;
                    document.setPageSize(new Rectangle(img.getWidth(), img.getHeight()));
                    document.newPage();
                    img.setAbsolutePosition(0.0f, 0.0f);
                    cb.addImage(img);
                    continue;
                }
                catch (DocumentException e) {
                    logger.error("Imgs2Pdf error", e);
                    continue;
                }
                catch (MalformedURLException e) {
                    logger.error("Imgs2Pdf error for MalformedURLException", e);
                    continue;
                }
                catch (IOException e) {
                    logger.error("Imgs2Pdf error for IOException", e);
                }
            }
            document.close();
        }
        catch (DocumentException e) {
            logger.error("Imgs2Pdf error", e);
            return false;
        }
        catch (FileNotFoundException e) {
            logger.error("Imgs2Pdf error for filenot found", e);
            return false;
        }
        return true;
    }

    public static String getFileNameFromPathWithNoExt(String path) {
        String ret = path.replaceAll("\\\\", "/");
        ret = ret.substring(ret.lastIndexOf(47) + 1);
        ret = ret.substring(0, ret.lastIndexOf(46));
        return ret;
    }

    public static void deleteFiles(String path) {
        if (null != path && path.length() > 0) {
            File[] fileList;
            File file = new File(path);
            if (file.isDirectory() && (fileList = file.listFiles()).length > 0) {
                for (File f : fileList) {
                    FileUtil.deleteFiles(f.toString());
                }
            }
            file.delete();
        }
    }

    public static byte[] InputStreamToByte(InputStream is) throws IOException {
        int ch;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        while ((ch = is.read()) != -1) {
            bytestream.write(ch);
        }
        byte[] data = bytestream.toByteArray();
        bytestream.close();
        return data;
    }

    public static InputStream byteTOInputStream(byte[] in) {
        ByteArrayInputStream is = new ByteArrayInputStream(in);
        return is;
    }

    public static String codeToFile(String code) throws OtherException {
        String filePath = System.getProperty("user.dir").replace("bin", "webapps");
        String filerealpath = filePath + File.separator + UUID.randomUUID() + ".pdf";
        String bakfilePath = filePath + File.separator + UUID.randomUUID() + "bak" + ".pdf";
        File temfile = new File(filePath);
        File newbakfile = new File(bakfilePath);
        File newfile = new File(filerealpath);
        if (temfile.exists() || temfile.mkdirs()) {
            if (!newfile.exists()) {
                try {
                    newbakfile.createNewFile();
                    FileUtil.Base64DecodingFile(code, bakfilePath);
                    String password = ResourcePath.getInstance().get("mip.pdfpassword");
                    if (newfile.createNewFile()) {
                        FileUtil.encryptPDF(bakfilePath, password, filerealpath);
                    }
                }
                catch (IOException e) {
                    throw new OtherException(e);
                }
                newbakfile.delete();
            }
            return filerealpath;
        }
        return "";
    }

    public static String byteToFile(InputStream is, String fileType) throws OtherException {
        String filePath = ResourcePath.getInstance().get("pdf");
        String bakfilePath = filePath + "\\" + UUID.randomUUID() + "." + fileType;
        File temfile = new File(filePath);
        File newbakfile = new File(bakfilePath);
        if (temfile.exists() || temfile.mkdirs()) {
            try {
                newbakfile.createNewFile();
                FileUtil.byteCopyFile(is, bakfilePath);
            }
            catch (IOException e) {
                throw new OtherException(e);
            }
            return bakfilePath;
        }
        return "";
    }

    public static String codeToFileDoc(String code) throws OtherException {
        String filePath = ResourcePath.getInstance().get("doc");
        String filerealpath = filePath + "\\" + UUID.randomUUID() + ".DOC";
        File temfile = new File(filePath);
        File newfile = new File(filerealpath);
        if (temfile.exists() || temfile.mkdirs()) {
            if (!newfile.exists()) {
                FileUtil.Base64DecodingFile(code, filerealpath);
            }
            return filerealpath;
        }
        return "";
    }

    public static String bakFile(String filePath) throws OtherException {
        String bakPath = ResourcePath.getInstance().get("pdf") + "\\" + UUID.randomUUID() + ".pdf";
        FileUtil.fileCopy(new File(filePath), new File(bakPath));
        return bakPath;
    }
}

