/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.common.utils.file;

import com.centit.cmip.sdk.common.utils.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipUtil {
    private static LogUtil logger = LogUtil.getLogger(GZipUtil.class);

    public static byte[] compress(byte[] data) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZipUtil.compress(bais, baos);
        byte[] output = baos.toByteArray();
        baos.flush();
        baos.close();
        bais.close();
        return output;
    }

    public static void compress(File file) throws IOException {
        GZipUtil.compress(file, true);
    }

    /*
     * Loose catch block
     */
    public static void compress(File file, boolean delete) throws IOException {
        block14: {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            fis = new FileInputStream(file);
            fos = new FileOutputStream(file.getPath() + ".gz");
            GZipUtil.compress(fis, fos);
            fos.flush();
            Object var6_4 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                logger.error("\u6587\u4ef6\u538b\u7f29\uff0c\u5173\u95ed\u6570\u636e\u6d41\u5f02\u5e38", ex);
            }
            if (delete) {
                file.delete();
            }
            break block14;
            {
                catch (IOException e) {
                    logger.error("\u6587\u4ef6\u538b\u7f29\u5f02\u5e38", e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ex) {
                    logger.error("\u6587\u4ef6\u538b\u7f29\uff0c\u5173\u95ed\u6570\u636e\u6d41\u5f02\u5e38", ex);
                }
                if (delete) {
                    file.delete();
                }
                throw throwable;
            }
        }
    }

    public static void compress(InputStream is, OutputStream os) throws IOException {
        int count;
        GZIPOutputStream gos = new GZIPOutputStream(os);
        byte[] data = new byte[1024];
        while ((count = is.read(data, 0, 1024)) != -1) {
            gos.write(data, 0, count);
        }
        gos.finish();
        gos.flush();
        gos.close();
    }

    public static void compress(String path) throws IOException {
        GZipUtil.compress(path, true);
    }

    public static void compress(String path, boolean delete) throws IOException {
        File file = new File(path);
        GZipUtil.compress(file, delete);
    }

    public static byte[] decompress(byte[] data) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZipUtil.decompress(bais, baos);
        data = baos.toByteArray();
        baos.flush();
        baos.close();
        bais.close();
        return data;
    }

    public static void decompress(File file) throws IOException {
        GZipUtil.decompress(file, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decompress(File file, boolean delete) throws IOException {
        try {
            FileInputStream fis = new FileInputStream(file);
            FileOutputStream fos = new FileOutputStream(file.getPath().replace(".gz", ""));
            GZipUtil.decompress(fis, fos);
            fos.flush();
            try {
                fos.close();
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u89e3\u538b\u7f29\u5173\u95ed\u6d41\u5f02\u5e38", e);
            }
            try {
                fis.close();
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u89e3\u538b\u7f29\u5173\u95ed\u6d41\u5f02\u5e38", e);
            }
            Object var6_7 = null;
            if (!delete) return;
            file.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!delete) throw throwable;
            file.delete();
            throw throwable;
        }
    }

    public static void decompress(InputStream is, OutputStream os) throws IOException {
        int count;
        GZIPInputStream gis = new GZIPInputStream(is);
        byte[] data = new byte[1024];
        while ((count = gis.read(data, 0, 1024)) != -1) {
            os.write(data, 0, count);
        }
        gis.close();
    }

    public static void decompress(String path) throws IOException {
        GZipUtil.decompress(path, true);
    }

    public static void decompress(String path, boolean delete) throws IOException {
        File file = new File(path);
        GZipUtil.decompress(file, delete);
    }
}

