/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.common.utils.reflect;

import com.centit.cmip.sdk.adapter.BaseAdapter;
import com.centit.cmip.sdk.common.define.Macro;
import com.centit.cmip.sdk.common.entity.ReqTransEntity;
import com.centit.cmip.sdk.common.entity.RespTransEntity;
import com.centit.cmip.sdk.common.exception.OtherException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class InvokeUtil {
    private static Logger logger = Logger.getLogger(InvokeUtil.class);

    public static Object invoke(String className, Object[] params) throws OtherException {
        try {
            BaseAdapter extJarClass = (BaseAdapter)Class.forName(className.trim()).newInstance();
            logger.info((Object)("\u6b63\u5728\u6267\u884c\u6a21\u5757" + className));
            Object result = extJarClass.excute(params[0], params[1]);
            return result;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7c7b\uff0c\u7c7b\u540d:" + className), (Throwable)e);
            throw new OtherException("OTHER_INVOKE_001", className, e);
        }
        catch (Exception e) {
            logger.error((Object)("\u4e1a\u52a1\u6a21\u5757\u53cd\u5c04\u65f6\u51fa\u9519\uff0c\u7c7b\u540d:" + className), (Throwable)e);
            throw new OtherException("OTHER_INVOKE_002", className, e);
        }
    }

    public static Object methodInvoke(Object instance, Object req, Object resp) throws OtherException {
        ReqTransEntity reqEntity = (ReqTransEntity)req;
        String methodName = "";
        Method method = null;
        try {
            methodName = reqEntity.getBody().getMethodName().trim();
            try {
                method = instance.getClass().getDeclaredMethod(methodName, ReqTransEntity.class, RespTransEntity.class);
            }
            catch (NoSuchMethodException e) {
                logger.info((Object)"\u6267\u884c\u53cd\u5c04\uff0c\u7ed9\u5b9a\u7c7b\u4e2d\u672a\u627e\u5230\u65b9\u6cd5\uff0c\u5c06\u5728\u7236\u7c7b\u4e2d\u67e5\u627e");
                method = instance.getClass().getSuperclass().getDeclaredMethod(methodName, ReqTransEntity.class, RespTransEntity.class);
            }
            Object result = method.invoke(instance, req, resp);
            method = null;
            return result;
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u65b9\u6cd5\uff0c\u7c7b\u540d:" + instance.getClass() + ",\u65b9\u6cd5\u540d:" + methodName), (Throwable)e);
            throw new OtherException("OTHER_INVOKE_002", methodName, e);
        }
        catch (Exception e) {
            logger.error((Object)("\u53cd\u5c04\u65f6\u51fa\u9519,\u7c7b\u540d:" + instance.getClass() + ",\u65b9\u6cd5\u540d:" + methodName), (Throwable)e);
            throw new OtherException("OTHER_INVOKE_003", methodName, e);
        }
    }

    public static Object invokeAdapterMethod(ReqTransEntity te, RespTransEntity respte) throws OtherException {
        Object ret = null;
        String className = "";
        try {
            JSONObject buJson = JSONObject.fromObject((Object)te.getBody());
            String bizCode = buJson.getString("bizCode");
            String bizType = buJson.getString("bizType");
            ArrayList<Object> paramList = new ArrayList<Object>();
            paramList.add(te);
            paramList.add(respte);
            logger.info((Object)("\u8c03\u7528" + bizCode + "\u7684" + bizType + "\u6a21\u5757\u5f00\u59cb"));
            className = Macro.CLASSPATH_PREFIX_STRING + "." + bizCode + "." + bizType;
            ret = InvokeUtil.invoke(className, paramList.toArray());
            logger.info((Object)("\u8c03\u7528" + bizCode + "\u7684" + bizType + "\u6a21\u5757\u7ed3\u675f"));
            return ret;
        }
        catch (OtherException e) {
            logger.error((Object)"\u53cd\u5c04\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
            if (!OtherException.class.isAssignableFrom(e.getClass())) {
                logger.info((Object)("\u8c03\u7528\u7684" + className + "\u51fa\u9519"));
                throw new OtherException(e);
            }
            return ret;
        }
    }
}

