/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.common.utils;

import com.centit.cmip.sdk.common.utils.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.xml.XMLSerializer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlConvertUtil {
    private static LogUtil logger = LogUtil.getLogger(XmlConvertUtil.class);

    public static String maptoXml(Map map) {
        Document document = DocumentHelper.createDocument();
        Element nodeElement = document.addElement("node");
        for (Map.Entry obj : map.entrySet()) {
            Element keyElement = nodeElement.addElement("key");
            keyElement.addAttribute("label", String.valueOf(obj));
            keyElement.setText(String.valueOf(map.get(obj)));
        }
        return XmlConvertUtil.doc2String(document);
    }

    public static String maptoXml(Map map, String node) {
        Document document = DocumentHelper.createDocument();
        Element nodeElement = document.addElement(node);
        for (Map.Entry obj : map.entrySet()) {
            Element keyElement = nodeElement.addElement(String.valueOf(obj));
            keyElement.setText(String.valueOf(map.get(obj)));
        }
        return XmlConvertUtil.doc2String(document);
    }

    public static String listtoXml(List list) {
        Document document = DocumentHelper.createDocument();
        Element nodesElement = document.addElement("nodes");
        int i = 0;
        for (Object o : list) {
            Element nodeElement = nodesElement.addElement("node");
            if (o instanceof Map) {
                for (Object obj : ((Map)o).keySet()) {
                    Element keyElement = nodeElement.addElement("key");
                    keyElement.addAttribute("label", String.valueOf(obj));
                    keyElement.setText(String.valueOf(((Map)o).get(obj)));
                }
            } else {
                Element keyElement = nodeElement.addElement("key");
                keyElement.addAttribute("label", String.valueOf(i));
                keyElement.setText(String.valueOf(o));
            }
            ++i;
        }
        return XmlConvertUtil.doc2String(document);
    }

    public static String listtoXml(List list, String node, String subnode) {
        Document document = DocumentHelper.createDocument();
        Element nodesElement = document.addElement(node);
        int i = 0;
        for (Object o : list) {
            Element nodeElement = nodesElement.addElement(subnode);
            if (o instanceof Map) {
                for (Object obj : ((Map)o).keySet()) {
                    Element keyElement = nodeElement.addElement(String.valueOf(obj));
                    keyElement.setText(String.valueOf(((Map)o).get(obj)));
                }
            } else {
                Element keyElement = nodeElement.addElement(String.valueOf(i));
                keyElement.setText(String.valueOf(o));
            }
            ++i;
        }
        return XmlConvertUtil.doc2String(document);
    }

    public static String jsontoXml(String json) {
        XMLSerializer serializer = new XMLSerializer();
        JSON jsonObject = JSONSerializer.toJSON((Object)json);
        return serializer.write(jsonObject);
    }

    public static Map xmltoMap(String xml, boolean flag) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            Document document = DocumentHelper.parseText((String)xml);
            Element nodeElement = document.getRootElement();
            List node = nodeElement.elements();
            for (Element elm : node) {
                if (flag) {
                    map.put(elm.attributeValue("label"), elm.getText());
                } else {
                    map.put(elm.getName(), elm.getText());
                }
                elm = null;
            }
            return map;
        }
        catch (DocumentException e) {
            logger.error("xml to map error", e);
            return null;
        }
    }

    public static List xmltoList(String xml, boolean flag) {
        try {
            ArrayList<Map> list = new ArrayList<Map>();
            Document document = DocumentHelper.parseText((String)xml);
            Element nodesElement = document.getRootElement();
            List nodes = nodesElement.elements();
            for (Element nodeElement : nodes) {
                Map map = XmlConvertUtil.xmltoMap(nodeElement.asXML(), flag);
                list.add(map);
                map = null;
            }
            return list;
        }
        catch (DocumentException e) {
            logger.error("xml to list error", e);
            return null;
        }
    }

    public static String doc2String(Document document) {
        String s = "";
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputFormat format = new OutputFormat("   ", true, "UTF-8");
            XMLWriter writer = new XMLWriter((OutputStream)out, format);
            writer.write(document);
            s = out.toString("UTF-8");
        }
        catch (Exception ex) {
            logger.error("doc to String error", ex);
        }
        return s;
    }
}

