/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.app.loader.parse;

import com.centit.cmip.app.loader.parse.LoaderException;
import com.centit.cmip.sdk.common.define.Macro;
import com.centit.cmip.sdk.common.utils.StringUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ThirdPartyXMLReader {
    private static ThirdPartyXMLReader reader;
    public Map<String, Object> datas = new HashMap<String, Object>();

    public static ThirdPartyXMLReader getInstance() {
        if (reader == null) {
            reader = new ThirdPartyXMLReader();
        }
        return reader;
    }

    public void loadConfig(String configFilePath) throws LoaderException {
        String absolutePath = null;
        if (configFilePath == null) {
            throw new LoaderException("\u672a\u53d1\u73b0\u4e8c\u6b21\u5f00\u53d1\u6240\u9700\u7684\u914d\u7f6e\u6587\u4ef6\uff01");
        }
        try {
            String classPath = ThirdPartyXMLReader.class.getClassLoader().getResource("/").toURI().getPath();
            absolutePath = String.valueOf(classPath) + configFilePath;
            FileInputStream is = new FileInputStream(absolutePath);
            if (is != null) {
                this.init(is);
                this.updateMacro();
            }
        }
        catch (FileNotFoundException ffe) {
            throw new LoaderException(String.format("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u914d\u7f6e\u6587\u4ef6\uff1a%s", configFilePath));
        }
        catch (DocumentException e) {
            throw new LoaderException("\u8bfb\u53d6\u5e76\u89e3\u6790\u914d\u7f6e\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f\uff01");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void init(InputStream is) throws DocumentException {
        SAXReader sax = new SAXReader();
        Document doc = sax.read(is);
        List dicList = doc.selectNodes("/configuration/*");
        this.parse(dicList);
    }

    private void parse(List<?> dicList) {
        for (Element element : dicList) {
            String key = element.getName();
            String value = element.getTextTrim();
            List list = element.elements();
            if (!list.isEmpty()) {
                this.parse(list);
            }
            if (StringUtil.isEmpty(value)) continue;
            this.datas.put(key.toLowerCase(), value);
        }
    }

    private void updateMacro() {
        Field[] fields;
        Field[] fieldArray = fields = Macro.class.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ("CLASSPATH_PREFIX_STRING".equals(field.getName())) {
                Macro.CLASSPATH_PREFIX_STRING = this.getDatas().get("package") != null ? (String)this.getDatas().get("package") : Macro.CLASSPATH_PREFIX_STRING;
            }
            ++n2;
        }
    }

    public Map<String, Object> getDatas() {
        return this.datas;
    }

    public void setDatas(Map<String, Object> datas) {
        this.datas = datas;
    }
}

