/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.common.utils;

import com.centit.cmip.sdk.common.exception.OtherException;
import com.centit.cmip.sdk.common.utils.DateUtil;
import com.centit.cmip.sdk.common.utils.file.ResourcePath;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class LogUtil {
    public static Map<String, LogUtil> logServices = new HashMap<String, LogUtil>();
    private Logger logger4j = null;

    static {
        try {
            System.out.println(ResourcePath.getInstance().get("log4j.path"));
            InputStream is = LogUtil.class.getResourceAsStream(ResourcePath.getInstance().get("log4j.path"));
            LogUtil.init(is);
        }
        catch (OtherException e) {
            e.printStackTrace();
        }
    }

    private LogUtil(String moduleName) {
        this.logger4j = Logger.getLogger((String)moduleName);
    }

    public static LogUtil getLogger(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        if (logServices.containsKey(packageName)) {
            return logServices.get(packageName);
        }
        LogUtil logService = new LogUtil(packageName);
        logServices.put(packageName, logService);
        return logService;
    }

    public void performance(String funcDesc, String flag) {
        String pattern = "yyyy-MM-dd HH:mm:ss.SSS";
        StringBuffer sb = new StringBuffer();
        sb.append(DateUtil.formatDate(Calendar.getInstance().getTime(), pattern));
        sb.append(" \u529f\u80fd\uff1a");
        sb.append(funcDesc);
        sb.append(" \u8d77\u59cb\u6807\u8bc6\uff1a");
        if ("0".equals(flag)) {
            sb.append("\u5f00\u59cb");
        } else {
            sb.append("\u7ed3\u675f");
        }
        this.logger4j.info((Object)sb.toString());
    }

    public void error(String code, String description, Throwable e, Object object) {
        StringBuffer sb = new StringBuffer();
        if (code != null) {
            sb.append(String.format("C:[%s] ", code));
        }
        sb.append("- ");
        sb.append(description);
        if (object != null) {
            sb.append(String.format(" P:[%s] ", object.toString()));
        }
        if (e != null) {
            sb.append("\n");
            sb.append(e.toString());
            sb.append(Arrays.toString(e.getStackTrace()));
        }
        this.logger4j.error((Object)sb.toString());
    }

    public void error(String source, String method, String code, String description, String user, Throwable e, Object object) {
        StringBuffer sb = new StringBuffer();
        if (source != null) {
            sb.append(String.format("S:[%s] ", source));
        }
        if (code != null) {
            sb.append(String.format("C:[%s] ", code));
        }
        sb.append("- ");
        sb.append(description);
        if (object != null) {
            sb.append(String.format(" P:[%s] ", object.toString()));
        }
        if (user != null) {
            sb.append(String.format("U:[%s] ", user));
        }
        if (e != null) {
            sb.append("\n");
            sb.append(e.toString());
            sb.append(Arrays.toString(e.getStackTrace()));
        }
        this.logger4j.error((Object)sb.toString());
    }

    public void errorLog(String source, String method, String description, Throwable e) {
        StringBuffer sb = new StringBuffer();
        if (source != null) {
            sb.append(String.format("S:[%s] ", source));
        }
        sb.append("- ");
        sb.append(description);
        if (e != null) {
            sb.append("\n");
            sb.append(e.toString());
            sb.append(Arrays.toString(e.getStackTrace()));
        }
        this.logger4j.error((Object)sb.toString());
    }

    public void error(String description, Throwable e) {
        StringBuffer sb = new StringBuffer();
        sb.append(description);
        sb.append(" ]\n");
        if (e != null) {
            sb.append(e.toString());
            sb.append(Arrays.toString(e.getStackTrace()));
        }
        this.logger4j.error((Object)sb.toString());
    }

    public void error(String description) {
        this.logger4j.error((Object)description);
    }

    public void warn(String code, String description, Throwable e, Object object) {
        StringBuffer sb = new StringBuffer();
        sb.append(" \u8b66\u544a\u7f16\u53f7\uff1a[");
        sb.append(code);
        sb.append("] - ");
        sb.append(description);
        sb.append(" parameters [ ");
        sb.append(object);
        sb.append(" ]\n");
        if (e != null) {
            sb.append(e.toString());
            sb.append(Arrays.toString(e.getStackTrace()));
        }
        this.logger4j.warn((Object)sb.toString());
    }

    public void warn(String description) {
        this.logger4j.warn((Object)description);
    }

    public void info(String description, Object object) {
        StringBuffer sb = new StringBuffer();
        sb.append(description);
        sb.append(" P:[ ");
        sb.append(object);
        sb.append(" ]\n");
        this.logger4j.info((Object)sb.toString());
    }

    public void info(String description) {
        this.logger4j.info((Object)description);
    }

    public void info(String source, String description, String user) {
        String infoString = String.format("S:[%s] %s U:[%s]", source, description, user);
        this.logger4j.info((Object)infoString);
    }

    public void debug(Object message) {
        this.logger4j.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.logger4j.debug(message, t);
    }

    public boolean isDebugEnabled() {
        return this.logger4j.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger4j.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger4j.isEnabledFor((Priority)Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.logger4j.isEnabledFor((Priority)Level.ERROR);
    }

    private static void init(InputStream is) {
        try {
            try {
                Properties props = new Properties();
                props.load(is);
                PropertyConfigurator.configure((Properties)props);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

