/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.common.dialect;

import com.centit.cmip.sdk.common.dialect.Dialect;

public class MybatisDB2Dialect
extends Dialect {
    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    private static String getRowNumber(String sql) {
        StringBuffer rownumber = new StringBuffer().append("rownumber() over(");
        int orderByIndex = sql.toLowerCase().indexOf("order by");
        if (orderByIndex > 0 && !MybatisDB2Dialect.hasDistinct(sql)) {
            rownumber.append(sql.substring(orderByIndex));
        }
        rownumber.append(") as rownumber_,");
        return rownumber.toString();
    }

    private static boolean hasDistinct(String sql) {
        return sql.toLowerCase().indexOf("select distinct") >= 0;
    }

    public String getLimitString(String sql, int offset, String offsetPlaceholder, int limit, String limitPlaceholder) {
        int temp = 6;
        int tempInt = 100;
        int startOfSelect = sql.toLowerCase().indexOf("select");
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100).append(sql.substring(0, startOfSelect)).append("select * from ( select ").append(MybatisDB2Dialect.getRowNumber(sql));
        if (MybatisDB2Dialect.hasDistinct(sql)) {
            pagingSelect.append(" row_.* from ( ").append(sql.substring(startOfSelect)).append(" ) as row_");
        } else {
            pagingSelect.append(sql.substring(startOfSelect + 6));
        }
        pagingSelect.append(" ) as temp_ where rownumber_ ");
        if (offset > 0) {
            String endString = offsetPlaceholder + "+" + limitPlaceholder;
            pagingSelect.append("between " + offsetPlaceholder + "+1 and " + endString);
        } else {
            pagingSelect.append("<= " + limitPlaceholder);
        }
        return pagingSelect.toString();
    }
}

