/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.protocol.router;

import com.centit.cmip.sdk.protocol.handler.BaseHandler;
import com.centit.cmip.sdk.protocol.handler.DownloadHandler;
import com.centit.cmip.sdk.protocol.handler.GeneralHandler;
import com.centit.cmip.sdk.protocol.handler.UploadHandler;
import com.centit.cmip.sdk.protocol.router.RequestModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import org.springframework.stereotype.Component;

@Component
public class RequestRouter {
    private List<BaseHandler> baseHandlers = new ArrayList<BaseHandler>();
    private Map<String, BaseHandler> request2Handlers = new ConcurrentHashMap<String, BaseHandler>();
    @Resource
    private GeneralHandler generalHandler;
    @Resource
    private DownloadHandler downloadHandler;
    @Resource
    private UploadHandler uploadHandler;

    @PostConstruct
    public void init() {
        this.baseHandlers.add(this.generalHandler);
        this.baseHandlers.add(this.downloadHandler);
        this.baseHandlers.add(this.uploadHandler);
    }

    public void route(RequestModel model) throws ServletException, IOException {
        String requestType = model.getJsonObj().getString("requestType");
        BaseHandler handler = this.getHandler(requestType);
        if (null != handler) {
            handler.process(model.getRequest(), model.getResponse());
        }
    }

    private BaseHandler getHandler(String requestType) {
        BaseHandler handler = this.request2Handlers.get(requestType);
        if (handler == null) {
            for (BaseHandler handlerCandidate : this.baseHandlers) {
                if (!requestType.equalsIgnoreCase(handlerCandidate.getRequestType())) continue;
                handler = handlerCandidate;
                this.request2Handlers.put(requestType, handler);
                break;
            }
        }
        return handler;
    }
}

