/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.common.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public abstract class AbstractAppException
extends Exception
implements Serializable {
    private static final long serialVersionUID = 2804184109545965887L;
    private Throwable cause;
    private String errorCode;

    public AbstractAppException() {
        super("Error occurred in application.");
    }

    public AbstractAppException(Throwable causeParam) {
        super(causeParam);
        this.cause = causeParam;
    }

    public AbstractAppException(String message, Throwable causeParam) {
        super(message);
        this.cause = causeParam;
    }

    public AbstractAppException(String errorCode, String message, Throwable causeParam) {
        super(message);
        this.cause = causeParam;
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public abstract String getErrorMsg(String var1);

    @Override
    public Throwable initCause(Throwable causeParam) {
        this.cause = causeParam;
        return this.cause;
    }

    @Override
    public String getMessage() {
        String msg = String.valueOf(this.getErrorMsg(this.errorCode)) + "\u5f02\u5e38\u4fe1\u606f\uff1a" + super.getMessage();
        AbstractAppException parent = this;
        Throwable child = this.getNestedException(parent);
        if (child != null) {
            StackTraceElement[] trace;
            String msg2 = "\n" + child.getMessage();
            StringBuilder msg3SB = new StringBuilder();
            msg3SB.append("\n\u9519\u8bef\u4ee3\u7801\u6bb5 : ");
            StackTraceElement[] stackTraceElementArray = trace = child.getStackTrace();
            int n = trace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                msg3SB.append("\n");
                msg3SB.append(stackTraceElement);
                ++n2;
            }
            if (msg2 != null) {
                msg = String.valueOf(msg) + msg2 + msg3SB.toString();
            }
        }
        return msg;
    }

    @Override
    public void printStackTrace() {
        AbstractAppException parent = this;
        Throwable child = this.getNestedException(parent);
        if (child != null) {
            System.err.print("Caused by: ");
            child.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        Throwable child;
        AbstractAppException parent = this;
        while ((child = this.getNestedException(parent)) != null) {
            if (child == null) continue;
            s.print("Caused by: ");
            child.printStackTrace(s);
            break;
        }
    }

    @Override
    public void printStackTrace(PrintWriter w) {
        Throwable child;
        AbstractAppException parent = this;
        while ((child = this.getNestedException(parent)) != null) {
            if (child == null) continue;
            w.print("Caused by: ");
            child.printStackTrace(w);
            break;
        }
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public Throwable getNestedException(Throwable parent) {
        if (parent != null) {
            Throwable e2 = parent.getCause();
            if (e2 != null) {
                return e2;
            }
            return parent;
        }
        return null;
    }
}

