/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.dao;

import com.centit.cmip.sdk.dao.IBaseDAO;
import java.util.List;
import javax.annotation.Resource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.log4j.Logger;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.dao.support.DaoSupport;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public abstract class BaseDao
extends DaoSupport
implements IBaseDAO {
    private static Logger logger = Logger.getLogger(BaseDao.class);
    @Resource
    private SqlSessionFactory sqlSessionFactory;
    private SqlSessionTemplate sqlSessionTemplate;

    protected void checkDaoConfig() {
        Assert.notNull((Object)this.sqlSessionFactory, (String)"sqlSessionFactory must be not null");
    }

    public SqlSessionTemplate getSqlSessionTemplate() {
        if (this.sqlSessionTemplate == null) {
            this.sqlSessionTemplate = new SqlSessionTemplate(this.sqlSessionFactory);
        }
        return this.sqlSessionTemplate;
    }

    public void setSqlSessionTemplate(SqlSessionTemplate sessionTemplate) {
        this.sqlSessionTemplate = sessionTemplate;
    }

    @Override
    public Object queryForObject(String statement, Object condition) {
        Object object = null;
        try {
            object = this.getSqlSessionTemplate().selectOne(String.valueOf(this.getIbatisMapperNamesapce()) + "." + statement, condition);
        }
        catch (Exception e) {
            logger.error((Object)("\u6267\u884c" + statement + "\u8bed\u53e5\u5f02\u5e38"), (Throwable)e);
        }
        return object;
    }

    @Override
    public List<?> queryForList(String statement, Object condition) {
        List list = null;
        try {
            list = this.getSqlSessionTemplate().selectList(String.valueOf(this.getIbatisMapperNamesapce()) + "." + statement, condition);
        }
        catch (Exception e) {
            logger.error((Object)("\u6267\u884c" + statement + "\u8bed\u53e5\u5f02\u5e38"), (Throwable)e);
        }
        return list;
    }

    @Override
    public Integer update(String statement, Object condition) {
        Integer affectCount = 0;
        try {
            affectCount = this.getSqlSessionTemplate().update(String.valueOf(this.getIbatisMapperNamesapce()) + "." + statement, condition);
            this.getSqlSessionTemplate().commit(true);
        }
        catch (Exception e) {
            logger.error((Object)("\u6267\u884c" + statement + "\u8bed\u53e5\u5f02\u5e38"), (Throwable)e);
        }
        return affectCount;
    }

    @Override
    public Object insert(String statement, Object condition) {
        int affectCount = 0;
        try {
            affectCount = this.getSqlSessionTemplate().insert(String.valueOf(this.getIbatisMapperNamesapce()) + "." + statement, condition);
            this.getSqlSessionTemplate().commit(true);
        }
        catch (Exception e) {
            logger.error((Object)("\u6267\u884c" + statement + "\u8bed\u53e5\u5f02\u5e38"), (Throwable)e);
        }
        return affectCount;
    }

    @Override
    public Object delete(String statement, Object condition) {
        int affectCount = 0;
        try {
            affectCount = this.getSqlSessionTemplate().delete(String.valueOf(this.getIbatisMapperNamesapce()) + "." + statement, condition);
            this.getSqlSessionTemplate().commit(true);
        }
        catch (Exception e) {
            logger.error((Object)("\u6267\u884c" + statement + "\u8bed\u53e5\u5f02\u5e38"), (Throwable)e);
        }
        return affectCount;
    }

    public abstract String getIbatisMapperNamesapce();
}

