/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.common.utils;

import com.centit.cmip.sdk.common.entity.ReqTransEntity;
import com.centit.cmip.sdk.common.entity.RespHeader;
import com.centit.cmip.sdk.common.entity.RespTransEntity;
import com.centit.cmip.sdk.common.exception.OtherException;
import com.centit.cmip.sdk.common.utils.DateUtil;
import com.centit.cmip.sdk.common.utils.file.ResourcePath;
import com.centit.cmip.sdk.common.utils.security.DecryptionAES;
import com.centit.cmip.sdk.common.utils.security.EncryptionAES;
import javax.servlet.ServletRequest;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class MessageUtil {
    private static Logger logger = Logger.getLogger(MessageUtil.class);

    public static String checkMessage(JSONObject json) {
        StringBuilder result = new StringBuilder();
        try {
            if (json.containsKey((Object)"header")) {
                String[] cfields;
                JSONObject head = json.getJSONObject("header");
                String checkFields = ResourcePath.getInstance().get("mip.needFields");
                String[] stringArray = cfields = checkFields.split(",");
                int n = cfields.length;
                int n2 = 0;
                while (n2 < n) {
                    String cfield = stringArray[n2];
                    String checkField = cfield.substring(0, cfield.indexOf(":"));
                    if (!head.containsKey((Object)checkField)) {
                        result.append("\u8bf7\u6c42\u53c2\u6570\u4e2d\u7f3a\u5c11" + cfield.substring(checkField.length()) + "\u5b57\u6bb5;");
                    }
                    ++n2;
                }
            } else {
                result.append("\u7f3a\u5c11header\u8bf7\u6c42\u53c2\u6570");
            }
        }
        catch (OtherException e) {
            logger.error((Object)"\u6821\u9a8c\u6d88\u606f\u662f\u5426\u5408\u6cd5\u5f02\u5e38", (Throwable)e);
        }
        return result.toString();
    }

    public static Object decodeMessage(Object requestMessage) {
        String transPassword = "";
        try {
            transPassword = ResourcePath.getInstance().get("mip.transPassword");
        }
        catch (OtherException e) {
            transPassword = "";
            logger.error((Object)"\u83b7\u53d6\u52a0\u89e3\u5bc6\u89c4\u5219\u7801\u5f02\u5e38");
        }
        return DecryptionAES.decrypt(requestMessage.toString(), transPassword);
    }

    public static Object encodeMessage(Object responseMessage) throws OtherException {
        String transPassword = "";
        try {
            transPassword = ResourcePath.getInstance().get("mip.transPassword");
        }
        catch (OtherException e) {
            logger.error((Object)"\u83b7\u53d6\u52a0\u89e3\u5bc6\u89c4\u5219\u7801\u5f02\u5e38");
        }
        return EncryptionAES.encrypt(JSONObject.fromObject((Object)responseMessage).toString(), transPassword);
    }

    public static Object getIllegalMessageResponse(ServletRequest request) {
        return null;
    }

    public static Object getIllegalUserResponse(ServletRequest request) {
        return null;
    }

    public static RespTransEntity req2respEntity(ReqTransEntity reqEntity) {
        RespTransEntity resqEntity = new RespTransEntity();
        RespHeader header = new RespHeader();
        header.setResponseDateTime(DateUtil.current(DateUtil.TIMESTAMP_FORMAT_SSS));
        header.setSupportedDevices("");
        header.setCanDebug("0");
        header.setRetCode(reqEntity.getHeader().getRetCode());
        header.setRetMsg(reqEntity.getHeader().getRetMsg());
        header.setMessageId(reqEntity.getHeader().getMessageId());
        header.setSessionId(reqEntity.getHeader().getSessionId());
        header.setUserCode(reqEntity.getHeader().getUserId());
        resqEntity.setHeader(header);
        return resqEntity;
    }

    public static String encryptBody(Object body) {
        if (body == null || "".equals(body)) {
            return "";
        }
        String transPassword = "";
        try {
            transPassword = ResourcePath.getInstance().get("mip.transPassword");
        }
        catch (OtherException e) {
            logger.error((Object)"\u83b7\u53d6\u52a0\u89e3\u5bc6\u89c4\u5219\u7801\u5f02\u5e38");
        }
        return EncryptionAES.encrypt(JSONObject.fromObject((Object)body).toString(), transPassword);
    }

    public static void main(String[] args) {
        System.out.println(DecryptionAES.decrypt("0400663235B14741FBBAA0CA154C759792B802D32D25B47020CB6507ED3A80E2DC024FF80987ED6222CE69409B8C69726B83CCF248FD066333A1D8A2EA3CAB3B6B79D4247A350547F9508950EE208D825B3F51E3DCA66DDC88D38DD746E2985EFE3FB3E9B0A8F9057C3EC9139432FCD15F610E33589CF49B8683343CC43085F5F23B6FCC404E1DE0FFEBEFB65BE17AFC", "CMIP.CENTIT.COM"));
    }
}

