/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.common.utils;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class StringUtil {
    private static Logger logger = Logger.getLogger(StringUtil.class);

    public static boolean isEmpty(String strVal) {
        return strVal == null || StringUtil.safeTrim(strVal).isEmpty();
    }

    public static boolean isNotEmpty(String strVal) {
        return !StringUtil.isEmpty(strVal);
    }

    public static String safeToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static String safeTrim(Object obj) {
        char[] charArr = StringUtil.safeToString(obj).toCharArray();
        int i = 0;
        while (i < charArr.length) {
            if (charArr[i] > ' ' && charArr[i] != '\u3000') break;
            if (charArr[i] == '\u3000') {
                charArr[i] = 32;
            }
            ++i;
        }
        i = charArr.length - 1;
        while (i >= 0) {
            if (charArr[i] > ' ' && charArr[i] != '\u3000') break;
            if (charArr[i] == '\u3000') {
                charArr[i] = 32;
            }
            --i;
        }
        return new String(charArr).trim();
    }

    public static String getPageNameByUrl(String strUrl) {
        String strResult = null;
        if (!StringUtil.isEmpty(strUrl)) {
            int beginIndex = strUrl.lastIndexOf(47);
            int endIndex = strUrl.lastIndexOf(95);
            int endPointIndex = strUrl.lastIndexOf(46);
            String type = null;
            if (endPointIndex != -1) {
                type = strUrl.substring(endPointIndex + 1);
            }
            if (!StringUtil.isEmpty(type) && "jsp".equalsIgnoreCase(type)) {
                if (beginIndex > 0 && endPointIndex > 0) {
                    strResult = strUrl.substring(beginIndex + 1, endPointIndex);
                }
            } else if (beginIndex > 0 && endIndex > 0) {
                strResult = strUrl.substring(beginIndex + 1, endIndex);
            }
        }
        return strResult;
    }

    public static String safeReplace(String source, String target, String replacement) {
        if (source == null || source.isEmpty() || target == null || target.isEmpty() || target.equals(replacement)) {
            return source;
        }
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        int targetLen = target.length();
        int offset = 0;
        while ((offset = source.indexOf(target, offset)) != -1) {
            offsets.add(offset);
            offset += targetLen;
        }
        String result = source;
        if (!offsets.isEmpty()) {
            int sourceLen = source.length();
            if (replacement == null) {
                replacement = new String();
            }
            int replacementLen = replacement.length();
            int offsetsSize = offsets.size();
            int resultLen = sourceLen + (replacementLen - targetLen) * offsetsSize;
            char[] sourceCharArr = source.toCharArray();
            char[] replacementCharArr = replacement.toCharArray();
            char[] destCharArr = new char[resultLen];
            int firstOffset = (Integer)offsets.get(0);
            System.arraycopy(sourceCharArr, 0, destCharArr, 0, firstOffset);
            if (replacementLen > 0) {
                System.arraycopy(replacementCharArr, 0, destCharArr, firstOffset, replacementCharArr.length);
            }
            int preOffset = firstOffset;
            int destPos = firstOffset + replacementCharArr.length;
            int i = 1;
            while (i < offsetsSize) {
                offset = (Integer)offsets.get(i);
                int fragmentLen = offset - preOffset - targetLen;
                System.arraycopy(sourceCharArr, preOffset + targetLen, destCharArr, destPos, fragmentLen);
                destPos += fragmentLen;
                if (replacementLen > 0) {
                    System.arraycopy(replacementCharArr, 0, destCharArr, destPos, replacementCharArr.length);
                }
                preOffset = offset;
                destPos += replacementCharArr.length;
                ++i;
            }
            int lastFragmentLen = sourceLen - preOffset - targetLen;
            System.arraycopy(sourceCharArr, preOffset + targetLen, destCharArr, destPos, lastFragmentLen);
            result = new String(destCharArr);
        }
        return result;
    }

    public static boolean contains(String str, String compare) {
        boolean bool = true;
        if (StringUtil.isEmpty(str)) {
            bool = false;
        } else if (str.indexOf(compare) < 0) {
            bool = false;
        }
        return bool;
    }

    public static boolean notContains(String str, String compare) {
        return !StringUtil.contains(str, compare);
    }

    public static String toFirstLetterUpperCase(String str) {
        if (StringUtil.isNotEmpty(str)) {
            String firstLetter = str.substring(0, 1).toUpperCase();
            return String.valueOf(firstLetter) + str.substring(1, str.length());
        }
        return str;
    }

    public static String toFirstLetterLowerCase(String str) {
        if (StringUtil.isNotEmpty(str)) {
            String firstLetter = str.substring(0, 1).toLowerCase();
            return String.valueOf(firstLetter) + str.substring(1, str.length());
        }
        return str;
    }

    public static Short toShort(Object value) throws NumberFormatException {
        String val = value != null ? String.valueOf(value) : null;
        if (StringUtil.isNotEmpty(val)) {
            return Short.valueOf(StringUtil.safeTrim(val));
        }
        return null;
    }

    public static Integer toInteger(Object value) throws NumberFormatException {
        String val = value != null ? String.valueOf(value) : null;
        if (StringUtil.isNotEmpty(val)) {
            return Integer.valueOf(StringUtil.safeTrim(val));
        }
        return null;
    }

    public static String toStrWithEmpty(Object inObject) {
        if (inObject == null) {
            return "";
        }
        return inObject.toString();
    }

    public static Integer toIntegerwithZero(Object value) throws NumberFormatException {
        String val = StringUtil.toStrWithEmpty(value);
        if (StringUtil.isEmpty(val)) {
            return 0;
        }
        return Integer.valueOf(StringUtil.safeTrim(val));
    }

    public static Long toLong(Object value) throws NumberFormatException {
        String val = value != null ? String.valueOf(value) : null;
        if (StringUtil.isNotEmpty(val)) {
            return Long.valueOf(StringUtil.safeTrim(val));
        }
        return null;
    }

    public static Float toFloat(Object value) throws NumberFormatException {
        String val = value != null ? String.valueOf(value) : null;
        if (StringUtil.isNotEmpty(val)) {
            return Float.valueOf(StringUtil.safeTrim(val));
        }
        return null;
    }

    public static Double toDouble(Object value) throws NumberFormatException {
        String val = value != null ? String.valueOf(value) : null;
        if (StringUtil.isNotEmpty(val)) {
            return Double.valueOf(StringUtil.safeTrim(val));
        }
        return null;
    }

    public static BigDecimal toBigDecimal(Object value) {
        String val;
        String string = val = value != null ? String.valueOf(value) : null;
        if (StringUtil.isNotEmpty(val)) {
            return new BigDecimal(StringUtil.safeTrim(val));
        }
        return null;
    }

    public static String toDoubleNoE(double value, int nScal) {
        DecimalFormat numberForm = (DecimalFormat)NumberFormat.getNumberInstance(Locale.CHINA);
        numberForm.setGroupingUsed(false);
        numberForm.setMaximumFractionDigits(nScal);
        return numberForm.format(value);
    }

    public static Boolean toBoolean(String value) {
        if ("1".equals(value)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String[] split(String source, char splitChar) {
        String[] strArr = null;
        LinkedList<String> strList = new LinkedList<String>();
        if (source == null || source.isEmpty()) {
            strArr = new String[]{};
        } else {
            char[] charArr = source.toCharArray();
            int start = 0;
            int end = 0;
            while (end < source.length()) {
                char c = charArr[end];
                if (c == splitChar) {
                    if (start != end) {
                        String fragment = source.substring(start, end);
                        strList.add(fragment);
                    }
                    start = end + 1;
                }
                ++end;
            }
            if (start < source.length()) {
                strList.add(source.substring(start));
            }
            strArr = new String[strList.size()];
            strList.toArray(strArr);
        }
        return strArr;
    }

    public static String[] split(String source, String splitStr) {
        String[] strArr = null;
        if (source == null || source.isEmpty()) {
            strArr = new String[]{};
        } else if (splitStr.length() == 1) {
            strArr = StringUtil.split(source, splitStr.charAt(0));
        } else {
            int strLen = source.length();
            int splitStrLen = splitStr.length();
            LinkedList<String> strList = new LinkedList<String>();
            int start = 0;
            int end = 0;
            while (start < strLen) {
                String fregment;
                end = source.indexOf(splitStr, start);
                if (end == -1) {
                    fregment = source.substring(start);
                    strList.add(fregment);
                    break;
                }
                if (start != end) {
                    fregment = source.substring(start, end);
                    strList.add(fregment);
                }
                start = end + splitStrLen;
            }
            strArr = new String[strList.size()];
            strList.toArray(strArr);
        }
        return strArr;
    }

    public static String string2Unicode(String str) {
        String ret = "";
        if (str != null && !"".equals(str)) {
            char[] chararr = str.toCharArray();
            StringBuffer sb = new StringBuffer();
            char[] cArray = chararr;
            int n = chararr.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                String s = String.valueOf(Integer.toHexString(c)) + ",";
                sb.append(s);
                ++n2;
            }
            ret = sb.toString();
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static String stringFilter(String str) {
        String regEx = "[*|{}://[//]<>/?]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static String convertString(String gbkStr) {
        String utf8 = "";
        try {
            utf8 = new String(StringUtil.gbk2utf8(gbkStr), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"converString error", (Throwable)e);
        }
        return utf8;
    }

    private static byte[] gbk2utf8(String gbkStr) {
        char[] c = gbkStr.toCharArray();
        byte[] fullByte = new byte[3 * c.length];
        int i = 0;
        while (i < c.length) {
            char m = c[i];
            String word = Integer.toBinaryString(m);
            StringBuffer sb = new StringBuffer();
            int len = 16 - word.length();
            int j = 0;
            while (j < len) {
                sb.append("0");
                ++j;
            }
            sb.append(word);
            sb.insert(0, "1110");
            sb.insert(8, "10");
            sb.insert(16, "10");
            String s1 = sb.substring(0, 8);
            String s2 = sb.substring(8, 16);
            String s3 = sb.substring(16);
            byte b0 = Integer.valueOf(s1, 2).byteValue();
            byte b1 = Integer.valueOf(s2, 2).byteValue();
            byte b2 = Integer.valueOf(s3, 2).byteValue();
            byte[] bf = new byte[3];
            bf[0] = b0;
            fullByte[i * 3] = bf[0];
            bf[1] = b1;
            fullByte[i * 3 + 1] = bf[1];
            bf[2] = b2;
            fullByte[i * 3 + 2] = bf[2];
            ++i;
        }
        return fullByte;
    }

    public static String getHexString(byte[] b) {
        StringBuilder resultSb = new StringBuilder();
        int i = 0;
        while (i < b.length) {
            resultSb.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return resultSb.toString();
    }

    public static byte[] getByteFromHexString(String str) {
        byte[] result = null;
        try {
            if (StringUtil.isNotEmpty(str) && str.length() > 0 && str.length() % 2 == 0) {
                result = new byte[str.length() / 2];
                String temp = str;
                int i = 0;
                i = 0;
                while (temp.length() > 2) {
                    result[i] = (byte)Integer.parseInt(temp.substring(0, 2), 16);
                    temp = temp.substring(2);
                    ++i;
                }
                if (temp.length() == 2) {
                    result[i] = (byte)Integer.parseInt(temp, 16);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"\u5c0616\u8fdb\u5236\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3abyte\u6570\u7ec4\u5f02\u5e38", (Throwable)ex);
        }
        return result;
    }
}

