/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.protocol.filter;

import com.centit.cmip.sdk.common.exception.BizException;
import com.centit.cmip.sdk.common.utils.DateUtil;
import com.centit.cmip.sdk.common.utils.StringUtil;
import com.centit.cmip.sdk.common.utils.file.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RequestParser {
    private static Logger logger = Logger.getLogger(RequestParser.class);
    @Value(value="${upload.filedir}")
    private String uploadPath;
    private static HashMap<String, String> attachMap = new HashMap();

    public JSONObject getJsonFromRequest(ServletRequest request) throws BizException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String saveDirSuffix = "/resource/interface/" + DateUtil.current(DateUtil.DATE_FORMAT);
        String tempDir = String.valueOf(this.uploadPath) + saveDirSuffix;
        BufferedReader bufReader = null;
        String buStr = "";
        JSONObject buJson = null;
        ServletInputStream reqInput = null;
        BufferedInputStream bis = null;
        try {
            reqInput = request.getInputStream();
            bis = new BufferedInputStream((InputStream)reqInput);
            bis.mark(5);
            byte[] b = new byte[5];
            bis.read(b);
            bis.reset();
            if (!new String(b).startsWith("PK")) {
                bufReader = new BufferedReader(new InputStreamReader((InputStream)bis, "utf-8"));
                StringBuffer strBuffer = new StringBuffer();
                String str = "";
                while ((str = bufReader.readLine()) != null) {
                    strBuffer.append(str);
                }
                buStr = strBuffer.toString();
                if ("".equals(buStr.trim())) {
                    buStr = "{}";
                }
                buJson = JSONObject.fromObject((Object)buStr);
            } else {
                buStr = this.saveZip(bis, httpRequest, saveDirSuffix, tempDir);
                buJson = JSONObject.fromObject((Object)buStr);
                attachMap.put("localFileDir", tempDir);
                attachMap.put("serverUrlPrefix", String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort());
                attachMap.put("contextPath", httpRequest.getContextPath());
                buJson.getJSONObject("header").element("param1", attachMap);
            }
            JSONObject jSONObject = buJson;
            return jSONObject;
        }
        catch (Exception e) {
            logger.error((Object)"\u4ecerequest\u4e2d\u83b7\u53d6\u8bf7\u6c42\u7684\u5b57\u7b26\u4e32\u51fa\u9519", (Throwable)e);
            throw new BizException("BIZ_003", buStr, e);
        }
        finally {
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (reqInput != null) {
                    reqInput.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String saveZip(InputStream reqis, HttpServletRequest request, String saveDirSuffix, String tmpDir) {
        String fileNameLong = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + UUID.randomUUID().toString() + ".zip";
        File savefile = null;
        FileInputStream fis = null;
        ZipInputStream zis = null;
        ZipFile zipFile = null;
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        String content = "";
        StringBuffer originalStr = new StringBuffer();
        StringBuffer newStr = new StringBuffer();
        try {
            try {
                savefile = FileUtil.Io2File(fileNameLong, reqis);
                reqis.close();
                fis = new FileInputStream(savefile);
                zis = new ZipInputStream(fis);
                ZipEntry entry = null;
                zipFile = new ZipFile(savefile);
                while ((entry = zis.getNextEntry()) != null) {
                    String originalFileName = "";
                    originalFileName = entry.getName();
                    originalFileName = StringUtil.stringFilter(originalFileName);
                    is = zipFile.getInputStream(entry);
                    if ("data.json".equals(originalFileName)) {
                        int i = -1;
                        bos = new ByteArrayOutputStream();
                        while ((i = is.read()) != -1) {
                            bos.write(i);
                            bos.flush();
                        }
                        content = bos.toString("UTF-8");
                        bos.close();
                        is.close();
                        continue;
                    }
                    String extName = "";
                    if (originalFileName.lastIndexOf(".") != -1) {
                        extName = originalFileName.substring(originalFileName.lastIndexOf("."), originalFileName.length());
                    }
                    String newFileName = String.valueOf(new SimpleDateFormat("HHmmsssss").format(new Date(System.currentTimeMillis()))) + extName;
                    String tempPath = String.valueOf(this.uploadPath) + saveDirSuffix + File.separator + newFileName;
                    FileUtil.Io2File(tempPath, is);
                    originalStr.append(originalFileName).append("|");
                    newStr.append(saveDirSuffix).append("/").append(newFileName).append("|");
                }
                if (originalStr.toString().endsWith("|")) {
                    originalStr.deleteCharAt(originalStr.length() - 1);
                    newStr.deleteCharAt(newStr.length() - 1);
                }
                attachMap.put("fileName", originalStr.toString());
                attachMap.put("fileRelativeAddr", newStr.toString());
            }
            catch (Exception e) {
                logger.error((Object)"\u4e0a\u4f20\u8bf7\u6c42\u83b7\u53d6\u538b\u7f29\u6d41\u5f02\u5e38", (Throwable)e);
                try {
                    if (zis != null) {
                        zis.close();
                        zis = null;
                    }
                    if (reqis != null) {
                        reqis.close();
                        reqis = null;
                    }
                    if (bos != null) {
                        bos.close();
                        bos = null;
                    }
                    if (is != null) {
                        is.close();
                        is = null;
                    }
                    if (fis != null) {
                        fis.close();
                        fis = null;
                    }
                    if (zipFile != null) {
                        zipFile.close();
                        zipFile = null;
                    }
                }
                catch (IOException e2) {
                    logger.error((Object)"\u4e0a\u4f20\u8bf7\u6c42\u83b7\u53d6\u538b\u7f29\u6d41,\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e2);
                }
                savefile = null;
                new File(fileNameLong).delete();
                logger.info((Object)"\u4e0a\u4f20\u5904\u7406\u7ed3\u675f");
            }
        }
        finally {
            try {
                if (zis != null) {
                    zis.close();
                    zis = null;
                }
                if (reqis != null) {
                    reqis.close();
                    reqis = null;
                }
                if (bos != null) {
                    bos.close();
                    bos = null;
                }
                if (is != null) {
                    is.close();
                    is = null;
                }
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
                if (zipFile != null) {
                    zipFile.close();
                    zipFile = null;
                }
            }
            catch (IOException e) {
                logger.error((Object)"\u4e0a\u4f20\u8bf7\u6c42\u83b7\u53d6\u538b\u7f29\u6d41,\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
            savefile = null;
            new File(fileNameLong).delete();
            logger.info((Object)"\u4e0a\u4f20\u5904\u7406\u7ed3\u675f");
        }
        return content;
    }
}

