/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.app.logger.service.impl;

import com.centit.cmip.app.common.dao.DefaultDao;
import com.centit.cmip.app.logger.entity.LoggerFileEntity;
import com.centit.cmip.app.logger.service.ILoggerFileService;
import com.centit.cmip.sdk.common.entity.ReqHeader;
import com.centit.cmip.sdk.common.entity.ReqTransEntity;
import com.centit.cmip.sdk.common.entity.RespTransEntity;
import com.centit.cmip.sdk.common.utils.DateUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LoggerFileServiceImpl
implements ILoggerFileService {
    @Resource
    private DefaultDao defaultDao;
    @Value(value="${upload.filedir}")
    private String uploadDir;

    public void opLog(LoggerFileEntity entity) {
        entity.setLog_time(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        String fileName = String.valueOf(entity.getLog_level()) + "_" + DateUtil.current("yyyy-MM-dd") + ".log";
        String storePath = "/logs/" + entity.getLog_type() + "/" + fileName;
        String filePath = String.valueOf(this.uploadDir) + storePath;
        String content = entity.toStringFile();
        String filedo = this.fileLinesWrite(filePath, content);
        if ("create".equals(filedo)) {
            HashMap<String, String> asset_map = new HashMap<String, String>();
            asset_map.put("src", entity.getLog_type());
            asset_map.put("name", fileName);
            asset_map.put("storePath", storePath);
            asset_map.put("fileType", "logs/" + entity.getLog_level());
            this.defaultDao.insert("insertLogAssetEntity", asset_map);
        }
    }

    public LoggerFileEntity initLog(ReqTransEntity reqEntity, RespTransEntity respEntity, String opType, String logType, String logInfo, String logLevel, boolean retflag) {
        ReqHeader header = reqEntity.getHeader();
        String bizType = "";
        String methodName = "";
        String reqInfo = "";
        String retInfo = "";
        if (reqEntity.getBody() != null) {
            bizType = String.valueOf(reqEntity.getBody().getBizCode()) + "/" + reqEntity.getBody().getBizType();
            methodName = reqEntity.getBody().getMethodName();
            reqInfo = JSONObject.fromObject((Object)reqEntity).toString();
        }
        if (respEntity != null && respEntity.getBody() != null) {
            retInfo = JSONObject.fromObject((Object)respEntity).toString();
        }
        return this.initLog(header, logType, logInfo, logLevel, opType, bizType, methodName, reqInfo, retInfo, "", "", retflag);
    }

    public LoggerFileEntity initLog(ReqHeader header, String logType, String logInfo, String logLevel, String opType, String bizType, String methodName, String reqInfo, String retInfo, String serverMethod, String servicePath, boolean retflag) {
        LoggerFileEntity logEntity = new LoggerFileEntity();
        logEntity.setUsercode(header.getUserId());
        logEntity.setDeptcode(header.getUserDept());
        logEntity.setIdentcode(header.getDeviceId());
        logEntity.setOsversion(header.getOsVersion());
        logEntity.setAppid(header.getAppCode());
        logEntity.setVersionid(header.getAppVersion());
        logEntity.setDevicetype(header.getDeviceType());
        logEntity.setLog_ip(header.getIp());
        logEntity.setLog_type(logType);
        logEntity.setLog_info(logInfo);
        logEntity.setLog_level(logLevel);
        logEntity.setOpType(opType);
        logEntity.setModule(bizType);
        logEntity.setOperfun(methodName);
        logEntity.setReq_info(reqInfo.getBytes());
        logEntity.setRet_info(retInfo.getBytes());
        logEntity.setServer_method(serverMethod);
        logEntity.setServer_path(servicePath);
        if (retflag) {
            this.opLog(logEntity);
        }
        return logEntity;
    }

    private String fileLinesWrite(String filePath, String content) {
        String filedo = "write";
        OutputStreamWriter fw = null;
        try {
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
                fw = new FileWriter(file);
                filedo = "create";
            } else {
                fw = new FileWriter(file, true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintWriter pw = new PrintWriter(fw);
        pw.println(content);
        pw.flush();
        try {
            fw.flush();
            pw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filedo;
    }
}

