/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.common.utils.file;

import com.centit.cmip.sdk.common.exception.OtherException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class ResourcePath {
    private static Logger logger = Logger.getLogger(ResourcePath.class);
    private static ResourcePath resourcePath = new ResourcePath();
    private static Map<String, String> paths = new HashMap<String, String>();

    public static ResourcePath getInstance() throws OtherException {
        if (paths == null || paths.size() < 1) {
            ResourceBundle rb = ResourceBundle.getBundle("com/centit/cmip/sdk/props/config", Locale.CHINESE);
            ResourcePath.loadConfig(rb);
        }
        return resourcePath;
    }

    private static void loadConfig(ResourceBundle rb) throws OtherException {
        try {
            Enumeration<String> enu = rb.getKeys();
            while (enu.hasMoreElements()) {
                String ele = enu.nextElement();
                paths.put(ele, new String(rb.getString(ele).getBytes("ISO-8859-1"), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new OtherException("OTHER_RESOURCE_001", null, e);
        }
    }

    public String get(String key) {
        return paths.get(key);
    }
}

