/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.sdk.common.utils.file;

import com.centit.cmip.sdk.common.utils.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.unzip.UnzipUtil;
import org.apache.log4j.Logger;

public class Zip4JUtil {
    private static Logger logger = Logger.getLogger(Zip4JUtil.class);
    private static final String CHARSETNAME = "UTF-8";
    private static final int BUFF_SIZE = 4096;

    public static File[] unzip(String zip, String dest, String passwd) throws ZipException {
        File zipFile = new File(zip);
        return Zip4JUtil.unzip(zipFile, dest, passwd, CHARSETNAME);
    }

    public static File[] unzip(String zip, String passwd) throws ZipException {
        File zipFile = new File(zip);
        File parentDir = zipFile.getParentFile();
        return Zip4JUtil.unzip(zipFile, parentDir.getAbsolutePath(), passwd, CHARSETNAME);
    }

    public static File[] unzip(File zipFile, String dest, String passwd, String charsetName) throws ZipException {
        ZipFile zFile = new ZipFile(zipFile);
        if (charsetName == null || "".equals(charsetName)) {
            zFile.setFileNameCharset(CHARSETNAME);
        } else {
            zFile.setFileNameCharset(charsetName);
        }
        if (!zFile.isValidZipFile()) {
            logger.error((Object)"\u538b\u7f29\u6587\u4ef6\u4e0d\u5408\u6cd5,\u53ef\u80fd\u88ab\u635f\u574f.");
            throw new ZipException("\u538b\u7f29\u6587\u4ef6\u4e0d\u5408\u6cd5,\u53ef\u80fd\u88ab\u635f\u574f.");
        }
        File destDir = new File(dest);
        if (destDir.isDirectory() && !destDir.exists()) {
            destDir.mkdirs();
        }
        if (zFile.isEncrypted()) {
            zFile.setPassword(passwd.toCharArray());
        }
        zFile.extractAll(dest);
        List headerList = zFile.getFileHeaders();
        ArrayList<File> extractedFileList = new ArrayList<File>();
        for (FileHeader fileHeader : headerList) {
            if (fileHeader.isDirectory()) continue;
            extractedFileList.add(new File(destDir, fileHeader.getFileName()));
        }
        File[] extractedFiles = new File[extractedFileList.size()];
        extractedFileList.toArray(extractedFiles);
        return extractedFiles;
    }

    public static String zip(String src) {
        return Zip4JUtil.zip(src, null);
    }

    public static String zip(String src, String passwd) {
        return Zip4JUtil.zip(src, null, passwd);
    }

    public static String zip(String src, String dest, String passwd) {
        return Zip4JUtil.zip(src, dest, true, passwd, CHARSETNAME);
    }

    public static String zip(String src, String dest, boolean isCreateDir, String passwd, String charsetName) {
        File srcFile = new File(src);
        String retdest = Zip4JUtil.buildDestinationZipFilePath(srcFile, dest);
        File destFile = new File(retdest);
        if (destFile.exists()) {
            destFile.delete();
        }
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        parameters.setIncludeRootFolder(false);
        if (!StringUtil.isEmpty(passwd)) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            parameters.setPassword(passwd.toCharArray());
        }
        try {
            ZipFile zipFile = new ZipFile(retdest);
            if (charsetName == null || "".equals(charsetName)) {
                zipFile.setFileNameCharset(CHARSETNAME);
            } else {
                zipFile.setFileNameCharset(charsetName);
            }
            if (srcFile.isDirectory()) {
                if (!isCreateDir) {
                    File[] subFiles = srcFile.listFiles();
                    ArrayList temp = new ArrayList();
                    Collections.addAll(temp, subFiles);
                    zipFile.addFiles(temp, parameters);
                    return retdest;
                }
                zipFile.addFolder(srcFile, parameters);
            } else {
                zipFile.addFile(srcFile, parameters);
            }
            logger.info((Object)("\u6587\u4ef6\u6587\u4ef6\u52a0\u538b\u6210\u529f\uff0c\u52a0\u538b\u7684\u6e90\u8def\u5f84\uff1a" + src + " \u76ee\u6807\u8def\u5f84\uff1a" + retdest));
            return retdest;
        }
        catch (ZipException e) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("src").append(src).append(',');
            stringBuffer.append("dest").append(retdest).append(',');
            stringBuffer.append("isCreateDir").append(isCreateDir);
            return null;
        }
    }

    private static String buildDestinationZipFilePath(File srcFile, String destParam) {
        String retpath = destParam;
        if (StringUtil.isEmpty(destParam)) {
            if (srcFile.isDirectory()) {
                retpath = String.valueOf(srcFile.getParent()) + File.separator + srcFile.getName() + ".zip";
            } else {
                String fileName = srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
                retpath = String.valueOf(srcFile.getParent()) + File.separator + fileName + ".zip";
            }
        } else {
            Zip4JUtil.createDestDirectoryIfNecessary(destParam);
            if (destParam.endsWith(File.separator)) {
                String fileName = "";
                fileName = srcFile.isDirectory() ? srcFile.getName() : srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
                retpath = String.valueOf(retpath) + fileName + ".zip";
            }
        }
        return retpath;
    }

    private static void createDestDirectoryIfNecessary(String destParam) {
        File destDir = null;
        destDir = destParam.endsWith(File.separator) ? new File(destParam) : new File(destParam.substring(0, destParam.lastIndexOf(File.separator)));
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractSelectFiles(String zipFilePath, String destPath, String passwd, String fileName) {
        is = null;
        os = null;
        try {
            block10: {
                zipFile = new ZipFile(zipFilePath);
                if (zipFile.isEncrypted()) {
                    zipFile.setPassword(passwd);
                }
                if ((fileHeader = zipFile.getFileHeader(fileName)) == null) ** GOTO lbl20
                outFilePath = String.valueOf(destPath) + System.getProperty("file.separator") + fileHeader.getFileName();
                outFile = new File(outFilePath);
                if (fileHeader.isDirectory()) {
                    outFile.mkdirs();
                    return;
                }
                parentDir = outFile.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                break block10;
lbl20:
                // 1 sources

                Zip4JUtil.logger.info((Object)("\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728:" + fileName));
                return;
            }
            is = zipFile.getInputStream(fileHeader);
            os = new FileOutputStream(outFile);
            readLen = -1;
            buff = new byte[4096];
            if (true) ** GOTO lbl36
        }
        catch (Exception e) {
            Zip4JUtil.logger.error((Object)String.format("\u89e3\u538b\u538b\u7f29\u6587\u4ef6\u4e2d\u6307\u5b9a\u6587\u4ef6%s\u5f02\u5e38\uff1a%s.", new Object[]{e.getMessage(), e, fileName}));
            return;
        }
        finally {
            Zip4JUtil.closeFileHandlers(is, os);
        }
        do {
            os.write(buff, 0, readLen);
lbl36:
            // 2 sources

        } while ((readLen = is.read(buff)) != -1);
        Zip4JUtil.closeFileHandlers(is, os);
        UnzipUtil.applyFileAttributes((FileHeader)fileHeader, (File)outFile);
    }

    private static void closeFileHandlers(ZipInputStream is, OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38:%s.", e.getMessage()));
        }
    }
}

