/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.framework.dao;

import com.centit.cmip.exception.UnkownException;
import com.centit.cmip.framework.dao.BaseDAO;
import com.centit.cmip.framework.page.Page;
import com.centit.cmip.framework.page.PageRequest;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.dao.support.DaoSupport;
import org.springframework.util.Assert;

public abstract class AbstractDAO<E, PK extends Serializable>
extends DaoSupport
implements BaseDAO<E, PK> {
    @Resource
    private SqlSessionFactory sqlSessionFactory;
    private SqlSessionTemplate sqlSessionTemplate;

    protected void checkDaoConfig() {
        Assert.notNull((Object)this.sqlSessionFactory, (String)"sqlSessionFactory must be not null");
    }

    @Override
    public void saveOrUpdate(E entity) {
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory factory) {
        this.sqlSessionFactory = factory;
        this.sqlSessionTemplate = new SqlSessionTemplate(this.sqlSessionFactory);
    }

    public SqlSessionTemplate getSqlSessionTemplate() {
        if (this.sqlSessionTemplate == null) {
            this.sqlSessionTemplate = new SqlSessionTemplate(this.sqlSessionFactory);
        }
        return this.sqlSessionTemplate;
    }

    public void setSqlSessionTemplate(SqlSessionTemplate sessionTemplate) {
        this.sqlSessionTemplate = sessionTemplate;
    }

    @Override
    public Object getById(PK primaryKey) {
        Object object = null;
        try {
            object = this.getSqlSessionTemplate().selectOne(this.getFindByPrimaryKeyStatement(), primaryKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnkownException();
        }
        return object;
    }

    public Object selectOne(String statement, Object condition) {
        Object object = null;
        try {
            object = this.getSqlSessionTemplate().selectOne(String.valueOf(this.getIbatisMapperNamesapce()) + "." + statement, condition);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnkownException();
        }
        return object;
    }

    @Override
    public int deleteById(PK id) {
        int affectCount = 0;
        try {
            affectCount = this.getSqlSessionTemplate().delete(this.getDeleteStatement(), id);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnkownException();
        }
        return affectCount;
    }

    public int delete(String statement, Object condition) {
        int affectCount = 0;
        try {
            affectCount = this.getSqlSessionTemplate().delete(String.valueOf(this.getIbatisMapperNamesapce()) + "." + statement, condition);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnkownException();
        }
        return affectCount;
    }

    @Override
    public int save(E entity) {
        this.prepareObjectForSaveOrUpdate(entity);
        int affectCount = 0;
        try {
            affectCount = this.getSqlSessionTemplate().insert(this.getInsertStatement(), entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnkownException();
        }
        return affectCount;
    }

    public int save(String statement, E entity) {
        this.prepareObjectForSaveOrUpdate(entity);
        int affectCount = 0;
        try {
            affectCount = this.getSqlSessionTemplate().insert(String.valueOf(this.getIbatisMapperNamesapce()) + "." + statement, entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnkownException();
        }
        return affectCount;
    }

    @Override
    public int update(E entity) {
        this.prepareObjectForSaveOrUpdate(entity);
        int affectCount = 0;
        try {
            affectCount = this.getSqlSessionTemplate().update(this.getUpdateStatement(), entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnkownException();
        }
        return affectCount;
    }

    public Integer update(String statement, E entity) {
        this.prepareObjectForSaveOrUpdate(entity);
        Integer affectCount = 0;
        try {
            affectCount = this.getSqlSessionTemplate().update(String.valueOf(this.getIbatisMapperNamesapce()) + "." + statement, entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnkownException();
        }
        return affectCount;
    }

    protected void prepareObjectForSaveOrUpdate(E object) {
    }

    public String getIbatisMapperNamesapce() {
        return null;
    }

    private String getFindByPrimaryKeyStatement() {
        return String.valueOf(this.getIbatisMapperNamesapce()) + ".getById";
    }

    private String getInsertStatement() {
        return String.valueOf(this.getIbatisMapperNamesapce()) + ".insert";
    }

    private String getUpdateStatement() {
        return String.valueOf(this.getIbatisMapperNamesapce()) + ".update";
    }

    private String getDeleteStatement() {
        return String.valueOf(this.getIbatisMapperNamesapce()) + ".delete";
    }

    public String getCountStatementForPaging(String statementName) {
        return String.valueOf(this.getIbatisMapperNamesapce()) + "." + statementName + "_" + "count";
    }

    public Page pageQuery(String statementName, PageRequest pageRequest) {
        return AbstractDAO.pageQuery(this.getSqlSessionTemplate(), statementName, this.getCountStatementForPaging(statementName), pageRequest);
    }

    protected static Page pageQuery(SqlSessionTemplate sqlSessionTemplate, String statementName, String countStatementName, PageRequest pageRequest) {
        Page page = null;
        try {
            Number totalCount = (Number)sqlSessionTemplate.selectOne(countStatementName, pageRequest.getFilters());
            if (totalCount == null || totalCount.longValue() <= 0L) {
                return new Page(pageRequest, 0);
            }
            page = new Page(pageRequest, totalCount.intValue());
            RowBounds rb = new RowBounds(page.getFirstResult(), page.getPageSize());
            List list = sqlSessionTemplate.selectList(statementName, pageRequest.getFilters(), rb);
            page.setResult(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnkownException();
        }
        return page;
    }

    public List findList(String statementName, Object condition, int offset, int limit) {
        RowBounds rb = new RowBounds(offset, limit);
        List list = null;
        try {
            list = this.sqlSessionTemplate.selectList(String.valueOf(this.getIbatisMapperNamesapce()) + "." + statementName, condition, rb);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnkownException();
        }
        return list;
    }

    public List findAll(String statementName, Object condition) {
        List list = null;
        try {
            list = this.getSqlSessionTemplate().selectList(String.valueOf(this.getIbatisMapperNamesapce()) + "." + statementName, condition);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnkownException();
        }
        return list;
    }

    public Page findForPage(String statementName, Object condition, int offset, int limit) {
        Page page = null;
        try {
            Number totalCount = (Number)this.getSqlSessionTemplate().selectOne(this.getCountStatementForPaging(statementName), condition);
            if (totalCount == null || totalCount.longValue() <= 0L) {
                return new Page(0, 0, 0);
            }
            long pageNumber = 0L;
            if (limit != 0) {
                pageNumber = offset % limit == 0 ? (long)(offset / limit) : (long)(offset / limit + 1);
            }
            page = new Page(Long.valueOf(pageNumber).intValue(), limit, totalCount.intValue());
            RowBounds rb = new RowBounds(offset, limit);
            List list = this.getSqlSessionTemplate().selectList(statementName, condition, rb);
            page.setResult(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnkownException();
        }
        return page;
    }

    @Override
    public boolean isUnique(E entity, String uniquePropertyNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() {
    }
}

