/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.framework.page;

import com.centit.cmip.framework.page.PageRequest;
import com.centit.cmip.framework.page.PageUtils;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Page<T>
implements Serializable,
Iterable<T> {
    private static final long serialVersionUID = 1617649922003197011L;
    private List<T> result;
    private int pageSize;
    private int pageNumber;
    private int totalCount = 0;
    private int totalPage = 0;

    public Page(PageRequest p, int count) {
        this(p.getPageNumber(), p.getPageSize(), count);
    }

    public Page(int number, int size, int count) {
        this(number, size, count, new ArrayList(0));
    }

    public Page(int number, int size, int count, List<T> resultParam) {
        if (size <= 0) {
            throw new IllegalArgumentException("[pageSize] must great than zero");
        }
        this.pageSize = size;
        this.pageNumber = PageUtils.computePageNumber(number, size, count);
        this.totalCount = count;
        this.totalPage = count / size;
        if (count % size != 0) {
            ++this.totalPage;
        }
        if (this.totalPage <= 0) {
            this.totalPage = 1;
        }
        this.setResult(resultParam);
    }

    public void setResult(List<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("'result' must be not null");
        }
        this.result = elements;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public List<T> getResult() {
        return this.result;
    }

    public boolean isFirstPage() {
        return this.getThisPageNumber() == 1;
    }

    public boolean isLastPage() {
        return this.getThisPageNumber() >= this.getLastPageNumber();
    }

    public boolean isHasNextPage() {
        return this.getLastPageNumber() > this.getThisPageNumber();
    }

    public boolean isHasPreviousPage() {
        return this.getThisPageNumber() > 1;
    }

    public int getLastPageNumber() {
        return PageUtils.computeLastPageNumber(this.totalCount, this.pageSize);
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getThisPageFirstElementNumber() {
        return (this.getThisPageNumber() - 1) * this.getPageSize() + 1;
    }

    public int getThisPageLastElementNumber() {
        int fullPage = this.getThisPageFirstElementNumber() + this.getPageSize() - 1;
        int count = this.getTotalCount();
        if (count < fullPage) {
            return count;
        }
        return fullPage;
    }

    public int getNextPageNumber() {
        return this.getThisPageNumber() + 1;
    }

    public int getPreviousPageNumber() {
        return this.getThisPageNumber() - 1;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getThisPageNumber() {
        return this.pageNumber;
    }

    public List<Integer> getLinkPageNumbers() {
        int limit = 10;
        return PageUtils.generateLinkPageNumbers(this.getThisPageNumber(), this.getLastPageNumber(), 10);
    }

    public int getFirstResult() {
        return PageUtils.getFirstResult(this.pageNumber, this.pageSize);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.result == null) {
            return Collections.emptyList().iterator();
        }
        return this.result.iterator();
    }
}

