/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.framework.page;

import com.centit.cmip.framework.page.SortInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRequest<T>
implements Serializable {
    private static final long serialVersionUID = -5183965652108651634L;
    private T filters;
    private int pageNumber;
    private int pageSize;
    private String sortColumns;

    public PageRequest() {
        this(0, 0);
    }

    public PageRequest(T filtersParam) {
        this(0, 0, filtersParam);
    }

    public PageRequest(int number, int size) {
        this(number, size, (Object)null);
    }

    public PageRequest(int number, int size, T filtersParam) {
        this(number, size, filtersParam, null);
    }

    public PageRequest(int number, int size, String columns) {
        this(number, size, null, columns);
    }

    public PageRequest(int number, int size, T filtersParam, String columns) {
        this.pageNumber = number;
        this.pageSize = size;
        this.setFilters(filtersParam);
        this.setSortColumns(columns);
    }

    public T getFilters() {
        return this.filters;
    }

    public void setFilters(T filtersParam) {
        this.filters = filtersParam;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int number) {
        this.pageNumber = number;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int size) {
        this.pageSize = size;
    }

    public String getSortColumns() {
        return this.sortColumns;
    }

    public void setSortColumns(String columns) {
        int length = 50;
        this.checkSortColumnsSqlInjection(columns);
        if (columns != null && columns.length() > 50) {
            throw new IllegalArgumentException("sortColumns.length() <= 50 must be true");
        }
        this.sortColumns = columns;
    }

    public List<SortInfo> getSortInfos() {
        return Collections.unmodifiableList(SortInfo.parseSortColumns(this.sortColumns));
    }

    private void checkSortColumnsSqlInjection(String columns) {
        if (null == columns) {
            return;
        }
        if (columns.indexOf("'") >= 0 || columns.indexOf("\\") >= 0) {
            throw new IllegalArgumentException("sortColumns:" + columns + " has SQL Injection risk");
        }
    }
}

