/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.framework.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortInfo
implements Serializable {
    private static final long serialVersionUID = 6959974032209696722L;
    private String columnName;
    private String sortOrder;

    public SortInfo() {
    }

    public SortInfo(String name, String order) {
        this.columnName = name;
        this.sortOrder = order;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String column) {
        this.columnName = column;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String order) {
        this.sortOrder = order;
    }

    public static List<SortInfo> parseSortColumns(String sortColumns) {
        if (sortColumns == null) {
            return new ArrayList<SortInfo>(0);
        }
        ArrayList<SortInfo> results = new ArrayList<SortInfo>();
        String[] sortSegments = sortColumns.trim().split(",");
        for (int i = 0; i < sortSegments.length; ++i) {
            String sortSegment = sortSegments[i];
            String[] array = sortSegment.split("\\s+");
            SortInfo sortInfo = new SortInfo();
            sortInfo.setColumnName(array[0]);
            if (array.length == 2) {
                sortInfo.setSortOrder(array[1]);
            } else {
                sortInfo.setSortOrder(null);
            }
            results.add(sortInfo);
        }
        return results;
    }

    public String toString() {
        if (this.sortOrder == null) {
            return this.columnName;
        }
        return this.columnName + " " + this.sortOrder;
    }
}

