/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.framework.page;

import java.util.ArrayList;
import java.util.List;

public class PageUtils {
    private PageUtils() {
    }

    public static int getFirstResult(int pageNumber, int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("[pageSize] must great than zero");
        }
        return (pageNumber - 1) * pageSize;
    }

    public static List<Integer> generateLinkPageNumbers(int currentPageNumber, int lastPageNumber, int count) {
        int endPageNumber;
        int avg = count / 2;
        int startPageNumber = currentPageNumber - avg;
        if (startPageNumber <= 0) {
            startPageNumber = 1;
        }
        if ((endPageNumber = startPageNumber + count - 1) > lastPageNumber) {
            endPageNumber = lastPageNumber;
        }
        if (endPageNumber - startPageNumber < count && (startPageNumber = endPageNumber - count) <= 0) {
            startPageNumber = 1;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = startPageNumber;
        while (i <= endPageNumber) {
            result.add(i);
            ++i;
        }
        return result;
    }

    public static int computeLastPageNumber(int totalElements, int pageSize) {
        int result = 1;
        result = totalElements % pageSize == 0 ? totalElements / pageSize : totalElements / pageSize + 1;
        return result;
    }

    public static int computePageNumber(int pageNumber, int pageSize, int totalElements) {
        if (pageNumber <= 1) {
            return 1;
        }
        if (Integer.MAX_VALUE == pageNumber || pageNumber > PageUtils.computeLastPageNumber(totalElements, pageSize)) {
            return PageUtils.computeLastPageNumber(totalElements, pageSize);
        }
        return pageNumber;
    }
}

