/*
 * Decompiled with CFR 0.152.
 */
package com.centit.cmip.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static String DATE_YYYYMMDD = "yyyyMMdd";
    public static String DATE_FORMAT = "yyyy-MM-dd";
    public static String DATE_FORMAT1 = "dd/MM/yyyy";
    public static String DATE_FORMAT2 = "yyyy\u5e74MM\u6708dd\u65e5";
    public static String DATE_FORMAT3 = "MM\u6708dd\u65e5";
    public static String TIME_FORMAT = "HH:mm:ss";
    public static String TIMESTAMP_FORMAT1 = "yyyy-MM-dd HH:mm:ss";
    public static String TIMESTAMP_FORMAT2 = "yyyy-MM-dd HH:mm";
    public static String TIMESTAMP_FORMAT3 = "yyyy-MM-dd HHmm";
    public static String TIMESTAMP_FORMAT_SSS = "yyyyMMddHHmmssSSS";

    public static String format(Date d, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(d);
    }

    public static String format(Timestamp t, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(t);
    }

    public static String current(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date());
    }

    public static String current() {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(new Date());
    }

    public static Date parse(String date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Timestamp parseSql(String timestamp) {
        return Timestamp.valueOf(timestamp);
    }

    public static String parseStrToStr(String date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            Date d = sdf.parse(date);
            return sdf.format(d);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parse(String date, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String parse(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String parse(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(date);
    }

    public static String currentYear() {
        return DateUtils.current(DATE_FORMAT).substring(0, 4);
    }

    public static String currentMonth() {
        return DateUtils.current(DATE_FORMAT).substring(5, 7);
    }

    public static String currentDay() {
        return DateUtils.current(DATE_FORMAT).substring(8);
    }

    public static int getDay(String date) {
        return Integer.parseInt(DateUtils.parse(DateUtils.parse(date), DATE_FORMAT).substring(8, 10));
    }

    public static String getCurrentOneDay() {
        return String.valueOf(DateUtils.currentYear()) + "-" + DateUtils.currentMonth() + "-01 00:00";
    }

    public static String getCurrentOneDate() {
        return String.valueOf(DateUtils.currentYear()) + "-" + DateUtils.currentMonth() + "-01";
    }

    public static String getMonthFirstDate(String year, String month) {
        return String.valueOf(year) + "-" + month + "-01";
    }

    public static String getCurrentLastDate() {
        Calendar c = Calendar.getInstance();
        c.set(Integer.valueOf(DateUtils.currentYear()), Integer.valueOf(DateUtils.currentMonth()), 1);
        c.add(2, -1);
        int lastMonthDay = c.getActualMaximum(5);
        return String.valueOf(DateUtils.currentYear()) + "-" + DateUtils.currentMonth() + "-" + lastMonthDay;
    }

    public static String getMonthLastDate(String year, String month) {
        Calendar c = Calendar.getInstance();
        c.set(Integer.valueOf(year), Integer.valueOf(month), 1);
        c.add(2, -1);
        int lastMonthDay = c.getActualMaximum(5);
        return String.valueOf(year) + "-" + month + "-" + lastMonthDay;
    }

    public static String getCurrentSpaceDate(int amount) {
        Calendar c = Calendar.getInstance();
        c.add(5, amount);
        return DateUtils.parse(c.getTime(), DATE_FORMAT);
    }

    public static String cutString(String obj, int cutNum) {
        String str = obj;
        if (obj.length() > cutNum) {
            str = obj.substring(0, cutNum);
        }
        return str;
    }

    public static int getDaysDiff(Date date1, Date date2) {
        int result = 0;
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(date1);
        calendar2.setTime(date2);
        int flag = calendar1.compareTo(calendar2);
        if (flag < 0) {
            calendar1.setTime(date2);
            calendar2.setTime(date1);
        }
        result = calendar1.get(6) - calendar2.get(6);
        while (calendar1.get(1) > calendar2.get(1)) {
            result += calendar2.getActualMaximum(6);
            calendar2.add(1, 1);
        }
        result = flag < 0 ? -result : result;
        return result;
    }
}

