/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.client.example;

import com.dingtalk.open.client.api.model.corp.CorpUserDetail;
import com.dingtalk.open.client.api.service.corp.CorpConnectionService;
import com.dingtalk.open.client.api.service.corp.CorpUserService;
import com.dingtalk.open.client.common.ServiceException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StringUtils;

public class SpringExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("classpath:applicationContext.xml");
        CorpConnectionService corpConnectionService = (CorpConnectionService)context.getBean("corpConnectionService");
        final CorpUserService corpUserService = (CorpUserService)context.getBean("corpUserService");
        try {
            final String corpToken = corpConnectionService.getCorpToken("ding4ed6d279061db5e7", "eWaBBOLvCRBuLmOTfPUc4VWoEGSTTxOqt4Gn601qITEoV6NHbcWJSb0yrQlI5wrV");
            System.out.println("corpToken=" + corpToken);
            if (StringUtils.isEmpty((Object)corpToken)) {
                return;
            }
            int nThreads = 200;
            int total = 1000;
            ExecutorService pool = Executors.newFixedThreadPool(nThreads);
            final CountDownLatch latch = new CountDownLatch(total);
            long start = System.currentTimeMillis();
            for (int i = 0; i < total; ++i) {
                pool.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            CorpUserDetail corpUserDetail = corpUserService.getCorpUser(corpToken, "13051498174");
                        }
                        catch (ServiceException e) {
                            e.printStackTrace();
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            latch.await();
            long totalTime = System.currentTimeMillis() - start;
            System.out.println("\u603b\u8ba1\u6267\u884c\u8bf7\u6c42" + total + "\u6b21,\u6d88\u8017\u65f6\u95f4 " + totalTime / 1000L + " \u79d2,tpm=" + (long)(total * 1000 * 60) / totalTime);
            pool.shutdown();
        }
        catch (ServiceException e) {
            System.out.println(e.getCode() + "|" + e.getMessage());
        }
        finally {
            ((ConfigurableApplicationContext)context).close();
        }
    }
}

