/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.core.dao.ExtendedQueryPool;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.po.OsInfo;
import com.centit.framework.ip.po.UserAccessToken;
import com.centit.framework.ip.service.impl.AbstractIntegrationEnvironment;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.DbcpConnectPools;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcIntegrationEnvironment
extends AbstractIntegrationEnvironment {
    private Logger logger = LoggerFactory.getLogger(JdbcIntegrationEnvironment.class);
    private DataSourceDescription dataSource;

    private Connection getConnection() throws SQLException {
        return DbcpConnectPools.getDbcpConnect((DataSourceDescription)this.dataSource);
    }

    public void setDataBaseConnectInfo(String connectURI, String username, String pswd) {
        this.dataSource = new DataSourceDescription(connectURI, username, pswd);
        try {
            ExtendedQueryPool.loadResourceExtendedSqlMap((DBType)this.dataSource.getDbType());
        }
        catch (DocumentException e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    public void close(Connection conn) {
        DbcpConnectPools.closeConnect((Connection)conn);
    }

    private <T> List<T> jsonArrayToObjectList(JSONArray jsonArray, Class<T> clazz) {
        if (jsonArray == null) {
            return new ArrayList();
        }
        return jsonArray.toJavaList(clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<OsInfo> reloadOsInfos() {
        try (Connection conn = this.getConnection();){
            JSONArray userJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_OS"));
            List<OsInfo> list = this.jsonArrayToObjectList(userJSONArray, OsInfo.class);
            return list;
        }
        catch (IOException | SQLException e) {
            this.logger.error(e.getLocalizedMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DatabaseInfo> reloadDatabaseInfos() {
        try (Connection conn = this.getConnection();){
            JSONArray optInfoJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_DATABASE"));
            List<DatabaseInfo> list = this.jsonArrayToObjectList(optInfoJSONArray, DatabaseInfo.class);
            return list;
        }
        catch (IOException | SQLException e) {
            this.logger.error(e.getLocalizedMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<UserAccessToken> reloadAccessTokens() {
        try (Connection conn = this.getConnection();){
            JSONArray optMethodsJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)ExtendedQueryPool.getExtendedSql((String)"LIST_ALL_ACCESSTOKEN"));
            List<UserAccessToken> list = this.jsonArrayToObjectList(optMethodsJSONArray, UserAccessToken.class);
            return list;
        }
        catch (IOException | SQLException e) {
            this.logger.error(e.getLocalizedMessage());
            return null;
        }
    }
}

