/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.dao.ExtendedQueryPool;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.po.OsInfo;
import com.centit.framework.ip.po.UserAccessToken;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.DbcpConnectPools;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcIntegrationEnvironment
implements IntegrationEnvironment {
    private Logger logger = LoggerFactory.getLogger(JdbcIntegrationEnvironment.class);
    private List<OsInfo> osInfos;
    private List<DatabaseInfo> databaseInfos;
    private List<UserAccessToken> accessTokens;
    private DataSourceDescription dataSource;

    private Connection getConnection() throws SQLException {
        return DbcpConnectPools.getDbcpConnect((DataSourceDescription)this.dataSource);
    }

    public void setDataBaseConnectInfo(String connectURI, String username, String pswd) {
        this.dataSource = new DataSourceDescription(connectURI, username, pswd);
    }

    public void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.logger.error("\u5173\u95ed\u8fde\u63a5\u51fa\u9519", (Throwable)e);
            }
        }
    }

    @Override
    public boolean reloadIPEnvironmen() {
        try {
            this.reloadIPEnvironmenFromJdbc();
            return true;
        }
        catch (IOException | SQLException | DocumentException e) {
            this.osInfos = new ArrayList<OsInfo>();
            this.databaseInfos = new ArrayList<DatabaseInfo>();
            this.accessTokens = new ArrayList<UserAccessToken>();
            e.printStackTrace();
            this.logger.error("\u52a0\u8f7d\u96c6\u6210\u6570\u636e\u51fa\u9519", e);
            return false;
        }
    }

    private <T> List<T> jsonArrayToObjectList(JSONArray jsonArray, Class<T> clazz) {
        if (jsonArray == null) {
            return new ArrayList();
        }
        return jsonArray.toJavaList(clazz);
    }

    public boolean reloadIPEnvironmenFromJdbc() throws IOException, DocumentException, SQLException {
        ExtendedQueryPool.loadResourceExtendedSqlMap((DBType)this.dataSource.getDbType());
        try (Connection conn = this.getConnection();){
            JSONArray userJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_OS"));
            this.osInfos = this.jsonArrayToObjectList(userJSONArray, OsInfo.class);
            JSONArray optInfoJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_DATABASE"));
            this.databaseInfos = this.jsonArrayToObjectList(optInfoJSONArray, DatabaseInfo.class);
            JSONArray optMethodsJSONArray = DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)CodeRepositoryUtil.getExtendedSql((String)"LIST_ALL_ACCESSTOKEN"));
            this.accessTokens = this.jsonArrayToObjectList(optMethodsJSONArray, UserAccessToken.class);
        }
        return true;
    }

    @Override
    public OsInfo getOsInfo(String osId) {
        if (this.osInfos == null) {
            return null;
        }
        for (OsInfo oi : this.osInfos) {
            if (!StringUtils.equals((CharSequence)oi.getOsId(), (CharSequence)osId)) continue;
            return oi;
        }
        return null;
    }

    @Override
    public DatabaseInfo getDatabaseInfo(String databaseCode) {
        if (this.databaseInfos == null) {
            return null;
        }
        for (DatabaseInfo di : this.databaseInfos) {
            if (!StringUtils.equals((CharSequence)di.getDatabaseCode(), (CharSequence)databaseCode)) continue;
            return di;
        }
        return null;
    }

    @Override
    public List<OsInfo> listOsInfos() {
        return this.osInfos;
    }

    @Override
    public List<DatabaseInfo> listDatabaseInfo() {
        return this.databaseInfos;
    }

    @Override
    public String checkAccessToken(String tokenId, String accessKey) {
        if (this.accessTokens == null) {
            return null;
        }
        for (UserAccessToken at : this.accessTokens) {
            if (!StringUtils.equals((CharSequence)at.getTokenId(), (CharSequence)tokenId)) continue;
            if (StringUtils.equals((CharSequence)at.getIsValid(), (CharSequence)"T") && StringUtils.equals((CharSequence)at.getSecretAccessKey(), (CharSequence)accessKey)) {
                return at.getUserCode();
            }
            return null;
        }
        return null;
    }
}

