/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.SysParametersUtils;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.po.OsInfo;
import com.centit.framework.ip.po.UserAccessToken;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class JsonIntegrationEnvironment
implements IntegrationEnvironment {
    private Logger logger = LoggerFactory.getLogger(JsonIntegrationEnvironment.class);
    private List<OsInfo> osInfos;
    private List<DatabaseInfo> databaseInfos;
    private List<UserAccessToken> accessTokens;

    private static String loadJsonStringFormConfigFile(String fileName) throws IOException {
        String jsonFile = SysParametersUtils.getConfigHome() + fileName;
        if (FileSystemOpt.existFile((String)jsonFile)) {
            return FileIOOpt.readStringFromFile((String)jsonFile, (String)"UTF-8");
        }
        return FileIOOpt.readStringFromInputStream((InputStream)new ClassPathResource(fileName).getInputStream(), (String)"UTF-8");
    }

    @Override
    public boolean reloadIPEnvironmen() {
        try {
            String jsonStr = JsonIntegrationEnvironment.loadJsonStringFormConfigFile("/ip_environmen.json");
            JSONObject json = JSON.parseObject((String)jsonStr);
            this.osInfos = JSON.parseArray((String)json.getString("osInfos"), OsInfo.class);
            this.databaseInfos = JSON.parseArray((String)json.getString("databaseInfos"), DatabaseInfo.class);
            this.accessTokens = JSON.parseArray((String)json.getString("userAccessTokens"), UserAccessToken.class);
        }
        catch (IOException e) {
            this.osInfos = new ArrayList<OsInfo>();
            this.databaseInfos = new ArrayList<DatabaseInfo>();
            e.printStackTrace();
            this.logger.error("\u52a0\u8f7d\u96c6\u6210\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
        return true;
    }

    @Override
    public OsInfo getOsInfo(String osId) {
        if (this.osInfos == null) {
            return null;
        }
        for (OsInfo oi : this.osInfos) {
            if (!StringUtils.equals((CharSequence)oi.getOsId(), (CharSequence)osId)) continue;
            return oi;
        }
        return null;
    }

    @Override
    public DatabaseInfo getDatabaseInfo(String databaseCode) {
        if (this.databaseInfos == null) {
            return null;
        }
        for (DatabaseInfo di : this.databaseInfos) {
            if (!StringUtils.equals((CharSequence)di.getDatabaseCode(), (CharSequence)databaseCode)) continue;
            return di;
        }
        return null;
    }

    @Override
    public List<OsInfo> listOsInfos() {
        return this.osInfos;
    }

    @Override
    public List<DatabaseInfo> listDatabaseInfo() {
        return this.databaseInfos;
    }

    @Override
    public String checkAccessToken(String tokenId, String accessKey) {
        if (this.accessTokens == null) {
            return null;
        }
        for (UserAccessToken at : this.accessTokens) {
            if (!StringUtils.equals((CharSequence)at.getTokenId(), (CharSequence)tokenId)) continue;
            if (StringUtils.equals((CharSequence)at.getIsValid(), (CharSequence)"T") && StringUtils.equals((CharSequence)at.getSecretAccessKey(), (CharSequence)accessKey)) {
                return at.getUserCode();
            }
            return null;
        }
        return null;
    }
}

