/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.service.impl;

import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.po.OsInfo;
import com.centit.framework.ip.po.UserAccessToken;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.support.common.CachedObject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractIntegrationEnvironment
implements IntegrationEnvironment {
    private CachedObject<List<OsInfo>> osInfoCache = new CachedObject(this::reloadOsInfos, 15);
    private CachedObject<List<DatabaseInfo>> databaseInfoCache = new CachedObject(this::reloadDatabaseInfos, 15);
    private CachedObject<List<UserAccessToken>> accessTokenCache = new CachedObject(this::reloadAccessTokens, 15);

    public abstract List<OsInfo> reloadOsInfos();

    public abstract List<DatabaseInfo> reloadDatabaseInfos();

    public abstract List<UserAccessToken> reloadAccessTokens();

    @Override
    public boolean reloadIPEnvironmen() {
        this.osInfoCache.evictCahce();
        this.databaseInfoCache.evictCahce();
        this.accessTokenCache.evictCahce();
        return true;
    }

    @Override
    public OsInfo getOsInfo(String osId) {
        List osInfos = (List)this.osInfoCache.getCachedTarget();
        if (osInfos == null) {
            return null;
        }
        for (OsInfo oi : osInfos) {
            if (!StringUtils.equals((CharSequence)oi.getOsId(), (CharSequence)osId)) continue;
            return oi;
        }
        return null;
    }

    @Override
    public DatabaseInfo getDatabaseInfo(String databaseCode) {
        List databaseInfos = (List)this.databaseInfoCache.getCachedTarget();
        if (databaseInfos == null) {
            return null;
        }
        for (DatabaseInfo di : databaseInfos) {
            if (!StringUtils.equals((CharSequence)di.getDatabaseCode(), (CharSequence)databaseCode)) continue;
            return di;
        }
        return null;
    }

    @Override
    public List<OsInfo> listOsInfos() {
        return (List)this.osInfoCache.getCachedTarget();
    }

    @Override
    public List<DatabaseInfo> listDatabaseInfo() {
        return (List)this.databaseInfoCache.getCachedTarget();
    }

    @Override
    public String checkAccessToken(String tokenId, String accessKey) {
        List accessTokens = (List)this.accessTokenCache.getCachedTarget();
        if (accessTokens == null) {
            return null;
        }
        for (UserAccessToken at : accessTokens) {
            if (!StringUtils.equals((CharSequence)at.getTokenId(), (CharSequence)tokenId)) continue;
            if (StringUtils.equals((CharSequence)at.getIsValid(), (CharSequence)"T") && StringUtils.equals((CharSequence)at.getSecretAccessKey(), (CharSequence)accessKey)) {
                return at.getUserCode();
            }
            return null;
        }
        return null;
    }
}

