/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.po.OsInfo;
import com.centit.framework.ip.po.UserAccessToken;
import com.centit.framework.ip.service.impl.AbstractIntegrationEnvironment;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class JsonIntegrationEnvironment
extends AbstractIntegrationEnvironment {
    private Logger logger = LoggerFactory.getLogger(JsonIntegrationEnvironment.class);
    protected String appHome;

    public void setAppHome(String appHome) {
        this.appHome = appHome;
    }

    private String loadJsonStringFormConfigFile(String fileName) throws IOException {
        String jsonFile = this.appHome + "/config" + fileName;
        if (FileSystemOpt.existFile((String)jsonFile)) {
            return FileIOOpt.readStringFromFile((String)jsonFile, (String)"UTF-8");
        }
        return FileIOOpt.readStringFromInputStream((InputStream)new ClassPathResource(fileName).getInputStream(), (String)"UTF-8");
    }

    @Override
    public List<OsInfo> reloadOsInfos() {
        try {
            String jsonStr = this.loadJsonStringFormConfigFile("/ip_environmen.json");
            JSONObject json = JSON.parseObject((String)jsonStr);
            return JSON.parseArray((String)json.getString("osInfos"), OsInfo.class);
        }
        catch (IOException e) {
            this.logger.error("\u52a0\u8f7d\u96c6\u6210\u6570\u636e\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<DatabaseInfo> reloadDatabaseInfos() {
        try {
            String jsonStr = this.loadJsonStringFormConfigFile("/ip_environmen.json");
            JSONObject json = JSON.parseObject((String)jsonStr);
            return JSON.parseArray((String)json.getString("databaseInfos"), DatabaseInfo.class);
        }
        catch (IOException e) {
            this.logger.error("\u52a0\u8f7d\u96c6\u6210\u6570\u636e\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<UserAccessToken> reloadAccessTokens() {
        try {
            String jsonStr = this.loadJsonStringFormConfigFile("/ip_environmen.json");
            JSONObject json = JSON.parseObject((String)jsonStr);
            return JSON.parseArray((String)json.getString("userAccessTokens"), UserAccessToken.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error("\u52a0\u8f7d\u96c6\u6210\u6570\u636e\u51fa\u9519", (Throwable)e);
            return null;
        }
    }
}

