/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.service.impl;

import com.centit.framework.ip.po.OsInfo;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.CachedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class OsInfoMap
implements Map<String, String> {
    private CachedObject<List<OsInfo>> osInfoCache;

    public OsInfoMap(CachedObject<List<OsInfo>> osInfoCache) {
        this.osInfoCache = osInfoCache;
    }

    @Override
    public int size() {
        List osInfos = (List)this.osInfoCache.getCachedTarget();
        if (osInfos == null) {
            return 0;
        }
        return osInfos.size();
    }

    @Override
    public boolean isEmpty() {
        List osInfos = (List)this.osInfoCache.getCachedTarget();
        if (osInfos == null) {
            return true;
        }
        return osInfos.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        List osInfos = (List)this.osInfoCache.getCachedTarget();
        if (osInfos == null) {
            return false;
        }
        for (OsInfo oi : osInfos) {
            if (!StringUtils.equals((CharSequence)oi.getOsId(), (CharSequence)StringBaseOpt.castObjectToString((Object)key))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        List osInfos = (List)this.osInfoCache.getCachedTarget();
        if (osInfos == null) {
            return false;
        }
        for (OsInfo oi : osInfos) {
            if (!StringUtils.equals((CharSequence)oi.getOsName(), (CharSequence)StringBaseOpt.castObjectToString((Object)value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String get(Object key) {
        List osInfos = (List)this.osInfoCache.getCachedTarget();
        if (osInfos == null) {
            return null;
        }
        for (OsInfo oi : osInfos) {
            if (!StringUtils.equals((CharSequence)oi.getOsId(), (CharSequence)StringBaseOpt.castObjectToString((Object)key))) continue;
            return oi.getOsName();
        }
        return null;
    }

    @Override
    public String put(String key, String value) {
        return null;
    }

    @Override
    public String remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<String> keySet() {
        List osInfos = (List)this.osInfoCache.getCachedTarget();
        if (osInfos == null) {
            return null;
        }
        HashSet<String> keys = new HashSet<String>();
        for (OsInfo oi : osInfos) {
            keys.add(oi.getOsId());
        }
        return keys;
    }

    @Override
    public Collection<String> values() {
        List osInfos = (List)this.osInfoCache.getCachedTarget();
        if (osInfos == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (OsInfo oi : osInfos) {
            values.add(oi.getOsName());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        List osInfos = (List)this.osInfoCache.getCachedTarget();
        if (osInfos == null) {
            return null;
        }
        HashSet<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>();
        for (OsInfo oi : osInfos) {
            entries.add((Map.Entry<String, String>)new ImmutablePair((Object)oi.getOsId(), (Object)oi.getOsName()));
        }
        return entries;
    }
}

