/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.app.config;

import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.centit.framework.ip.app.config.FrameworkProperties;
import com.centit.framework.ip.app.service.impl.IPClientIntegrationEnvironment;
import com.centit.framework.ip.app.service.impl.IPClientPlatformEnvironment;
import com.centit.framework.ip.app.service.impl.IntegrationEnvironmentProxy;
import com.centit.framework.ip.app.service.impl.PlatformEnvironmentProxy;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.framework.ip.service.impl.JsonIntegrationEnvironment;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.security.model.CentitUserDetailsService;
import com.centit.framework.security.model.StandardPasswordEncoderImpl;
import com.centit.framework.staticsystem.service.impl.JsonPlatformEnvironment;
import com.centit.framework.staticsystem.service.impl.UserDetailsServiceImpl;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.MediaType;

@EnableConfigurationProperties(value={FrameworkProperties.class})
@Configuration(value="environmentConfiguation")
public class FrameworkBeanConfiguation {
    @Autowired
    private FrameworkProperties frameworkProperties;

    @Bean
    public FastJsonHttpMessageConverter fastJsonHttpMessageConverter() {
        FastJsonHttpMessageConverter fastJsonHttpMessageConverter = new FastJsonHttpMessageConverter();
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        supportedMediaTypes.add(MediaType.APPLICATION_JSON_UTF8);
        fastJsonHttpMessageConverter.setSupportedMediaTypes(supportedMediaTypes);
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setFeatures(new Feature[]{Feature.AllowArbitraryCommas, Feature.AllowUnQuotedFieldNames, Feature.DisableCircularReferenceDetect});
        fastJsonConfig.setDateFormat("yyyy-MM-dd HH:mm:ss");
        fastJsonHttpMessageConverter.setFastJsonConfig(fastJsonConfig);
        return fastJsonHttpMessageConverter;
    }

    @Bean(value={"passwordEncoder"})
    public CentitPasswordEncoder passwordEncoder() {
        return new StandardPasswordEncoderImpl();
    }

    @Bean
    @Lazy(value=false)
    public PlatformEnvironment platformEnvironment(@Autowired CentitPasswordEncoder passwordEncoder) {
        boolean ipEnable = this.frameworkProperties.getIp().isEnable();
        JsonPlatformEnvironment jsonPlatformEnvironment = new JsonPlatformEnvironment();
        jsonPlatformEnvironment.setAppHome(this.frameworkProperties.getApp().getHome());
        jsonPlatformEnvironment.setPasswordEncoder(passwordEncoder);
        if (!ipEnable) {
            return jsonPlatformEnvironment;
        }
        IPClientPlatformEnvironment ipPlatformEnvironment = new IPClientPlatformEnvironment();
        ipPlatformEnvironment.setTopOptId(this.frameworkProperties.getIp().getTopoptid());
        ipPlatformEnvironment.createPlatAppSession(this.frameworkProperties.getIp().getHome(), this.frameworkProperties.getIp().isAuthEnable(), this.frameworkProperties.getIp().getUsercode(), this.frameworkProperties.getIp().getPassword());
        ArrayList<Object> evrnMangers = new ArrayList<Object>();
        evrnMangers.add(ipPlatformEnvironment);
        evrnMangers.add(jsonPlatformEnvironment);
        PlatformEnvironmentProxy platformEnvironment = new PlatformEnvironmentProxy();
        platformEnvironment.setEvrnMangers(evrnMangers);
        return platformEnvironment;
    }

    @Bean
    @Lazy(value=false)
    public IntegrationEnvironment integrationEnvironment() {
        boolean ipEnable = this.frameworkProperties.getIp().isEnable();
        JsonIntegrationEnvironment staticIntegrationEnvironment = new JsonIntegrationEnvironment();
        staticIntegrationEnvironment.setAppHome(this.frameworkProperties.getApp().getHome());
        staticIntegrationEnvironment.reloadIPEnvironmen();
        if (!ipEnable) {
            return staticIntegrationEnvironment;
        }
        IPClientIntegrationEnvironment ipIntegrationEnvironment = new IPClientIntegrationEnvironment();
        ipIntegrationEnvironment.createPlatAppSession(this.frameworkProperties.getIp().getHome(), this.frameworkProperties.getIp().isAuthEnable(), this.frameworkProperties.getIp().getUsercode(), this.frameworkProperties.getIp().getPassword());
        ArrayList<Object> evrnMangers = new ArrayList<Object>();
        evrnMangers.add(ipIntegrationEnvironment);
        evrnMangers.add(staticIntegrationEnvironment);
        IntegrationEnvironmentProxy integrationEnvironment = new IntegrationEnvironmentProxy();
        integrationEnvironment.setEvrnMangers(evrnMangers);
        return integrationEnvironment;
    }

    @Bean
    public CentitUserDetailsService centitUserDetailsService(@Autowired PlatformEnvironment platformEnvironment) {
        UserDetailsServiceImpl userDetailsService = new UserDetailsServiceImpl();
        userDetailsService.setPlatformEnvironment(platformEnvironment);
        return userDetailsService;
    }
}

