/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.app.config;

import com.centit.framework.ip.app.service.impl.IPClientIntegrationEnvironment;
import com.centit.framework.ip.app.service.impl.IPClientPlatformEnvironment;
import com.centit.framework.ip.app.service.impl.IntegrationEnvironmentProxy;
import com.centit.framework.ip.app.service.impl.PlatformEnvironmentProxy;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.framework.ip.service.impl.JdbcIntegrationEnvironment;
import com.centit.framework.ip.service.impl.JsonIntegrationEnvironment;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.security.model.CentitUserDetailsService;
import com.centit.framework.staticsystem.service.impl.JdbcPlatformEnvironment;
import com.centit.framework.staticsystem.service.impl.JsonPlatformEnvironment;
import com.centit.framework.staticsystem.service.impl.UserDetailsServiceImpl;
import com.centit.support.algorithm.BooleanBaseOpt;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;

@PropertySource(value={"classpath:system.properties"})
public class IPOrStaticAppSystemBeanConfig
implements EnvironmentAware {
    private Environment env;

    @Autowired
    public void setEnvironment(Environment environment) {
        if (environment != null) {
            this.env = environment;
        }
    }

    @Bean
    public AutowiredAnnotationBeanPostProcessor autowiredAnnotationBeanPostProcessor() {
        return new AutowiredAnnotationBeanPostProcessor();
    }

    @Bean
    @Lazy(value=false)
    public PlatformEnvironment platformEnvironment(@Autowired CentitPasswordEncoder passwordEncoder) {
        Boolean ipEnable = (Boolean)this.env.getProperty("centit.ip.system-enable", Boolean.class);
        if (ipEnable == null) {
            ipEnable = (Boolean)this.env.getProperty("centit.ip.enable", Boolean.class);
        }
        JsonPlatformEnvironment staticPlatformEnvironment = null;
        Boolean jdbcEnable = (Boolean)this.env.getProperty("centit.jdbcplatform.enable", Boolean.class);
        if (jdbcEnable != null && jdbcEnable.booleanValue()) {
            JdbcPlatformEnvironment jdbcPlatformEnvironment = new JdbcPlatformEnvironment();
            jdbcPlatformEnvironment.setDataBaseConnectInfo(this.env.getProperty("centit.jdbcplatform.url"), this.env.getProperty("centit.jdbcplatform.username"), this.env.getProperty("centit.jdbcplatform.password"));
            jdbcPlatformEnvironment.setPasswordEncoder(passwordEncoder);
            if (ipEnable == null || !ipEnable.booleanValue()) {
                return jdbcPlatformEnvironment;
            }
            staticPlatformEnvironment = jdbcPlatformEnvironment;
        } else {
            JsonPlatformEnvironment jsonPlatformEnvironment = new JsonPlatformEnvironment();
            jsonPlatformEnvironment.setAppHome(this.env.getProperty("app.home"));
            jsonPlatformEnvironment.setPasswordEncoder(passwordEncoder);
            if (ipEnable == null || !ipEnable.booleanValue()) {
                return jsonPlatformEnvironment;
            }
            staticPlatformEnvironment = jsonPlatformEnvironment;
        }
        IPClientPlatformEnvironment ipPlatformEnvironment = new IPClientPlatformEnvironment();
        ipPlatformEnvironment.setTopOptId(this.env.getProperty("centit.ip.topoptid"));
        ipPlatformEnvironment.createPlatAppSession(this.env.getProperty("centit.ip.home"), BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("centit.ip.auth.enable"), (Boolean)false).booleanValue(), this.env.getProperty("centit.ip.auth.usercode"), this.env.getProperty("centit.ip.auth.password"));
        ArrayList<Object> evrnMangers = new ArrayList<Object>();
        evrnMangers.add(ipPlatformEnvironment);
        evrnMangers.add(staticPlatformEnvironment);
        PlatformEnvironmentProxy platformEnvironment = new PlatformEnvironmentProxy();
        platformEnvironment.setEvrnMangers(evrnMangers);
        return platformEnvironment;
    }

    @Bean
    @Lazy(value=false)
    public IntegrationEnvironment integrationEnvironment() {
        Boolean ipEnable = (Boolean)this.env.getProperty("centit.ip.enable", Boolean.class);
        JsonIntegrationEnvironment staticIntegrationEnvironment = null;
        Boolean jdbcEnable = (Boolean)this.env.getProperty("centit.jdbcplatform.ip.enable", Boolean.class);
        if (jdbcEnable == null) {
            jdbcEnable = (Boolean)this.env.getProperty("centit.jdbcplatform.enable", Boolean.class);
        }
        if (jdbcEnable != null && jdbcEnable.booleanValue()) {
            JdbcIntegrationEnvironment jdbcIntegrationEnvironment = new JdbcIntegrationEnvironment();
            jdbcIntegrationEnvironment.setDataBaseConnectInfo(this.env.getProperty("centit.jdbcplatform.url"), this.env.getProperty("centit.jdbcplatform.username"), this.env.getProperty("centit.jdbcplatform.password"));
            jdbcIntegrationEnvironment.reloadIPEnvironmen();
            if (ipEnable == null || !ipEnable.booleanValue()) {
                return jdbcIntegrationEnvironment;
            }
            staticIntegrationEnvironment = jdbcIntegrationEnvironment;
        } else {
            JsonIntegrationEnvironment jsonIntegrationEnvironment = new JsonIntegrationEnvironment();
            jsonIntegrationEnvironment.setAppHome(this.env.getProperty("app.home"));
            jsonIntegrationEnvironment.reloadIPEnvironmen();
            if (ipEnable == null || !ipEnable.booleanValue()) {
                return jsonIntegrationEnvironment;
            }
            staticIntegrationEnvironment = jsonIntegrationEnvironment;
        }
        IPClientIntegrationEnvironment ipIntegrationEnvironment = new IPClientIntegrationEnvironment();
        ipIntegrationEnvironment.createPlatAppSession(this.env.getProperty("centit.ip.home"), BooleanBaseOpt.castObjectToBoolean((Object)this.env.getProperty("centit.ip.auth.enable"), (Boolean)false).booleanValue(), this.env.getProperty("centit.ip.auth.usercode"), this.env.getProperty("centit.ip.auth.password"));
        ArrayList<Object> evrnMangers = new ArrayList<Object>();
        evrnMangers.add(ipIntegrationEnvironment);
        evrnMangers.add(staticIntegrationEnvironment);
        IntegrationEnvironmentProxy integrationEnvironment = new IntegrationEnvironmentProxy();
        integrationEnvironment.setEvrnMangers(evrnMangers);
        return integrationEnvironment;
    }

    @Bean
    public CentitUserDetailsService centitUserDetailsService(@Autowired PlatformEnvironment platformEnvironment) {
        UserDetailsServiceImpl userDetailsService = new UserDetailsServiceImpl();
        userDetailsService.setPlatformEnvironment(platformEnvironment);
        return userDetailsService;
    }

    @Bean
    public HttpSessionCsrfTokenRepository csrfTokenRepository() {
        return new HttpSessionCsrfTokenRepository();
    }
}

