/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.app.config;

import com.centit.framework.ip.app.service.impl.IPClientIntegrationEnvironment;
import com.centit.framework.ip.app.service.impl.IPClientPlatformEnvironment;
import com.centit.framework.ip.app.service.impl.IntegrationEnvironmentProxy;
import com.centit.framework.ip.app.service.impl.PlatformEnvironmentProxy;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.framework.ip.service.impl.JdbcIntegrationEnvironment;
import com.centit.framework.ip.service.impl.JsonIntegrationEnvironment;
import com.centit.framework.listener.InitialWebRuntimeEnvironment;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.security.model.CentitPasswordEncoderImpl;
import com.centit.framework.security.model.CentitSessionRegistry;
import com.centit.framework.security.model.MemorySessionRegistryImpl;
import com.centit.framework.staticsystem.service.impl.JdbcPlatformEnvironment;
import com.centit.framework.staticsystem.service.impl.JsonPlatformEnvironment;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;

@PropertySource(value={"classpath:system.properties"})
@EnableAspectJAutoProxy(proxyTargetClass=true)
@Lazy
public class IPAppSystemBeanConfig
implements EnvironmentAware {
    private Environment env;

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    @Bean
    public PersistenceExceptionTranslationPostProcessor persistenceExceptionTranslationPostProcessor() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    @Bean
    public AutowiredAnnotationBeanPostProcessor autowiredAnnotationBeanPostProcessor() {
        return new AutowiredAnnotationBeanPostProcessor();
    }

    @Bean(initMethod="initialEnvironment")
    @Lazy(value=false)
    public InitialWebRuntimeEnvironment initialEnvironment() {
        return new InitialWebRuntimeEnvironment();
    }

    @Bean
    public CentitPasswordEncoderImpl passwordEncoder() {
        return new CentitPasswordEncoderImpl();
    }

    @Bean
    @Lazy(value=false)
    public PlatformEnvironment platformEnvironment(CentitPasswordEncoder passwordEncoder) {
        Boolean ipEnable = (Boolean)this.env.getProperty("centit.ip.enable", Boolean.class);
        JsonPlatformEnvironment staticPlatformEnvironment = null;
        Boolean jdbcEnable = (Boolean)this.env.getProperty("centit.jdbcplatform.enable", Boolean.class);
        if (jdbcEnable != null && jdbcEnable.booleanValue()) {
            JdbcPlatformEnvironment jdbcPlatformEnvironment = new JdbcPlatformEnvironment();
            jdbcPlatformEnvironment.setDataBaseConnectInfo(this.env.getProperty("centit.jdbcplatform.url"), this.env.getProperty("centit.jdbcplatform.username"), this.env.getProperty("centit.jdbcplatform.password"));
            jdbcPlatformEnvironment.setPasswordEncoder(passwordEncoder);
            jdbcPlatformEnvironment.init();
            if (ipEnable == null || !ipEnable.booleanValue()) {
                return jdbcPlatformEnvironment;
            }
            staticPlatformEnvironment = jdbcPlatformEnvironment;
        } else {
            JsonPlatformEnvironment jsonPlatformEnvironment = new JsonPlatformEnvironment();
            jsonPlatformEnvironment.setPasswordEncoder(passwordEncoder);
            jsonPlatformEnvironment.init();
            if (ipEnable == null || !ipEnable.booleanValue()) {
                return jsonPlatformEnvironment;
            }
            staticPlatformEnvironment = jsonPlatformEnvironment;
        }
        IPClientPlatformEnvironment ipPlatformEnvironment = new IPClientPlatformEnvironment();
        ipPlatformEnvironment.setTopOptId(this.env.getProperty("centit.ip.topoptid"));
        ipPlatformEnvironment.setPlatServerUrl(this.env.getProperty("centit.ip.home"));
        ipPlatformEnvironment.init();
        ArrayList<PlatformEnvironment> evrnMangers = new ArrayList<PlatformEnvironment>();
        evrnMangers.add(ipPlatformEnvironment);
        evrnMangers.add((PlatformEnvironment)staticPlatformEnvironment);
        PlatformEnvironmentProxy platformEnvironment = new PlatformEnvironmentProxy();
        platformEnvironment.setEvrnMangers(evrnMangers);
        return platformEnvironment;
    }

    @Bean
    @Lazy(value=false)
    public IntegrationEnvironment integrationEnvironment() {
        Boolean ipEnable = (Boolean)this.env.getProperty("centit.ip.enable", Boolean.class);
        JsonIntegrationEnvironment staticIntegrationEnvironment = null;
        Boolean jdbcEnable = (Boolean)this.env.getProperty("centit.jdbcplatform.enable", Boolean.class);
        if (jdbcEnable != null && jdbcEnable.booleanValue()) {
            JdbcIntegrationEnvironment jdbcIntegrationEnvironment = new JdbcIntegrationEnvironment();
            jdbcIntegrationEnvironment.setDataBaseConnectInfo(this.env.getProperty("centit.jdbcplatform.url"), this.env.getProperty("centit.jdbcplatform.username"), this.env.getProperty("centit.jdbcplatform.password"));
            jdbcIntegrationEnvironment.reloadIPEnvironmen();
            if (ipEnable == null || !ipEnable.booleanValue()) {
                return jdbcIntegrationEnvironment;
            }
            staticIntegrationEnvironment = jdbcIntegrationEnvironment;
        } else {
            JsonIntegrationEnvironment jsonIntegrationEnvironment = new JsonIntegrationEnvironment();
            jsonIntegrationEnvironment.reloadIPEnvironmen();
            if (ipEnable == null || !ipEnable.booleanValue()) {
                return jsonIntegrationEnvironment;
            }
            staticIntegrationEnvironment = jsonIntegrationEnvironment;
        }
        IPClientIntegrationEnvironment ipIntegrationEnvironment = new IPClientIntegrationEnvironment();
        ipIntegrationEnvironment.setPlatServerUrl(this.env.getProperty("centit.ip.home"));
        ArrayList<IntegrationEnvironment> evrnMangers = new ArrayList<IntegrationEnvironment>();
        evrnMangers.add(ipIntegrationEnvironment);
        evrnMangers.add((IntegrationEnvironment)staticIntegrationEnvironment);
        IntegrationEnvironmentProxy integrationEnvironment = new IntegrationEnvironmentProxy();
        integrationEnvironment.setEvrnMangers(evrnMangers);
        return integrationEnvironment;
    }

    @Bean
    public CentitSessionRegistry centitSessionRegistry() {
        return new MemorySessionRegistryImpl();
    }

    @Bean
    public HttpSessionCsrfTokenRepository csrfTokenRepository() {
        return new HttpSessionCsrfTokenRepository();
    }
}

