/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.centit.framework.appclient.AppSession;
import com.centit.framework.appclient.RestfulHttpRequest;
import com.centit.framework.common.ResponseJSON;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.IOptInfo;
import com.centit.framework.model.basedata.IOptMethod;
import com.centit.framework.model.basedata.IUnitRole;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.model.basedata.IUserSetting;
import com.centit.framework.security.model.CentitSecurityMetadata;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.security.model.OptTreeNode;
import com.centit.framework.staticsystem.po.DataCatalog;
import com.centit.framework.staticsystem.po.DataDictionary;
import com.centit.framework.staticsystem.po.OptInfo;
import com.centit.framework.staticsystem.po.OptMethod;
import com.centit.framework.staticsystem.po.RoleInfo;
import com.centit.framework.staticsystem.po.RolePower;
import com.centit.framework.staticsystem.po.UnitInfo;
import com.centit.framework.staticsystem.po.UserInfo;
import com.centit.framework.staticsystem.po.UserRole;
import com.centit.framework.staticsystem.po.UserSetting;
import com.centit.framework.staticsystem.po.UserUnit;
import com.centit.framework.staticsystem.security.StaticCentitUserDetails;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.network.HttpExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.access.SecurityConfig;

public class IPClientPlatformEnvironment
implements PlatformEnvironment {
    private Logger logger = LoggerFactory.getLogger(IPClientPlatformEnvironment.class);
    private String topOptId;
    private AppSession appSession;

    public void setTopOptId(String topOptId) {
        this.topOptId = topOptId;
    }

    public void setPlatServerUrl(String platServerUrl) {
        this.appSession = new AppSession(platServerUrl, false, null, null);
    }

    public void init() {
        if (this.appSession == null) {
            return;
        }
        this.reloadSecurityMetadata();
    }

    public UserSetting getUserSetting(String userCode, String paramCode) {
        ResponseJSON resJson = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/usersetting/" + userCode + "/" + paramCode));
        if (resJson == null) {
            return null;
        }
        return (UserSetting)resJson.getDataAsObject(UserSetting.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserSetting(IUserSetting userSetting) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.appSession.getHttpClient();
            HttpExecutor.jsonPost((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/usersetting"), (Object)userSetting);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                this.appSession.releaseHttpClient(httpClient);
            }
        }
    }

    public List<OptInfo> listUserMenuOptInfos(String userCode, boolean asAdmin) {
        return this.listUserMenuOptInfosUnderSuperOptId(userCode, this.topOptId, asAdmin);
    }

    public List<OptInfo> listUserMenuOptInfosUnderSuperOptId(String userCode, String superOptId, boolean asAdmin) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/usermenu/" + superOptId + "/" + userCode + "?asAdmin=" + asAdmin), OptInfo.class);
    }

    public List<RoleInfo> listUserRolesByUserCode(String userCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/userroleinfos/" + userCode), RoleInfo.class);
    }

    public List<UserInfo> listRoleUserByRoleCode(String roleCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/roleuserinfos/" + roleCode), UserInfo.class);
    }

    public List<UserRole> listUserRoles(String userCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/userroles/" + userCode), UserRole.class);
    }

    public List<UserRole> listRoleUsers(String roleCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/roleusers/" + roleCode), UserRole.class);
    }

    public List<? extends IUnitRole> listUnitRoles(String unitCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/unitroles/" + unitCode), IUnitRole.class);
    }

    public List<? extends IUnitRole> listRoleUnits(String roleCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/roleunits/" + roleCode), IUnitRole.class);
    }

    public UserInfo getUserInfoByUserCode(String userCode) {
        return (UserInfo)RestfulHttpRequest.getResponseObject((AppSession)this.appSession, (String)("/userinfo/" + userCode), UserInfo.class);
    }

    public UnitInfo getUnitInfoByUnitCode(String unitCode) {
        return (UnitInfo)RestfulHttpRequest.getResponseObject((AppSession)this.appSession, (String)("/unitinfo/" + unitCode), UnitInfo.class);
    }

    public UserInfo getUserInfoByLoginName(String loginName) {
        return (UserInfo)RestfulHttpRequest.getResponseObject((AppSession)this.appSession, (String)("/userinfobyloginname/" + loginName), UserInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeUserPassword(String userCode, String userPassword) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.appSession.getHttpClient();
            HashMap<String, String> userInfo = new HashMap<String, String>();
            userInfo.put("userCode", userCode);
            userInfo.put("password", userPassword);
            userInfo.put("newPassword", userPassword);
            HttpExecutor.jsonPost((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/changepassword/" + userCode), (String)JSON.toJSONString(userInfo), (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u83b7\u53d6httpClient\u51fa\u9519", (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                this.appSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkUserPassword(String userCode, String userPassword) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.appSession.getHttpClient();
            HashMap<String, String> userInfo = new HashMap<String, String>();
            userInfo.put("userCode", userCode);
            userInfo.put("password", userPassword);
            userInfo.put("newPassword", userPassword);
            String sret = HttpExecutor.jsonPost((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/checkpassword/" + userCode), (String)JSON.toJSONString(userInfo), (boolean)true);
            boolean bl = StringRegularOpt.isTrue((String)sret);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u83b7\u53d6httpClient\u51fa\u9519", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (httpClient != null) {
                this.appSession.releaseHttpClient(httpClient);
            }
        }
    }

    @Cacheable(value={"UserInfo"}, key="'userList'")
    public List<UserInfo> listAllUsers() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/allusers/" + this.topOptId), UserInfo.class);
    }

    @Cacheable(value={"UnitInfo"}, key="'unitList'")
    public List<UnitInfo> listAllUnits() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/allunits/" + this.topOptId), UnitInfo.class);
    }

    @Cacheable(value={"AllUserUnits"}, key="'allUserUnits'")
    public List<UserUnit> listAllUserUnits() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/alluserunits/" + this.topOptId), UserUnit.class);
    }

    @Cacheable(value={"UserUnits"}, key="#userCode")
    public List<UserUnit> listUserUnits(String userCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/userunits/" + this.topOptId + "/" + userCode), UserUnit.class);
    }

    @Cacheable(value={"UnitUsers"}, key="#unitCode")
    public List<UserUnit> listUnitUsers(String unitCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/unitusers/" + this.topOptId + "/" + unitCode), UserUnit.class);
    }

    @Cacheable(value={"UnitInfo"}, key="'unitCodeMap'")
    public Map<String, UnitInfo> getUnitRepo() {
        ResponseJSON resJson = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/unitrepo/" + this.topOptId));
        if (resJson == null) {
            return null;
        }
        return resJson.getDataAsMap(UnitInfo.class);
    }

    @Cacheable(value={"UserInfo"}, key="'userCodeMap'")
    public Map<String, UserInfo> getUserRepo() {
        ResponseJSON resJson = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/userrepo/" + this.topOptId));
        if (resJson == null) {
            return null;
        }
        return resJson.getDataAsMap(UserInfo.class);
    }

    @Cacheable(value={"UserInfo"}, key="'loginNameMap'")
    public Map<String, UserInfo> getLoginNameRepo() {
        ResponseJSON resJson = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/loginnamerepo/" + this.topOptId));
        if (resJson == null) {
            return null;
        }
        return resJson.getDataAsMap(UserInfo.class);
    }

    @Cacheable(value={"UnitInfo"}, key="'depNoMap'")
    public Map<String, UnitInfo> getDepNoRepo() {
        ResponseJSON resJson = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/depnorepo/" + this.topOptId));
        if (resJson == null) {
            return null;
        }
        return resJson.getDataAsMap(UnitInfo.class);
    }

    @Cacheable(value={"RoleInfo"}, key="'roleCodeMap'")
    public Map<String, RoleInfo> getRoleRepo() {
        ResponseJSON resJson = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/rolerepo/" + this.topOptId));
        if (resJson == null) {
            return null;
        }
        return resJson.getDataAsMap(RoleInfo.class);
    }

    @Cacheable(value={"OptInfo"}, key="'optIdMap'")
    public Map<String, OptInfo> getOptInfoRepo() {
        ResponseJSON resJson = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/optinforepo/" + this.topOptId));
        if (resJson == null) {
            return null;
        }
        return resJson.getDataAsMap(OptInfo.class);
    }

    @Cacheable(value={"OptInfo"}, key="'optCodeMap'")
    public Map<String, OptMethod> getOptMethodRepo() {
        ResponseJSON resJson = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/optmethodrepo/" + this.topOptId));
        if (resJson == null) {
            return null;
        }
        return resJson.getDataAsMap(OptMethod.class);
    }

    @Cacheable(value={"DataDictionary"}, key="'CatalogCode'")
    public List<DataCatalog> listAllDataCatalogs() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/catalogs/" + this.topOptId), DataCatalog.class);
    }

    @Cacheable(value={"DataDictionary"}, key="#catalogCode")
    public List<DataDictionary> listDataDictionaries(String catalogCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/dictionary/" + this.topOptId + "/" + catalogCode), DataDictionary.class);
    }

    public List<RolePower> listAllRolePower() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/allrolepowers/" + this.topOptId), RolePower.class);
    }

    public List<OptMethod> listAllOptMethod() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/alloptmethods/" + this.topOptId), OptMethod.class);
    }

    private CentitUserDetails loadUserDetails(String queryParam, String qtype) {
        ResponseJSON resJson = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/userdetails/" + this.topOptId + "/" + queryParam + "?qtype=" + qtype));
        if (resJson == null || resJson.getCode() != 0) {
            return null;
        }
        StaticCentitUserDetails userDetails = (StaticCentitUserDetails)resJson.getDataAsObject("userDetails", StaticCentitUserDetails.class);
        userDetails.getUserInfo().setUserUnits(resJson.getDataAsArray("userUnits", UserUnit.class));
        userDetails.setAuthoritiesByRoles(userDetails.getUserRoles());
        return userDetails;
    }

    public CentitUserDetails loadUserDetailsByLoginName(String loginName) {
        return this.loadUserDetails(loginName, "loginName");
    }

    public CentitUserDetails loadUserDetailsByUserCode(String userCode) {
        return this.loadUserDetails(userCode, "userCode");
    }

    public CentitUserDetails loadUserDetailsByRegEmail(String regEmail) {
        return this.loadUserDetails(regEmail, "regEmail");
    }

    public CentitUserDetails loadUserDetailsByRegCellPhone(String regCellPhone) {
        return this.loadUserDetails(regCellPhone, "regCellPhone");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserInfo(IUserInfo userInfo) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.appSession.getHttpClient();
            HttpExecutor.jsonPost((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/userinfo"), (Object)userInfo, (boolean)true);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                this.appSession.releaseHttpClient(httpClient);
            }
        }
    }

    @CacheEvict(value={"DataDictionary", "OptInfo", "RoleInfo", "UserInfo", "UnitInfo", "UnitUsers", "UserUnits", "AllUserUnits"}, allEntries=true)
    public boolean reloadDictionary() {
        return true;
    }

    public boolean reloadSecurityMetadata() {
        CentitSecurityMetadata.optMethodRoleMap.clear();
        List<RolePower> rplist = this.listAllRolePower();
        if (rplist == null || rplist.size() == 0) {
            return false;
        }
        for (RolePower rp : rplist) {
            ArrayList<SecurityConfig> roles = (ArrayList<SecurityConfig>)CentitSecurityMetadata.optMethodRoleMap.get(rp.getOptCode());
            if (roles == null) {
                roles = new ArrayList<SecurityConfig>();
            }
            roles.add(new SecurityConfig("R_" + StringUtils.trim((String)rp.getRoleCode())));
            CentitSecurityMetadata.optMethodRoleMap.put(rp.getOptCode(), roles);
        }
        CentitSecurityMetadata.sortOptMethodRoleMap();
        Map<String, OptInfo> optRepo = this.getOptInfoRepo();
        List<OptMethod> oulist = this.listAllOptMethod();
        CentitSecurityMetadata.optTreeNode.setChildList(null);
        CentitSecurityMetadata.optTreeNode.setOptCode(null);
        for (OptMethod ou : oulist) {
            OptInfo oi = optRepo.get(ou.getOptId());
            if (oi == null) continue;
            String optDefUrl = oi.getOptUrl() + ou.getOptUrl();
            List sOpt = CentitSecurityMetadata.parsePowerDefineUrl((String)optDefUrl, (String)ou.getOptReq());
            for (List surls : sOpt) {
                OptTreeNode opt = CentitSecurityMetadata.optTreeNode;
                for (String surl : surls) {
                    opt = opt.setChildPath(surl);
                }
                opt.setOptCode(ou.getOptCode());
            }
        }
        CentitSecurityMetadata.confirmLoginCasMustBeAuthed();
        return true;
    }

    public List<UserSetting> getAllSettings() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/allsettings/" + this.topOptId), UserSetting.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrUpdateMenu(List<? extends IOptInfo> optInfos, List<? extends IOptMethod> optMethods) {
        CloseableHttpClient httpClient = null;
        HashMap<String, List<Object>> param = new HashMap<String, List<Object>>(4);
        param.put("optInfos", optInfos);
        param.put("optMethods", optMethods);
        try {
            httpClient = this.appSession.getHttpClient();
            HttpExecutor.jsonPost((CloseableHttpClient)httpClient, (String)this.appSession.completeQueryUrl("/insertopt"), param);
        }
        catch (Exception exception) {
        }
        finally {
            if (httpClient != null) {
                this.appSession.releaseHttpClient(httpClient);
            }
        }
    }
}

