/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.app.service.impl;

import com.centit.framework.appclient.AppSession;
import com.centit.framework.appclient.RestfulHttpRequest;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.po.OsInfo;
import com.centit.framework.ip.po.UserAccessToken;
import com.centit.framework.ip.service.IntegrationEnvironment;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

public class IPClientIntegrationEnvironment
implements IntegrationEnvironment {
    private AppSession appSession;

    public CloseableHttpClient getHttpClient() throws Exception {
        return this.appSession.getHttpClient();
    }

    public void releaseHttpClient(CloseableHttpClient httpClient) {
        this.appSession.releaseHttpClient(httpClient);
    }

    public void setPlatServerUrl(String platServerUrl) {
        this.appSession = new AppSession(platServerUrl, false, null, null);
    }

    @CacheEvict(value={"IPEnvironmen"}, allEntries=true)
    public boolean reloadIPEnvironmen() {
        return true;
    }

    public OsInfo getOsInfo(String osId) {
        for (OsInfo oi : this.listOsInfos()) {
            if (!StringUtils.equals((CharSequence)oi.getOsId(), (CharSequence)osId)) continue;
            return oi;
        }
        return null;
    }

    public DatabaseInfo getDatabaseInfo(String databaseCode) {
        for (DatabaseInfo di : this.listDatabaseInfo()) {
            if (!StringUtils.equals((CharSequence)di.getDatabaseCode(), (CharSequence)databaseCode)) continue;
            return di;
        }
        return null;
    }

    @Cacheable(value={"IPEnvironment"}, key="'OsInfo'")
    public List<OsInfo> listOsInfos() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)"/ipenvironment/osinfo", OsInfo.class);
    }

    @Cacheable(value={"IPEnvironment"}, key="'DatabaseInfo'")
    public List<DatabaseInfo> listDatabaseInfo() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)"/ipenvironment/databaseinfo", DatabaseInfo.class);
    }

    public String checkAccessToken(String tokenId, String accessKey) {
        UserAccessToken at = (UserAccessToken)RestfulHttpRequest.getResponseObject((AppSession)this.appSession, (String)("/ipenvironment/userToken/" + tokenId), UserAccessToken.class);
        if (at == null) {
            return null;
        }
        if (StringUtils.equals((CharSequence)at.getTokenId(), (CharSequence)tokenId)) {
            if (StringUtils.equals((CharSequence)at.getIsValid(), (CharSequence)"T") && StringUtils.equals((CharSequence)at.getSecretAccessKey(), (CharSequence)accessKey)) {
                return at.getUserCode();
            }
            return null;
        }
        return null;
    }
}

