/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.app.controller;

import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.ip.service.IntegrationEnvironment;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/ipenvironment"})
public class IPEnvironmentController
extends BaseController {
    @Autowired
    protected IntegrationEnvironment integrationEnvironment;

    @RequestMapping(value={"/reload/ipenvironment"}, method={RequestMethod.GET})
    public void reloadIPEnvironment(HttpServletResponse response) {
        if (this.integrationEnvironment.reloadIPEnvironmen()) {
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"reloadIPEnvironmen failed\uff01", (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/reload/refreshall"}, method={RequestMethod.GET})
    public void environmentRefreshAll(HttpServletResponse response) {
        boolean reloadEv = this.integrationEnvironment.reloadIPEnvironmen();
        if (reloadEv) {
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"environmentRefreshAll failed\uff01", (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/osinfos"}, method={RequestMethod.GET})
    public ResponseMapData listOsInfos() {
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)this.integrationEnvironment.listOsInfos());
        return resData;
    }

    @RequestMapping(value={"/databaseinfos"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseMapData listDatabaseInfos() {
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)this.integrationEnvironment.listDatabaseInfo());
        return resData;
    }
}

