/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.ip.app.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.appclient.AppSession;
import com.centit.framework.appclient.HttpReceiveJSON;
import com.centit.framework.appclient.RestfulHttpRequest;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.IOptDataScope;
import com.centit.framework.model.basedata.IOptInfo;
import com.centit.framework.model.basedata.IOptMethod;
import com.centit.framework.model.basedata.IOsInfo;
import com.centit.framework.model.basedata.IRoleInfo;
import com.centit.framework.model.basedata.IUnitRole;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.model.basedata.IUserSetting;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.security.model.JsonCentitUserDetails;
import com.centit.framework.staticsystem.po.DataCatalog;
import com.centit.framework.staticsystem.po.DataDictionary;
import com.centit.framework.staticsystem.po.OptDataScope;
import com.centit.framework.staticsystem.po.OptInfo;
import com.centit.framework.staticsystem.po.OptMethod;
import com.centit.framework.staticsystem.po.OsInfo;
import com.centit.framework.staticsystem.po.RoleInfo;
import com.centit.framework.staticsystem.po.RolePower;
import com.centit.framework.staticsystem.po.UnitInfo;
import com.centit.framework.staticsystem.po.UserInfo;
import com.centit.framework.staticsystem.po.UserRole;
import com.centit.framework.staticsystem.po.UserSetting;
import com.centit.framework.staticsystem.po.UserUnit;
import com.centit.support.algorithm.BooleanBaseOpt;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPClientPlatformEnvironment
implements PlatformEnvironment {
    private Logger logger = LoggerFactory.getLogger(IPClientPlatformEnvironment.class);
    private String topOptId;
    private AppSession appSession;

    public void setTopOptId(String topOptId) {
        this.topOptId = topOptId;
    }

    public AppSession getPlatAppSession() {
        return this.appSession;
    }

    public void createPlatAppSession(String appServerUrl, boolean needAuthenticated, String userCode, String password) {
        this.appSession = new AppSession(appServerUrl, needAuthenticated, userCode, password);
    }

    public UserSetting getUserSetting(String userCode, String paramCode) {
        HttpReceiveJSON resJson = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/platform/usersetting/" + userCode + "/" + paramCode));
        if (resJson == null) {
            return null;
        }
        return (UserSetting)resJson.getDataAsObject(UserSetting.class);
    }

    public List<? extends IUserSetting> listUserSettings(String userCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/usersettings/" + userCode + "/" + this.topOptId), UserSetting.class);
    }

    public void saveUserSetting(IUserSetting userSetting) {
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/platform/usersetting", (Object)userSetting);
    }

    public List<OptInfo> listUserMenuOptInfos(String userCode, boolean asAdmin) {
        return this.listUserMenuOptInfosUnderSuperOptId(userCode, this.topOptId, asAdmin);
    }

    public List<OptInfo> listUserMenuOptInfosUnderSuperOptId(String userCode, String superOptId, boolean asAdmin) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/usermenu/" + superOptId + "/" + userCode + "?asAdmin=" + asAdmin), OptInfo.class);
    }

    public List<UserRole> listUserRoles(String userCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/userroles/" + userCode), UserRole.class);
    }

    public List<UserRole> listRoleUsers(String roleCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/roleusers/" + roleCode), UserRole.class);
    }

    public List<? extends IUnitRole> listUnitRoles(String unitCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/unitroles/" + unitCode), IUnitRole.class);
    }

    public List<? extends IUnitRole> listRoleUnits(String roleCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/roleunits/" + roleCode), IUnitRole.class);
    }

    public void changeUserPassword(String userCode, String userPassword) {
        HashMap<String, String> userInfo = new HashMap<String, String>();
        userInfo.put("userCode", userCode);
        userInfo.put("password", userPassword);
        userInfo.put("newPassword", userPassword);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)("/platform/changepassword/" + userCode), userInfo);
    }

    public boolean checkUserPassword(String userCode, String userPassword) {
        HashMap<String, String> userInfo = new HashMap<String, String>();
        userInfo.put("userCode", userCode);
        userInfo.put("password", userPassword);
        userInfo.put("newPassword", userPassword);
        String sret = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)("/platform/checkpassword/" + userCode), userInfo, (boolean)true);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)sret);
        return receiveJSON != null && BooleanBaseOpt.castObjectToBoolean((Object)receiveJSON.getData(), (Boolean)false) != false;
    }

    public List<UserInfo> listAllUsers() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/allusers/" + this.topOptId), UserInfo.class);
    }

    public List<UnitInfo> listAllUnits() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/allunits/" + this.topOptId), UnitInfo.class);
    }

    public List<UserUnit> listAllUserUnits() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/alluserunits/" + this.topOptId), UserUnit.class);
    }

    public List<UserUnit> listUserUnits(String userCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/userunits/" + this.topOptId + "/" + userCode), UserUnit.class);
    }

    public List<UserUnit> listUnitUsers(String unitCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/unitusers/" + this.topOptId + "/" + unitCode), UserUnit.class);
    }

    public List<? extends IRoleInfo> listAllRoleInfo() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/rolerepo/" + this.topOptId), RoleInfo.class);
    }

    public List<DataCatalog> listAllDataCatalogs() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/catalogs/" + this.topOptId), DataCatalog.class);
    }

    public List<DataDictionary> listDataDictionaries(String catalogCode) {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/dictionary/" + this.topOptId + "/" + catalogCode), DataDictionary.class);
    }

    public List<RolePower> listAllRolePower() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/allrolepowers/" + this.topOptId), RolePower.class);
    }

    public List<? extends IOptInfo> listAllOptInfo() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/optinforepo/" + this.topOptId), OptInfo.class);
    }

    public List<OptMethod> listAllOptMethod() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/alloptmethods/" + this.topOptId), OptMethod.class);
    }

    public List<? extends IOptDataScope> listAllOptDataScope() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)("/platform/alloptdatascopes/" + this.topOptId), OptDataScope.class);
    }

    private CentitUserDetails loadUserDetails(String queryParam, String qtype) {
        HttpReceiveJSON resJson = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)("/platform/userdetails/" + this.topOptId + "/" + queryParam + "?qtype=" + qtype));
        if (resJson == null || resJson.getCode() != 0) {
            return null;
        }
        JsonCentitUserDetails userDetails = (JsonCentitUserDetails)resJson.getDataAsObject("userDetails", JsonCentitUserDetails.class);
        userDetails.setUserUnits((JSONArray)resJson.getData("userUnits"));
        userDetails.setAuthoritiesByRoles(userDetails.getUserRoles());
        return userDetails;
    }

    public CentitUserDetails loadUserDetailsByLoginName(String loginName) {
        return this.loadUserDetails(loginName, "loginName");
    }

    public CentitUserDetails loadUserDetailsByUserCode(String userCode) {
        return this.loadUserDetails(userCode, "userCode");
    }

    public CentitUserDetails loadUserDetailsByRegEmail(String regEmail) {
        return this.loadUserDetails(regEmail, "regEmail");
    }

    public CentitUserDetails loadUserDetailsByRegCellPhone(String regCellPhone) {
        return this.loadUserDetails(regCellPhone, "regCellPhone");
    }

    public void updateUserInfo(IUserInfo userInfo) {
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/platform/userinfo", (Object)userInfo, (boolean)true);
    }

    public void insertOrUpdateMenu(List<? extends IOptInfo> optInfos, List<? extends IOptMethod> optMethods) {
        HashMap<String, List<Object>> param = new HashMap<String, List<Object>>(4);
        param.put("optInfos", optInfos);
        param.put("optMethods", optMethods);
        RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/platform/insertopt", param);
    }

    public List<? extends IOsInfo> listOsInfos() {
        return RestfulHttpRequest.getResponseObjectList((AppSession)this.appSession, (String)"/platform/ipenvironment/osinfo", OsInfo.class);
    }
}

