/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.dao;

import com.centit.framework.core.po.EntityWithDeleteTag;
import com.centit.framework.core.po.EntityWithTimestamp;
import com.centit.framework.hibernate.dao.DatabaseOptUtils;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.KeyValuePair;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.PersistenceException;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseDaoImpl<T extends Serializable, PK extends Serializable> {
    @Resource(name="sessionFactory")
    protected SessionFactory sessionFactory;
    protected static Logger logger = LoggerFactory.getLogger(BaseDaoImpl.class);
    protected Map<String, String> filterField = null;
    private Class<?> poClass = null;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public Session getCurrentSession() {
        Session s = this.sessionFactory.getCurrentSession();
        return s;
    }

    public Map<String, String> getFilterField() {
        return this.filterField;
    }

    private static ImmutablePair<String, String> parseParameter(String sParameter) {
        int e = sParameter.indexOf(41);
        if (e > 0) {
            int b = sParameter.indexOf(40) + 1;
            String paramPretreatment = sParameter.substring(b, e).trim();
            String paramAlias = sParameter.substring(e + 1).trim();
            return new ImmutablePair((Object)paramAlias, (Object)paramPretreatment);
        }
        return new ImmutablePair((Object)sParameter, null);
    }

    public static Map<String, Pair<String, String[]>> getFilterFieldWithPretreatment(Map<String, String> fieldMap) {
        if (fieldMap == null) {
            return null;
        }
        HashMap<String, Pair<String, String[]>> filterFieldWithPretreatment = new HashMap<String, Pair<String, String[]>>(fieldMap.size() * 2);
        for (Map.Entry<String, String> ent : fieldMap.entrySet()) {
            ImmutablePair<String, String> paramMeta = BaseDaoImpl.parseParameter(ent.getKey());
            String[] pretreatment = null;
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)paramMeta.getRight()))) {
                pretreatment = ((String)paramMeta.getRight()).split(",");
            }
            filterFieldWithPretreatment.put((String)paramMeta.left, (Pair<String, String[]>)new ImmutablePair((Object)ent.getValue(), (Object)pretreatment));
        }
        return filterFieldWithPretreatment;
    }

    public Class<?> getPoClass() {
        if (this.poClass == null) {
            ParameterizedType genType = (ParameterizedType)this.getClass().getGenericSuperclass();
            Type[] params = genType.getActualTypeArguments();
            this.poClass = (Class)params[0];
        }
        return this.poClass;
    }

    public Class<?> getPkClass() {
        ParameterizedType genType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] params = genType.getActualTypeArguments();
        return (Class)params[1];
    }

    public String getClassTName() {
        return this.getPoClass().getName();
    }

    public String getClassTShortName() {
        return this.getPoClass().getSimpleName();
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObject(T o) {
        if (o instanceof EntityWithDeleteTag) {
            ((EntityWithDeleteTag)o).setDeleted(true);
            this.saveObject(o);
        } else {
            try {
                this.sessionFactory.getCurrentSession().delete(o);
            }
            catch (RuntimeException re) {
                logger.error("delete failed", (Throwable)re);
                throw new PersistenceException(6, (Throwable)re);
            }
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObjectForce(T o) {
        try {
            this.sessionFactory.getCurrentSession().delete(o);
        }
        catch (RuntimeException re) {
            logger.error("delete failed", (Throwable)re);
            throw new PersistenceException(6, (Throwable)re);
        }
    }

    @Transactional
    public T getObjectById(PK id) {
        if (id == null) {
            return null;
        }
        try {
            return (T)((Serializable)this.getCurrentSession().get(this.getPoClass(), id));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObjectForceById(PK id) {
        T o = this.getObjectById(id);
        this.deleteObjectForce(o);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObjectById(PK id) {
        T o = this.getObjectById(id);
        this.deleteObject(o);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void saveNewObject(T o) {
        try {
            if (o instanceof EntityWithTimestamp) {
                EntityWithTimestamp ewto = (EntityWithTimestamp)o;
                ewto.setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            this.sessionFactory.getCurrentSession().save(o);
        }
        catch (RuntimeException re) {
            logger.error("save new object failed", (Throwable)re);
            throw new PersistenceException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> saveNewObjects(Collection<T> os) {
        try {
            ArrayList<Serializable> pks = new ArrayList<Serializable>();
            for (Serializable o : os) {
                if (o instanceof EntityWithTimestamp) {
                    EntityWithTimestamp ewto = (EntityWithTimestamp)o;
                    ewto.setLastModifyDate(DatetimeOpt.currentUtilDate());
                }
                pks.add(this.sessionFactory.getCurrentSession().save((Object)o));
            }
            return pks;
        }
        catch (RuntimeException re) {
            logger.error("save new object failed", (Throwable)re);
            throw new PersistenceException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> saveNewObjects(T[] os) {
        try {
            ArrayList<Serializable> pks = new ArrayList<Serializable>();
            for (T o : os) {
                if (o instanceof EntityWithTimestamp) {
                    EntityWithTimestamp ewto = (EntityWithTimestamp)o;
                    ewto.setLastModifyDate(DatetimeOpt.currentUtilDate());
                }
                pks.add(this.sessionFactory.getCurrentSession().save(o));
            }
            return pks;
        }
        catch (RuntimeException re) {
            logger.error("save new object failed", (Throwable)re);
            throw new PersistenceException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void updateRawObject(T o) {
        try {
            this.sessionFactory.getCurrentSession().update(o);
        }
        catch (RuntimeException re) {
            logger.error("save new object failed", (Throwable)re);
            throw new PersistenceException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void updateObject(T o) {
        try {
            if (o instanceof EntityWithTimestamp) {
                ((EntityWithTimestamp)o).setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            this.sessionFactory.getCurrentSession().update(o);
        }
        catch (RuntimeException re) {
            logger.error("save new object failed", (Throwable)re);
            throw new PersistenceException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void updateObjectProperties(T o, String ... properties) throws NoSuchFieldException {
        try {
            Serializable dbo = (Serializable)this.getCurrentSession().get(o.getClass(), (Serializable)BaseDaoImpl.getPoObjectId(o));
            if (dbo == null) {
                throw new PersistenceException(2, "\u88ab\u66f4\u6539\u5bf9\u8c61\u627e\u4e0d\u5230");
            }
            for (String p : properties) {
                ReflectionOpt.forceSetProperty((Object)dbo, (String)p, (Object)ReflectionOpt.forceGetProperty(o, (String)p));
            }
            if (dbo instanceof EntityWithTimestamp) {
                ((EntityWithTimestamp)dbo).setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            this.sessionFactory.getCurrentSession().update((Object)dbo);
        }
        catch (RuntimeException re) {
            logger.error("save new object failed", (Throwable)re);
            throw new PersistenceException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void updateObjectCheckTimestamp(T o) {
        try {
            if (o instanceof EntityWithTimestamp) {
                Serializable dbo = (Serializable)this.sessionFactory.getCurrentSession().get(o.getClass(), (Serializable)BaseDaoImpl.getPoObjectId(o));
                if (dbo == null) {
                    throw new PersistenceException(2, "\u88ab\u66f4\u6539\u5bf9\u8c61\u627e\u4e0d\u5230");
                }
                if (!((EntityWithTimestamp)o).getLastModifyDate().equals(((EntityWithTimestamp)dbo).getLastModifyDate())) {
                    String errorMsg = "save or update object  failed," + this.getClassTName() + ":" + o.toString() + " be modified out-sync.";
                    logger.error(errorMsg);
                    throw new PersistenceException(7, errorMsg);
                }
                ((EntityWithTimestamp)o).setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            this.sessionFactory.getCurrentSession().merge(o);
        }
        catch (RuntimeException re) {
            logger.error("save new object failed", (Throwable)re);
            throw new PersistenceException(7, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void updateObjectPropertiesCheckTimestamp(T o, String ... properties) throws NoSuchFieldException {
        try {
            Serializable dbo = (Serializable)this.getCurrentSession().get(o.getClass(), (Serializable)BaseDaoImpl.getPoObjectId(o));
            if (dbo == null) {
                throw new PersistenceException(2, "\u88ab\u66f4\u6539\u5bf9\u8c61\u627e\u4e0d\u5230");
            }
            if (o instanceof EntityWithTimestamp && !((EntityWithTimestamp)o).getLastModifyDate().equals(((EntityWithTimestamp)dbo).getLastModifyDate())) {
                String errorMsg = "save or update object failed," + this.getClassTName() + ":" + o.toString() + " be modified out-sync.";
                logger.error(errorMsg);
                throw new PersistenceException(errorMsg);
            }
            for (String p : properties) {
                ReflectionOpt.forceSetProperty((Object)dbo, (String)p, (Object)ReflectionOpt.forceGetProperty(o, (String)p));
            }
            if (dbo instanceof EntityWithTimestamp) {
                ((EntityWithTimestamp)dbo).setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            this.sessionFactory.getCurrentSession().update((Object)dbo);
        }
        catch (RuntimeException re) {
            logger.error("save new object failed", (Throwable)re);
            throw new PersistenceException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObjectsAsTabulation(Collection<T> dbObjects) {
        if (dbObjects == null || dbObjects.size() == 0) {
            return;
        }
        Date replaceTime = DatetimeOpt.currentUtilDate();
        Session session = this.getCurrentSession();
        for (Serializable deleteO : dbObjects) {
            if (deleteO instanceof EntityWithDeleteTag) {
                if (((EntityWithDeleteTag)deleteO).isDeleted()) continue;
                ((EntityWithDeleteTag)deleteO).setDeleted(true);
                if (deleteO instanceof EntityWithTimestamp) {
                    ((EntityWithTimestamp)deleteO).setLastModifyDate(replaceTime);
                }
                session.save((Object)deleteO);
                continue;
            }
            session.delete((Object)deleteO);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObjectsAsTabulation(String propertyName, Object propertyValue) {
        List<T> dbObjects = this.listObjectByProperty(propertyName, propertyValue);
        this.deleteObjectsAsTabulation(dbObjects);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void deleteObjectsAsTabulation(Map<String, Object> properties) {
        List<T> dbObjects = this.listObjectByProperties(properties);
        this.deleteObjectsAsTabulation(dbObjects);
    }

    public static Object getPoObjectId(Object poObj) {
        Field[] objFields;
        for (Field field : objFields = poObj.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(EmbeddedId.class)) continue;
            return ReflectionOpt.forceGetFieldValue((Object)poObj, (Field)field);
        }
        return null;
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> replaceObjectsAsTabulation(List<T> dbObjects, Collection<T> newObjects, boolean checkTimestamp) {
        if (newObjects == null) {
            throw new PersistenceException(2, "\u8bf7\u76f4\u63a5\u8c03\u7528\u5220\u9664\u64cd\u4f5c");
        }
        ArrayList<Serializable> pks = new ArrayList<Serializable>();
        Date replaceTime = DatetimeOpt.currentUtilDate();
        ArrayList<Serializable> deleteObjects = new ArrayList<Serializable>();
        ArrayList<Serializable> insertObjects = new ArrayList<Serializable>();
        ArrayList<Serializable> updateObjects = new ArrayList<Serializable>();
        ArrayList<KeyValuePair> updateObjectPairs = new ArrayList<KeyValuePair>();
        Session session = this.getCurrentSession();
        for (Serializable dbo : dbObjects) {
            boolean found = false;
            for (Serializable no : newObjects) {
                if (!session.getIdentifier((Object)dbo).equals(BaseDaoImpl.getPoObjectId(no))) continue;
                updateObjects.add(no);
                updateObjectPairs.add(new KeyValuePair((Object)no, (Object)dbo));
                found = true;
                break;
            }
            if (found) continue;
            deleteObjects.add(dbo);
        }
        for (Serializable no : newObjects) {
            if (updateObjects.contains(no)) continue;
            insertObjects.add(no);
        }
        for (KeyValuePair updateO : updateObjectPairs) {
            Serializable no = (Serializable)updateO.getKey();
            Serializable dbo = (Serializable)updateO.getValue();
            if (checkTimestamp && no instanceof EntityWithTimestamp && !((EntityWithTimestamp)no).getLastModifyDate().equals(((EntityWithTimestamp)dbo).getLastModifyDate())) {
                String errorMsg = "save or update object failed," + this.getClassTName() + ":" + no.toString() + " be modified out-sync.";
                logger.error(errorMsg);
                throw new PersistenceException(errorMsg);
            }
            BeanUtils.copyProperties((Object)no, (Object)dbo);
            if (no instanceof EntityWithTimestamp) {
                ((EntityWithTimestamp)dbo).setLastModifyDate(replaceTime);
            }
            session.update((Object)dbo);
            pks.add(session.getIdentifier((Object)dbo));
        }
        for (Serializable deleteO : deleteObjects) {
            if (deleteO instanceof EntityWithDeleteTag) {
                if (((EntityWithDeleteTag)deleteO).isDeleted()) continue;
                ((EntityWithDeleteTag)deleteO).setDeleted(true);
                if (deleteO instanceof EntityWithTimestamp) {
                    ((EntityWithTimestamp)deleteO).setLastModifyDate(replaceTime);
                    session.save((Object)deleteO);
                }
                session.save((Object)deleteO);
                continue;
            }
            session.delete((Object)deleteO);
        }
        for (Serializable insretO : insertObjects) {
            if (insretO instanceof EntityWithTimestamp) {
                EntityWithTimestamp ewto = (EntityWithTimestamp)insretO;
                ewto.setLastModifyDate(replaceTime);
            }
            pks.add(session.save((Object)insretO));
        }
        return pks;
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> replaceObjectsAsTabulation(Collection<T> newObjects, String propertyName, Object propertyValue) {
        List<T> dbObjects = this.listObjectByProperty(propertyName, propertyValue);
        return this.replaceObjectsAsTabulation(dbObjects, newObjects, false);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> replaceObjectsAsTabulation(Collection<T> newObjects, Map<String, Object> properties) {
        List<T> dbObjects = this.listObjectByProperties(properties);
        return this.replaceObjectsAsTabulation(dbObjects, newObjects, false);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> replaceObjectsAsTabulationCheckTimestamp(Collection<T> newObjects, String propertyName, Object propertyValue) {
        List<T> dbObjects = this.listObjectByProperty(propertyName, propertyValue);
        return this.replaceObjectsAsTabulation(dbObjects, newObjects, true);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public List<PK> replaceObjectsAsTabulationCheckTimestamp(Collection<T> newObjects, Map<String, Object> properties) {
        List<T> dbObjects = this.listObjectByProperties(properties);
        return this.replaceObjectsAsTabulation(dbObjects, newObjects, true);
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void mergeObject(T o) {
        try {
            if (o instanceof EntityWithTimestamp) {
                ((EntityWithTimestamp)o).setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            this.sessionFactory.getCurrentSession().merge(o);
        }
        catch (RuntimeException re) {
            logger.error("margin failed", (Throwable)re);
            throw new PersistenceException(6, (Throwable)re);
        }
    }

    @Transactional
    public void flush() {
        this.sessionFactory.getCurrentSession().flush();
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void saveRawObject(T o) {
        try {
            this.sessionFactory.getCurrentSession().saveOrUpdate(o);
        }
        catch (RuntimeException re) {
            logger.error("save or update failed", (Throwable)re);
            throw new PersistenceException(6, (Throwable)re);
        }
    }

    @Transactional(propagation=Propagation.MANDATORY)
    public void saveObject(T o) {
        try {
            if (o instanceof EntityWithTimestamp) {
                ((EntityWithTimestamp)o).setLastModifyDate(DatetimeOpt.currentUtilDate());
            }
            this.sessionFactory.getCurrentSession().saveOrUpdate(o);
        }
        catch (RuntimeException re) {
            logger.error("save or update failed", (Throwable)re);
            throw new PersistenceException(6, (Throwable)re);
        }
    }

    private String appendOrderBy(String shql) {
        String sOrderby;
        Map<String, String> filterFieldDesc = this.getFilterField();
        if (filterFieldDesc != null && !StringBaseOpt.isNvl((String)(sOrderby = filterFieldDesc.get("ORDER BY")))) {
            return shql + " order by " + sOrderby;
        }
        return shql;
    }

    @Transactional
    public List<T> listObjectsAll() {
        return this.listObjects();
    }

    @Transactional
    public List<T> listObjects() {
        String shql = this.appendOrderBy("From " + this.getClassTShortName());
        try {
            return this.getCurrentSession().createQuery(shql).list();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PersistenceException(6, (Throwable)e);
        }
    }

    private static ImmutableTriple<String, String, Object> makeSubQueryStmt(Map<String, Pair<String, String[]>> filterFieldDesc, String skey, Object objValue) {
        if (filterFieldDesc == null || objValue == null || StringUtils.isBlank((CharSequence)objValue.toString())) {
            return null;
        }
        Pair<String, String[]> sqlPair = filterFieldDesc.get(skey);
        if (sqlPair == null) {
            sqlPair = filterFieldDesc.get(skey.toUpperCase());
        }
        if (sqlPair == null || StringUtils.isBlank((CharSequence)((CharSequence)sqlPair.getLeft()))) {
            return null;
        }
        String sSqlFormat = (String)sqlPair.getLeft();
        if (skey.startsWith("NP_")) {
            return new ImmutableTriple((Object)sSqlFormat, null, null);
        }
        String[] pretreats = (String[])sqlPair.getRight();
        String[] paramObj = objValue;
        if (pretreats != null) {
            for (String p : pretreats) {
                if ("NP".equalsIgnoreCase(p)) {
                    return new ImmutableTriple((Object)sSqlFormat, null, null);
                }
                paramObj = QueryUtils.onePretreatParameter((String)p, (Object)paramObj);
            }
        }
        if (sSqlFormat.equalsIgnoreCase("LIKE")) {
            paramObj = QueryUtils.getMatchString((String)StringBaseOpt.objectToString((Object)paramObj));
            sSqlFormat = skey + " like :" + skey + " ";
        } else if (sSqlFormat.equalsIgnoreCase("EQUAL")) {
            sSqlFormat = skey + " = :" + skey + " ";
        } else if (sSqlFormat.equalsIgnoreCase("IN")) {
            sSqlFormat = skey + " in (:" + skey + ") ";
            String sValue = StringBaseOpt.objectToString((Object)objValue);
            if (sValue != null) {
                paramObj = sValue.split(",");
            }
        }
        return new ImmutableTriple((Object)sSqlFormat, (Object)skey, (Object)paramObj);
    }

    public static QueryAndNamedParams builderHqlAndNamedParams(String shql, Map<String, Object> filterDesc, Map<String, String> filterFieldDesc) {
        StringBuffer hql = new StringBuffer(shql);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        String sOrderby = null;
        String sOrderFiled = null;
        String sOrder = "asc";
        Map<String, Pair<String, String[]>> filterFieldWtihPretreatment = BaseDaoImpl.getFilterFieldWithPretreatment(filterFieldDesc);
        if (filterDesc != null) {
            for (Map.Entry<String, Object> ent : filterDesc.entrySet()) {
                if (ent.getValue() == null) continue;
                String skey = ent.getKey();
                if ("ORDER_BY".equalsIgnoreCase(skey)) {
                    sOrderby = QueryUtils.trimSqlOrderByField((String)ent.getValue().toString());
                    continue;
                }
                if ("sort".equalsIgnoreCase(skey)) {
                    sOrderFiled = QueryUtils.trimSqlOrderByField((String)ent.getValue().toString());
                    continue;
                }
                if ("order".equalsIgnoreCase(skey)) {
                    String stemp = ent.getValue().toString();
                    if (!"asc".equalsIgnoreCase(stemp) && !"desc".equalsIgnoreCase(stemp)) continue;
                    sOrder = stemp;
                    continue;
                }
                ImmutableTriple<String, String, Object> sqlPiece = BaseDaoImpl.makeSubQueryStmt(filterFieldWtihPretreatment, skey, ent.getValue());
                if (sqlPiece == null) continue;
                hql.append(" and ").append((String)sqlPiece.getLeft());
                if (sqlPiece.getMiddle() == null) continue;
                params.put(sqlPiece.getMiddle(), sqlPiece.getRight());
            }
        }
        if (sOrderFiled != null) {
            sOrderby = sOrderFiled + " " + sOrder;
        }
        if (sOrderby == null && filterFieldDesc != null) {
            sOrderby = filterFieldDesc.get("ORDER BY");
        }
        if (!StringBaseOpt.isNvl(sOrderby)) {
            hql.append(" order by ").append(sOrderby);
        }
        return new QueryAndNamedParams(hql.toString(), params);
    }

    public QueryAndNamedParams builderHqlAndNamedParams(String shql, Map<String, Object> filterDesc) {
        return BaseDaoImpl.builderHqlAndNamedParams(shql, filterDesc, this.getFilterField());
    }

    public QueryAndNamedParams builderStatHqlAndNamedParams(String shql, Map<String, Object> filterDesc) {
        StringBuilder hql = new StringBuilder(shql);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        Map<String, Pair<String, String[]>> filterFieldWtihPretreatment = BaseDaoImpl.getFilterFieldWithPretreatment(this.getFilterField());
        for (Map.Entry<String, Object> ent : filterDesc.entrySet()) {
            ImmutableTriple<String, String, Object> sqlPiece;
            String skey = ent.getKey();
            if ("ORDER_BY".equalsIgnoreCase(skey) || "sort".equalsIgnoreCase(skey) || "order".equalsIgnoreCase(skey) || (sqlPiece = BaseDaoImpl.makeSubQueryStmt(filterFieldWtihPretreatment, skey, ent.getValue())) == null) continue;
            hql.append(" and ").append((String)sqlPiece.getLeft());
            if (sqlPiece.getMiddle() == null) continue;
            params.put(sqlPiece.getMiddle(), sqlPiece.getRight());
        }
        return new QueryAndNamedParams(hql.toString(), params);
    }

    @Transactional
    public List<T> listValidObjects() {
        return this.listObjectByProperty("isvalid", "T");
    }

    @Transactional
    public List<T> listObjects(String hql) {
        try {
            return this.sessionFactory.getCurrentSession().createQuery(hql).list();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PersistenceException(6, (Throwable)e);
        }
    }

    @Transactional
    public List<T> listObjects(String shql, Object[] values, PageDesc pageDesc) {
        List<?> l = DatabaseOptUtils.findObjectsByHql(this, shql, values, pageDesc);
        return l;
    }

    @Transactional
    public List<T> listObjects(String shql, Object value, PageDesc pageDesc) {
        return this.listObjects(shql, new Object[]{value}, pageDesc);
    }

    @Transactional
    public List<T> listObjects(String shql, PageDesc pageDesc) {
        return this.listObjects(shql, (Object[])null, pageDesc);
    }

    @Transactional
    public List<T> listObjects(String shql, Object[] values) {
        try {
            Query q = this.getCurrentSession().createQuery(shql);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    q.setParameter(i, values[i]);
                }
            }
            return q.list();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PersistenceException(6, (Throwable)e);
        }
    }

    @Transactional
    public List<T> listObjects(String shql, Object value) {
        try {
            Query q = this.getCurrentSession().createQuery(shql);
            q.setParameter(0, value);
            return q.list();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PersistenceException(6, (Throwable)e);
        }
    }

    @Transactional
    public List<T> listObjects(String shql, Map<String, Object> filterDesc) {
        return this.listObjects(shql, filterDesc, null);
    }

    @Transactional
    public List<T> listObjects(Map<String, Object> filterDesc) {
        String shql = "From " + this.getClassTShortName() + " where 1=1 ";
        return this.listObjects(shql, filterDesc);
    }

    @Transactional
    public List<T> listObjectsByNamedHql(String shql, Map<String, Object> params, int startPos, int maxSize) {
        try {
            Query q = this.getCurrentSession().createQuery(shql);
            DatabaseOptUtils.setQueryParameters(q, params);
            if (maxSize > 0) {
                q.setMaxResults(maxSize);
            }
            if (startPos >= 0) {
                q.setFirstResult(startPos);
            }
            return q.list();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PersistenceException(6, (Throwable)e);
        }
    }

    public List<T> listObjectsByNamedHql(String shql, Map<String, Object> params, PageDesc pageDesc) {
        List<T> listObjs;
        int startPos = 0;
        int maxSize = 0;
        if (pageDesc != null) {
            startPos = pageDesc.getRowStart();
            maxSize = pageDesc.getPageSize();
        }
        if ((listObjs = this.listObjectsByNamedHql(shql, params, startPos, maxSize)) != null && pageDesc != null) {
            if (maxSize > 0) {
                Query q = this.getCurrentSession().createQuery("SELECT COUNT(*) " + QueryUtils.removeOrderBy((String)shql));
                DatabaseOptUtils.setQueryParameters(q, params);
                pageDesc.setTotalRows(Integer.valueOf(q.list().get(0).toString()));
            } else {
                pageDesc.setTotalRows(listObjs.size());
            }
        }
        return listObjs;
    }

    private List<T> listObjects(String shql, Map<String, Object> filterDesc, PageDesc pageDesc) {
        QueryAndNamedParams hql;
        List<T> listObjs;
        int startPos = 0;
        int maxSize = 0;
        if (pageDesc != null) {
            startPos = pageDesc.getRowStart();
            maxSize = pageDesc.getPageSize();
        }
        if ((listObjs = this.listObjectsByNamedHql((hql = this.builderHqlAndNamedParams(shql, filterDesc)).getQuery(), hql.getParams(), startPos, maxSize)) != null && pageDesc != null) {
            if (maxSize > 0) {
                Query q = this.getCurrentSession().createQuery("SELECT COUNT(*) " + QueryUtils.removeOrderBy((String)hql.getQuery()));
                Map params = hql.getParams();
                DatabaseOptUtils.setQueryParameters(q, params);
                pageDesc.setTotalRows(Integer.valueOf(q.list().get(0).toString()));
            } else {
                pageDesc.setTotalRows(listObjs.size());
            }
        }
        return listObjs;
    }

    @Transactional
    public int pageCount(String sHql, Map<String, Object> filterMap) {
        QueryAndNamedParams hql = this.builderHqlAndNamedParams(sHql, filterMap);
        Query q = this.getCurrentSession().createQuery("SELECT COUNT(*) " + QueryUtils.removeOrderBy((String)hql.getQuery()));
        Map params = hql.getParams();
        DatabaseOptUtils.setQueryParameters(q, params);
        Integer total = NumberBaseOpt.castObjectToInteger((Object)q.uniqueResult());
        return total == null ? 0 : total;
    }

    @Transactional
    public int pageCount(Map<String, Object> filterMap) {
        String sHql = "From " + this.getClassTShortName() + " where 1=1 ";
        return this.pageCount(sHql, filterMap);
    }

    @Transactional
    public List<T> pageQuery(String sHql, Map<String, Object> filterMap) {
        int startPos = 0;
        int maxSize = 0;
        if (filterMap != null) {
            startPos = NumberBaseOpt.castObjectToInteger((Object)filterMap.get("startRow"));
            maxSize = NumberBaseOpt.castObjectToInteger((Object)filterMap.get("maxSize"));
        }
        QueryAndNamedParams hql = this.builderHqlAndNamedParams(sHql, filterMap);
        return this.listObjectsByNamedHql(hql.getQuery(), hql.getParams(), startPos, maxSize);
    }

    @Transactional
    public List<T> pageQuery(Map<String, Object> filterMap) {
        String sHql = "From " + this.getClassTShortName() + " where 1=1 ";
        return this.pageQuery(sHql, filterMap);
    }

    @Transactional
    public List<T> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        String shql = "From " + this.getClassTShortName() + " where 1=1 ";
        return this.listObjects(shql, filterMap, pageDesc);
    }

    @Transactional
    public List<T> listObjectByProperty(String propertyName, Object propertyValue) {
        try {
            return this.listObjectsByNamedHql("From " + this.getClassTShortName() + " obj where obj." + propertyName + " = :" + propertyName, QueryUtils.createSqlParamsMap((Object[])new Object[]{propertyName, propertyValue}), -1, -1);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Transactional
    public List<T> listObjectByProperties(Map<String, Object> properties) {
        try {
            StringBuilder sHql = new StringBuilder("from " + this.getClassTShortName() + " obj where ");
            int nPs = 0;
            for (Map.Entry<String, Object> ent : properties.entrySet()) {
                if (nPs > 0) {
                    sHql.append(" and");
                }
                ++nPs;
                sHql.append(" obj.").append(ent.getKey()).append("=:").append(ent.getKey());
            }
            return this.listObjectsByNamedHql(sHql.toString(), properties, -1, -1);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Transactional
    public T getObjectByProperty(String propertyName, Object propertyValue) {
        List<T> l = this.listObjectByProperty(propertyName, propertyValue);
        if (l == null || l.size() == 0) {
            return null;
        }
        return (T)((Serializable)l.get(0));
    }

    @Transactional
    public T getObjectByProperties(Map<String, Object> properties) {
        List<T> l = this.listObjectByProperties(properties);
        if (l == null || l.size() == 0) {
            return null;
        }
        return (T)((Serializable)l.get(0));
    }
}

