/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.dao;

import com.centit.framework.core.dao.DataPowerFilter;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Table;
import javax.persistence.metamodel.EntityType;
import org.hibernate.SessionFactory;
import org.springframework.web.context.ContextLoaderListener;

public class HibernatePowerFilter
extends DataPowerFilter {
    private static Map<String, Map<String, String>> hqlMetaData;

    public static Map<String, Map<String, String>> getHqlMetaData() {
        if (hqlMetaData == null) {
            hqlMetaData = new HashMap<String, Map<String, String>>();
            SessionFactory sessionFactory = (SessionFactory)ContextLoaderListener.getCurrentWebApplicationContext().getBean("sessionFactory", SessionFactory.class);
            Set cm = sessionFactory.getMetamodel().getEntities();
            for (EntityType ent : cm) {
                Field[] objFields;
                HashMap<String, String> metaData = new HashMap<String, String>();
                String entityName = ent.getName();
                Class poClass = ent.getJavaType();
                Table tableName = poClass.getAnnotation(Table.class);
                metaData.put(".talbeName", tableName.name());
                for (Field field : objFields = poClass.getDeclaredFields()) {
                    Field[] idFields;
                    if (field.isAnnotationPresent(Column.class)) {
                        Column colMeta = field.getAnnotation(Column.class);
                        metaData.put(field.getName(), colMeta.name());
                        continue;
                    }
                    if (!field.isAnnotationPresent(EmbeddedId.class)) continue;
                    String sId = field.getName() + ".";
                    Class<?> idClass = field.getType();
                    for (Field idfield : idFields = idClass.getDeclaredFields()) {
                        if (!idfield.isAnnotationPresent(Column.class)) continue;
                        Column colMeta = idfield.getAnnotation(Column.class);
                        metaData.put(sId + idfield.getName(), colMeta.name());
                    }
                }
                Class supClass = poClass.getSuperclass();
                while (!supClass.equals(Object.class)) {
                    Field[] supFields;
                    for (Field supfield : supFields = supClass.getDeclaredFields()) {
                        if (!supfield.isAnnotationPresent(Column.class)) continue;
                        Column colMeta = supfield.getAnnotation(Column.class);
                        metaData.put(supfield.getName(), colMeta.name());
                    }
                    supClass = supClass.getSuperclass();
                }
                hqlMetaData.put(entityName, metaData);
            }
        }
        return hqlMetaData;
    }

    public QueryAndNamedParams makeHQL(Class<?> poClass, Collection<String> filters, boolean jointSql) {
        String shortClassName = poClass.getSimpleName();
        return this.makeHQL(shortClassName, filters, jointSql);
    }

    public QueryAndNamedParams makeHQL(String shortClassName, Collection<String> filters, boolean jointSql) {
        QueryAndNamedParams hqlAndParams = new QueryAndNamedParams();
        HashMap<String, String> tables = new HashMap<String, String>();
        tables.put(shortClassName, "");
        DataPowerFilter.DataPowerFilterTranslater translater = new DataPowerFilter.DataPowerFilterTranslater(false, jointSql, (DataPowerFilter)this);
        translater.setTableAlias(tables);
        StringBuilder hql = new StringBuilder("From ").append(shortClassName).append(" where");
        boolean hasFilter = false;
        if (filters != null) {
            for (String filter : filters) {
                QueryAndNamedParams hqlPiece = QueryUtils.translateQueryFilter((String)filter, (QueryUtils.IFilterTranslater)translater);
                if (hqlPiece == null) continue;
                hqlAndParams.addAllParams(hqlPiece.getParams());
                if (hasFilter) {
                    hql.append(" or");
                } else {
                    hql.append(" (");
                }
                hql.append(" ").append(hqlPiece.getHql());
                hasFilter = true;
            }
        }
        if (hasFilter) {
            hql.append(" )");
        } else {
            hql.append(" 1=1");
        }
        hqlAndParams.setHql(hql.toString());
        return hqlAndParams;
    }
}

