/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.hibernate.dao;

import com.centit.framework.hibernate.dao.BaseDaoImpl;
import com.centit.support.database.ddl.DB2DDLOperations;
import com.centit.support.database.ddl.DDLOperations;
import com.centit.support.database.ddl.MySqlDDLOperations;
import com.centit.support.database.ddl.OracleDDLOperations;
import com.centit.support.database.ddl.SqlSvrDDLOperations;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DBType;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class DDLOperationsWork
implements DDLOperations {
    private BaseDaoImpl<?, ?> baseDao;

    public DDLOperationsWork() {
    }

    public DDLOperationsWork(BaseDaoImpl<?, ?> baseDao) {
        this.baseDao = baseDao;
    }

    public void setBaseDao(BaseDaoImpl<?, ?> baseDao) {
        this.baseDao = baseDao;
    }

    private DDLOperations createDDLOpt(Connection connection) {
        DBType dbtype = DBType.mapDBType((Connection)connection);
        switch (dbtype) {
            case Oracle: {
                return new OracleDDLOperations(connection);
            }
            case DB2: {
                return new DB2DDLOperations(connection);
            }
            case SqlServer: {
                return new SqlSvrDDLOperations(connection);
            }
            case MySql: {
                return new MySqlDDLOperations(connection);
            }
        }
        return new OracleDDLOperations(connection);
    }

    public void createSequence(String sequenceName) throws SQLException {
        this.baseDao.getCurrentSession().doWork(connection -> this.createDDLOpt(connection).createSequence(sequenceName));
    }

    public void createTable(TableInfo tableInfo) throws SQLException {
        this.baseDao.getCurrentSession().doWork(connection -> this.createDDLOpt(connection).createTable(tableInfo));
    }

    public void dropTable(String tableCode) throws SQLException {
        this.baseDao.getCurrentSession().doWork(connection -> this.createDDLOpt(connection).dropTable(tableCode));
    }

    public void addColumn(String tableCode, TableField column) throws SQLException {
        this.baseDao.getCurrentSession().doWork(connection -> this.createDDLOpt(connection).addColumn(tableCode, column));
    }

    public void modifyColumn(String tableCode, TableField column) throws SQLException {
        this.baseDao.getCurrentSession().doWork(connection -> this.createDDLOpt(connection).modifyColumn(tableCode, column));
    }

    public void dropColumn(String tableCode, String columnCode) throws SQLException {
        this.baseDao.getCurrentSession().doWork(connection -> this.createDDLOpt(connection).dropColumn(tableCode, columnCode));
    }

    public void renameColumn(String tableCode, String columnCode, TableField column) throws SQLException {
        this.baseDao.getCurrentSession().doWork(connection -> this.createDDLOpt(connection).renameColumn(tableCode, columnCode, column));
    }

    public void reconfigurationColumn(String tableCode, String columnCode, TableField column) throws SQLException {
        this.baseDao.getCurrentSession().doWork(connection -> this.createDDLOpt(connection).reconfigurationColumn(tableCode, columnCode, column));
    }

    public String makeCreateSequenceSql(String sequenceName) {
        return (String)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDDLOpt(connection).makeCreateSequenceSql(sequenceName));
    }

    public String makeCreateTableSql(TableInfo tableInfo) {
        return (String)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDDLOpt(connection).makeCreateTableSql(tableInfo));
    }

    public String makeDropTableSql(String tableCode) {
        return (String)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDDLOpt(connection).makeDropTableSql(tableCode));
    }

    public String makeAddColumnSql(String tableCode, TableField column) {
        return (String)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDDLOpt(connection).makeAddColumnSql(tableCode, column));
    }

    public String makeModifyColumnSql(String tableCode, TableField column) {
        return (String)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDDLOpt(connection).makeModifyColumnSql(tableCode, column));
    }

    public String makeDropColumnSql(String tableCode, String columnCode) {
        return (String)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDDLOpt(connection).makeDropColumnSql(tableCode, columnCode));
    }

    public String makeRenameColumnSql(String tableCode, String columnCode, TableField column) {
        return (String)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDDLOpt(connection).makeRenameColumnSql(tableCode, columnCode, column));
    }

    public List<String> makeReconfigurationColumnSqls(String tableCode, String columnCode, TableField column) {
        return (List)this.baseDao.getCurrentSession().doReturningWork(connection -> this.createDDLOpt(connection).makeReconfigurationColumnSqls(tableCode, columnCode, column));
    }
}

